#define type(M) mem[M].hh.hh2.b0
#define subtype(M) mem[M].hh.hh2.b1

#define font type
#define character subtype
#define is_char_node(M) (M >= hi_mem_min)

pointer new_null_box (void);

#define HLIST_NODE   0
#define VLIST_NODE   1

#define BOX_NODE_SIZE  7
#define WIDTH_OFFSET  1
#define DEPTH_OFFSET  2
#define HEIGHT_OFFSET  3
#define SHIFT_OFFSET  4
#define LIST_OFFSET   5
#define GLUE_OFFSET   6
#define width(B)   mem[B + WIDTH_OFFSET].sc
#define depth(B)   mem[B + DEPTH_OFFSET].sc
#define height(B)   mem[B + HEIGHT_OFFSET].sc
#define shift_amount(B)  mem[B + SHIFT_OFFSET].sc
#define list_ptr(B)   link(B + LIST_OFFSET)
#define glue_order(B)  subtype(B + LIST_OFFSET)
#define glue_sign(B)  type(B + LIST_OFFSET)
#define glue_set(B)   mem[B + GLUE_OFFSET].gr

#define NORMAL    0
#define STRETCHING   1
#define SHRINKING   2
 
pointer new_rule (void);

#define RULE_NODE   2
#define RULE_NODE_SIZE  4
#define NULL_FLAG   -010000000000
#define is_running(R)  (R == NULL_FLAG)

#define INS_NODE   3
#define INS_NODE_SIZE  5
#define float_cost(I)  mem[I + 1].i
#define ins_ptr(I)   info(I + 4)
#define split_top_ptr(I) link(I + 4)
 
#define MARK_NODE   4
#define SMALL_NODE_SIZE  2
#define mark_ptr(M)   link(M + 1)
 
#define ADJUST_NODE   5
#define adjust_ptr   mark_ptr

pointer new_ligature (quarterword f, quarterword c, pointer q);
pointer new_lig_item (quarterword c);

#define LIGATURE_NODE  6
#define lig_char(L)   L + 1
#define lig_ptr(L)   link(lig_char(L))

pointer new_disc (void);

#define DISC_NODE   7
#define replace_count  subtype
#define pre_break   llink
#define post_break   rlink

#define WHATSIT_NODE  8

pointer new_math (scaled w, int s);

#define MATH_NODE   9
#define BEFORE    0
#define AFTER    1

#define precedes_break(M) (type(M) < MATH_NODE)
#define non_discardable(M) (type(M) < MATH_NODE)

pointer new_spec (pointer p);
pointer new_param_glue (int n);
pointer new_glue (pointer q);
pointer new_skip_param (int n);

#define GLUE_NODE   10
#define COND_MATH_GLUE  98
#define MU_GLUE    99
#define A_LEADERS   100
#define C_LEADERS   101
#define X_LEADERS   102
#define glue_ptr   llink
#define leader_ptr   rlink

#define GLUE_SPEC_SIZE  4
#define glue_ref_count(G) link(G)
#define stretch(G)   mem[G + 2].sc
#define shrink(G)   mem[G + 3].sc
#define stretch_order  type
#define shrink_order  subtype
enum {
FIL    = 1,
FILL   = 2,
FILLL  = 3
};


pointer new_kern (scaled w);

#define KERN_NODE   11
#define EXPLICIT   1
#define ACC_KERN   2

pointer new_penalty (integer m);

#define PENALTY_NODE  12
#define INF_PENALTY   10000L
#define EJECT_PENALTY  -INF_PENALTY
#define penalty(P)   mem[P + 1].i

#define UNSET_NODE   13
#define span_count   subtype
#define glue_stretch(U)  mem[U + GLUE_OFFSET].sc
#define glue_shrink   shift_amount

int print_short_display();
void print_font_and_char (integer p);
void print_mark (integer p);
void print_rule_dimen (scaled d);
void print_glue (scaled d, integer o, char *s);
void print_spec (integer p, char *s);

#define node_list_display(N) \
 {append_char('.'); show_node_list(N); flush_char();}

extern int     font_in_short_display;
extern integer depth_threshold;
extern integer breadth_max;
extern int     words;

void show_node_list (pointer p);
void show_box (pointer p);
void show_info (void);
void short_display (pointer p);
void show_glue_set (pointer p);

pointer copy_node_list (pointer p);
void flush_node_list (pointer p);

void delete_glue_ref (pointer p);
#define fast_delete_glue_ref(G) \
 {if (glue_ref_count(G) == NULL) \
  free_node(G, GLUE_SPEC_SIZE); \
 else decr(glue_ref_count(G));}
#define add_glue_ref(G) \
 incr(glue_ref_count(G))
