/*
#define ESCAPE    0
#define RELAX    0
#define LEFT_BRACE   1
#define RIGHT_BRACE   2
#define MATH_SHIFT   3
#define TAB_MARK   4
#define CAR_RET    5
#define OUT_PARAM   5
#define MAC_PARAM   6
#define SUP_MARK   7
#define SUB_MARK   8
#define IGNORE    9
#define ENDV    9
#define SPACER    10
#define LETTER    11
#define OTHER_CHAR   12
#define ACTIVE_CHAR   13
#define PAR_END    13
#define MATCH    13
#define COMMENT    14
#define END_MATCH   14
#define STOP    14
#define INVALID_CHAR  15
#define DELIM_NUM   15
#define MAX_CHAR_CODE  15
#define CHAR_NUM   16
#define MATH_CHAR_NUM  17
#define MARK    18
#define XRAY    19
#define MAKE_BOX   20
#define HMOVE    21
#define VMOVE    22
#define UN_HBOX    23
#define UN_VBOX    24
#define REMOVE_ITEM   25
#define HSKIP    26
#define VSKIP    27
#define MSKIP    28
#define KERN    29
#define MKERN    30
#define LEADER_SHIP   31
#define HALIGN    32
#define VALIGN    33
#define NO_ALIGN   34
#define VRULE    35
#define HRULE    36
#define INSERT    37
#define VADJUST    38
#define IGNORE_SPACES  39
#define AFTER_ASSIGNMENT 40
#define AFTER_GROUP   41
#define BREAK_PENALTY  42
#define START_PAR   43
#define ITAL_CORR   44
#define ACCENT    45
#define MATH_ACCENT   46
#define DISCRETIONARY  47
#define EQ_NO    48
#define LEFT_RIGHT   49
#define MATH_COMP   50
#define LIMIT_SWITCH  51
#define ABOVE    52
#define MATH_STYLE   53
#define MATH_CHOICE   54
#define NON_SCRIPT   55
#define VCENTER    56
#define CASE_SHIFT   57
#define MESSAGE    58
#define EXTENSION   59
#define IN_STREAM   60
#define BEGIN_GROUP   61
#define END_GROUP   62
#define OMIT    63
#define EX_SPACE   64
#define RADICAL    65
#define END_CS_NAME   66
#define MIN_INTERNAL  67
#define CHAR_GIVEN   67
#define MATH_GIVEN   68
#define LAST_ITEM   69

#define MAX_NON_PREFIXED_COMMAND 69

#define TOKS_REGISTER  70
#define ASSIGN_TOKS   71
#define ASSIGN_INT   72
#define ASSIGN_DIMEN  73
#define ASSIGN_GLUE   74
#define ASSIGN_MU_GLUE  75
#define ASSIGN_FONT_DIMEN 76
#define ASSIGN_FONT_INT  77
#define SET_AUX    78
#define SET_PREV_GRAF  79
#define SET_PAGE_DIMEN  80
#define SET_PAGE_INT  81
#define SET_BOX_DIMEN  82
#define SET_SHAPE   83
#define DEF_CODE   84
#define DEF_FAMILY   85
#define SET_FONT   86
#define DEF_FONT   87
#define REGISTER   88
#define MAX_INTERNAL  88
#define ADVANCE    89
#define MULTIPLY   90
#define DIVIDE    91
#define PREFIX    92
#define LET     93
#define SHORTHAND_DEF  94
#define READ_TO_CS   95
#define DEF     96
#define SET_BOX    97
#define HYPH_DATA   98
#define SET_INTERACTION  99
#define MAX_COMMAND   99

#define UNDEFINED_CS  (MAX_COMMAND + 1)
#define EXPAND_AFTER  (MAX_COMMAND + 2)
#define NO_EXPAND   (MAX_COMMAND + 3)
#define INPUT    (MAX_COMMAND + 4)
#define IF_TEST    (MAX_COMMAND + 5)
#define FI_OR_ELSE   (MAX_COMMAND + 6)
#define CS_NAME    (MAX_COMMAND + 7)
#define CONVERT    (MAX_COMMAND + 8)
#define THE     (MAX_COMMAND + 9)
#define TOP_BOT_MARK  (MAX_COMMAND + 10)
#define CALL    (MAX_COMMAND + 11)
#define LONG_CALL   (MAX_COMMAND + 12)
#define OUTER_CALL   (MAX_COMMAND + 13)
#define LONG_OUTER_CALL  (MAX_COMMAND + 14)
#define END_TEMPLATE  (MAX_COMMAND + 15)
#define DONT_EXPAND   (MAX_COMMAND + 16)
#define GLUE_REF   (MAX_COMMAND + 17)
#define SHAPE_REF   (MAX_COMMAND + 18)
#define BOX_REF    (MAX_COMMAND + 19)
#define DATA    (MAX_COMMAND + 20)
*/

enum {
  ESCAPE  = 0,
  RELAX = 0,
  LEFT_BRACE =1,
  RIGHT_BRACE =  2,
  MATH_SHIFT  = 3,
  TAB_MARK  = 4,
  CAR_RET   = 5,
  OUT_PARAM =  5,
  MAC_PARAM =  6,
  SUP_MARK  = 7,
  SUB_MARK  = 8,
  IGNORE    =9,
  ENDV    =9,
  SPACER  =  10,
  LETTER  =  11,
  OTHER_CHAR =  12,
  ACTIVE_CHAR =  13,
  PAR_END   = 13,
  MATCH   = 13,
  COMMENT  =  14,
  END_MATCH =  14,
  STOP   = 14,
  INVALID_CHAR = 15,
  DELIM_NUM  = 15,
  MAX_CHAR_CODE = 15,
  CHAR_NUM  = 16,
  MATH_CHAR_NUM = 17,
  MARK   = 18,
  XRAY   = 19,
  MAKE_BOX =  20,
  HMOVE   = 21,
  VMOVE   = 22,
  UN_HBOX  =  23,
  UN_VBOX   = 24,
  REMOVE_ITEM =  25,
  HSKIP   = 26,
  VSKIP   = 27,
  MSKIP   = 28,
  KERN    =29,
  MKERN   = 30,
  LEADER_SHIP =  31,
  HALIGN  =  32,
  VALIGN   = 33,
  NO_ALIGN  = 34,
  VRULE    =35,
  HRULE  =  36,
  INSERT  =  37,
  VADJUST  =  38,
  IGNORE_SPACES = 39,
  AFTER_ASSIGNMENT =40,
  AFTER_GROUP  = 41,
  BREAK_PENALTY = 42,
  START_PAR  = 43,
  ITAL_CORR  = 44,
  ACCENT   = 45,
  MATH_ACCENT =  46,
  DISCRETIONARY = 47,
  EQ_NO  =  48,
  LEFT_RIGHT =  49,
  MATH_COMP  = 50,
  LIMIT_SWITCH = 51,
  ABOVE  =  52,
  MATH_STYLE =  53,
  MATH_CHOICE =  54,
  NON_SCRIPT  = 55,
  VCENTER   = 56,
  CASE_SHIFT =  57,
  MESSAGE   = 58,
  EXTENSION =  59,
  IN_STREAM  = 60,
  BEGIN_GROUP =  61,
  END_GROUP  = 62,
  OMIT   = 63,
  EX_SPACE=   64,
  RADICAL  =  65,
  END_CS_NAME =  66,
  MIN_INTERNAL = 67,
  CHAR_GIVEN  = 67,
  MATH_GIVEN  = 68,
  LAST_ITEM  = 69,

  MAX_NON_PREFIXED_COMMAND =69,

  TOKS_REGISTER  =70,
  ASSIGN_TOKS  = 71,
  ASSIGN_INT   =72,
  ASSIGN_DIMEN = 73,
  ASSIGN_GLUE  = 74,
  ASSIGN_MU_GLUE = 75,
  ASSIGN_FONT_DIMEN = 76,
  ASSIGN_FONT_INT = 77,
  SET_AUX   = 78,
  SET_PREV_GRAF = 79,
  SET_PAGE_DIMEN = 80,
  SET_PAGE_INT = 81,
  SET_BOX_DIMEN = 82,
  SET_SHAPE  = 83,
  DEF_CODE  = 84,
  DEF_FAMILY =  85,
  SET_FONT =  86,
  DEF_FONT =  87,
  REGISTER =  88,
  MAX_INTERNAL = 88,
  ADVANCE   = 89,
  MULTIPLY   =90,
  DIVIDE   = 91,
  PREFIX   = 92,
  LET    = 93,
  SHORTHAND_DEF =  94,
  READ_TO_CS  = 95,
  DEF    = 96,
  SET_BOX =   97,
  HYPH_DATA =  98,
  SET_INTERACTION = 99,
  MAX_COMMAND  = 99,

  UNDEFINED_CS = (MAX_COMMAND + 1),
  EXPAND_AFTER = (MAX_COMMAND + 2),
  NO_EXPAND  = (MAX_COMMAND + 3),
  INPUT   = (MAX_COMMAND + 4),
  IF_TEST  =  (MAX_COMMAND + 5),
  FI_OR_ELSE =  (MAX_COMMAND + 6),
  CS_NAME   = (MAX_COMMAND + 7),
  CONVERT  =  (MAX_COMMAND + 8),
  THE    = (MAX_COMMAND + 9),
  TOP_BOT_MARK = (MAX_COMMAND + 10),
  CALL =   (MAX_COMMAND + 11),
  LONG_CALL =  (MAX_COMMAND + 12),
  OUTER_CALL =  (MAX_COMMAND + 13),
  LONG_OUTER_CALL = (MAX_COMMAND + 14),
  END_TEMPLATE = (MAX_COMMAND + 15),
  DONT_EXPAND  = (MAX_COMMAND + 16),
  GLUE_REF  = (MAX_COMMAND + 17),
  SHAPE_REF =  (MAX_COMMAND + 18),
  BOX_REF  =  (MAX_COMMAND + 19),
  DATA   = (MAX_COMMAND + 20)
};


void show_cur_cmd_chr (void);
void print_cmd_chr (qword cmd, hword chr_code);
void init_cmds (void);
