extern byte_file dvi_file;

enum {
  SET_CHAR_0 = 0,
  SET1       = 128,
  SET2       = 129,
  SET3       = 130,
  SET4       = 131,
  SET_RULE   = 132,
  PUT1       = 133,
  PUT_RULE   = 137,
  NOP        = 138,
  BOP        = 139,
  EOP        = 140,
  PUSH       = 141,
  POP        = 142,
  RIGHT1     = 143,
  W0         = 147,
  W1         = 148,
  X0         = 152,
  X1         = 153,
  DOWN1      = 157,
  Y0         = 161,
  Y1         = 162,
  Z0         = 166,
  Z1         = 167,
  FNT_NUM_0  = 171,
  FNT1       = 235,
  XXX1       = 239,
  XXX4       = 242,
  FNT_DEF1   = 243,
  PRE        = 247,
  POST       = 248,
  POST_POST  = 249,
  DIRCHG     = 255,
  ID_BYTE    = 2
};

extern quarterword  c;
extern quarterword  f;
extern pointer      g;
extern int          dead_cycles;
extern bool         doing_leaders;
extern integer      last_bop;
extern integer      lq;
extern integer      lr;
extern integer      lx;
extern scaled       max_h;
extern scaled       max_v;
extern int          max_push;
extern scaled       rule_ht;
extern scaled       rule_dp;
extern scaled       rule_wd;

extern internal_font_number  dvi_f;
extern scaled  dvi_h;
extern scaled  dvi_v;
extern scaled  cur_h;
extern scaled  cur_v;
extern int     cur_s;

extern pointer down_ptr;
extern pointer right_ptr;

extern byte  dvi_buf[];
extern pointer   dvi_limit; 
extern pointer   dvi_ptr;
extern integer   dvi_offset;
extern integer   dvi_gone;
extern bool  output_active;
extern int   total_pages;

#define MOVEMENT_NODE_SIZE  3
#define location(L)    mem[L + 2].i

#define synch_h() \
{if (cur_h != dvi_h) \
  {movement(cur_h - dvi_h, RIGHT1); dvi_h = cur_h;}}

#define synch_v() \
{if (cur_v != dvi_v) \
  {movement(cur_v - dvi_v, DOWN1); dvi_v = cur_v;}}

#define dvi_out(B) \
{dvi_buf[dvi_ptr] = B; \
  incr(dvi_ptr); \
  if (dvi_ptr == dvi_limit) \
  dvi_swap();}

#define write_dvi(a, b) \
{fwrite(&dvi_buf[a], sizeof(dvi_buf[0]), b - a, dvi_file);}


void dvi_swap (void);
void dvi_four (integer x);
void dvi_pop (integer l);
void dvi_font_def (internal_font_number f);
void movement (scaled w, byte o);
void prune_movements (integer l);
void hlist_out (void);
void vlist_out (void);
void ship_out (pointer p);
