extern pointer  save_ptr;
extern mword save_stack[];
extern pointer  max_save_stack;

extern quarterword cur_level;
extern group_code cur_group;
extern pointer  cur_boundary;

#define save_type(S)   save_stack[S].hh.hh2.b0
#define save_level(S)   save_stack[S].hh.hh2.b1
#define save_index(S)   save_stack[S].hh.hh2.rh

enum {
  RESTORE_OLD_VALUE = 0,
  RESTORE_ZERO  = 1,
  INSERT_TOKEN  = 2,
  LEVEL_BOUNDARY  = 3
};

enum {
  BOTTOM_LEVEL  = 0,
  SIMPLE_GROUP  = 1,
  HBOX_GROUP   = 2,
  ADJUSTED_HBOX_GROUP = 3,
  VBOX_GROUP   = 4,
  VTOP_GROUP   = 5,
  ALIGN_GROUP   = 6,
  NO_ALIGN_GROUP  = 7,
  OUTPUT_GROUP  = 8,
  MATH_GROUP   = 9,
  DISC_GROUP   = 10,
  INSERT_GROUP  = 11,
  VCENTER_GROUP  = 12,
  MATH_CHOICE_GROUP = 13,
  SEMI_SIMPLE_GROUP = 14,
  MATH_SHIFT_GROUP = 15,
  MATH_LEFT_GROUP  = 16,
  MAX_GROUP_CODE  = 16
};
#define saved(I) save_stack[save_ptr + I].i

void new_save_level (group_code c);
void eq_destroy (mword w);
void eq_save (pointer p, quarterword l);
void eq_define (pointer p, quarterword t, halfword e);
void eq_word_define (pointer p, integer w);
void geq_define (pointer p, quarterword t, halfword e);
void geq_word_define (pointer p, integer w);
void save_for_after (halfword t);
void unsave (void);
void off_save (void);

#ifdef STAT
void restore_trace (pointer p, char *s);
#endif
