#include "tex.h"
#include "heap.h"
#include "eq.h"
#include "scan.h"
#include "evalstack.h"
#include "arith.h"
#include "str.h"
#include "box.h"
#include "tfm.h"
#include "print.h"
#include "pack.h"
#include "math.h"

two_halves empty_field;

/* sec 688 */
pointer new_style (int s)
{
  pointer p;

  p = get_node(STYLE_NODE_SIZE);
  type(p) = STYLE_NODE;
  subtype(p) = s;
  width(p)= 0;
  depth(p) = 0;

  return p;
}

/* sec 689 */
pointer new_choice (void)
{
  pointer p;

  p = get_node(STYLE_NODE_SIZE);
  type(p) = CHOICE_NODE;
  subtype(p) = 0;
  display_mlist(p) = NULL;
  text_mlist(p) = NULL;
  script_mlist(p) = NULL;
  script_script_mlist(p) = NULL;

  return p;
}

/* sec 686 */
pointer new_noad (void)
{
  pointer p;

  p = get_node(NOAD_SIZE);
  type(p) = ORD_NOAD;
  subtype(p) = NORMAL;
  mem[nucleus(p)].hh = empty_field;
  mem[subscr(p)].hh = empty_field;
  mem[supscr(p)].hh = empty_field;

  return p;
}

/* sec 691 */
void print_fam_and_char (pointer p)
{
  print_esc("fam");
  print_int(fam(p));
  print_char(' ');
  print_ASCII(qo(character(p)));
}

/* sec 691 */
void print_delimiter (pointer p)
{
  integer a;

  a = small_fam(p) * 256 + qo(small_char(p));
  a = a * 0x1000 + large_fam(p) * 256 + qo(large_char(p));
  if (a < 0)
    print_val(a);
  else print_hex(a);
}

/* sec 692 */
void print_subsidiary_data (pointer p, ASCII_code c)
{
  if (cur_length() >= depth_threshold) {
    if (math_type(p) != EMPTY)
      print(" []");
    return;
  }
  append_char(c);
  temp_ptr = p;
  switch (math_type(p))
  {
    case MATH_CHAR:
      print_ln();
      print_current_string();
      print_fam_and_char(p);
      break;

    case SUB_BOX:
      show_info();
      break;

    case SUB_MLIST:
      if (info(p) == NULL) {
        print_ln();
        print_current_string();
        print("{}");
      } else show_info();
      break;
  }
  flush_char();
}

/* sec 694 */
void print_style (int c)
{
  switch (c / 2) 
  {
    case 0:
      print_esc("displaystyle");
      break;

    case 1:
      print_esc("textstyle");
      break;

    case 2:
      print_esc("scriptstyle");
      break;

    case 3:
      print_esc("scriptscriptstyle");
      break;

    default:
      print("Unknown style!");
      break;
  }
}

/* sec 699 */
void print_size (int s)
{
  if (s == 0)
    print_esc("textfont");
  else if (s == SCRIPT_SIZE)
    print_esc("scriptfont");
  else 
    print_esc("scriptscriptfont");
}

/* sec 704 */
pointer fraction_rule (scaled t)
{
  pointer p;

  p = new_rule();
  height(p) = t;
  depth(p) = 0;

  return p;
}

/* sec 705 */
pointer overbar (pointer b, scaled k, scaled t)
{
  pointer p, q;

  p = new_kern(k);
  link(p) = b;
  q = fraction_rule(t);
  link(q) = p;
  p = new_kern(t);
  link(p) = q;
  return (vpack(p, NATURAL));
}

/* sec 706 - 710 */
pointer var_delimiter (pointer d, int s, scaled v)
{
  pointer b;
  internal_font_number f, g;
  quarterword c, x, y;
  int m, n;
  scaled u;
  scaled w;
  four_quarters q;
  eight_bits hd;
  four_quarters r;
  int  z;
  bool large_attempt;

  f = NULL_FONT;
  w = 0;
  large_attempt = FALSE;
  z = small_fam(d);
  x = small_char(d);
  loop {
    if (z != 0 || x != MIN_QUARTERWORD) {
      z = z + s + 16;
      do {
        z = z - 16;
        g = fam_fnt(z);
        if (g != NULL_FONT) {
          y = x;
contin:
          if (qo(y) >= font_bc[g] && qo(y) <= font_ec[g]) {
            q = char_info(g, y);
            if (char_exists(q)) {
              if (char_tag(q) == EXT_TAG)  {
                f = g;
                c = y;
                goto found;
              }
              hd = height_depth(q);
              u = char_height(g, hd) + char_depth(g, hd);
              if (u > w) {
                f = g;
                c = y;
                w = u;
                if (u >= v)
                  goto found;
              }
              if (char_tag(q) == LIST_TAG) {
                y = rem_byte(q);
                goto contin;
              }
            }
          }
        }
      } while (z >= 16);
    }
    if (large_attempt)
      goto found;
    large_attempt = TRUE;
    z = large_fam(d);
    x = large_char(d);
  }

found:
  if (f != NULL_FONT) {
    if (char_tag(q) == EXT_TAG) {
      b = new_null_box();
      type(b) = VLIST_NODE;
      r = font_info[exten_base[f] + rem_byte(q)].qqqq;
      c = ext_rep(r);
      u = height_plus_depth(f, c);
      w = 0;
      q = char_info(f, c);
      width(b) = char_width(f, q) + char_italic(f, q);
      c = ext_bot(r); 
      if (c != MIN_QUARTERWORD)
        w += height_plus_depth(f, c);
      c = ext_mid(r);
      if (c != MIN_QUARTERWORD)
        w += height_plus_depth(f, c);
      c = ext_top(r);
      if (c != MIN_QUARTERWORD)
        w += height_plus_depth(f, c);
      n = 0;
      if (u > 0) {
        while (w < v) {
          w = w + u;
          incr(n);
          if (ext_mid(r) != MIN_QUARTERWORD)
            w = w + u;
        }
      }
      c = ext_bot(r);
      if (c != MIN_QUARTERWORD)
        stack_into_box(b, f, c);
      c = ext_rep(r);
      for (m = 1; m <= n; incr(m)) 
        stack_into_box(b, f, c);
      c = ext_mid(r);
      if (c != MIN_QUARTERWORD) {
        stack_into_box(b, f, c);
        c = ext_rep(r);
        for (m = 1; m <= n; incr(m))
          stack_into_box(b, f, c);
      }
      c = ext_top(r);
      if (c != MIN_QUARTERWORD)
        stack_into_box(b, f, c);
      depth(b) = w - height(b);
    } else
      b = char_box(f, c);
  } else {
    b = new_null_box();
    width(b) = null_delimiter_space;
  }
  shift_amount(b) = half(height(b) - depth(b)) - axis_height(s);
  return b;
}

/* sec 709 */
pointer char_box (internal_font_number f, quarterword c)
{
  pointer b;
  pointer p;
  four_quarters q;
  byte hd;

  q = char_info(f, c);
  hd = height_depth(q);
  b = new_null_box();
  width(b) = char_width(f, q) + char_italic(f, q);
  height(b) = char_height(f, hd);
  depth(b) = char_depth(f, hd);
  p = get_avail();
  character(p) = c;
  font(p) = f;
  list_ptr(b) = p;

  return b;
}

/* sec 711 */
void stack_into_box (pointer b, internal_font_number f, quarterword c)
{
  pointer p;

  p = char_box(f, c);
  link(p) = list_ptr(b);
  list_ptr(b) = p;
  height(b) = height(p);
}

/* sec 712 */
scaled height_plus_depth (internal_font_number f, quarterword c)
{
  four_quarters q;
  byte hd;

  q = char_info(f, c);
  hd = height_depth(q);
  return (char_height(f, hd) + char_depth(f, hd));
}
/* sec 715 */
pointer rebox (pointer b, scaled w)
{
  internal_font_number  f;
  pointer p;
  scaled v;

  if (width(b) != w && list_ptr(b) != NULL) {
    if (type(b) == VLIST_NODE)
      b = hpack(b, NATURAL);
    p = list_ptr(b);
    if (is_char_node(p) && link(p) == NULL) {
      f = font(p);
      v = char_width(f, char_info(f, character(p)));
      if (v != width(b)) 
        link(p) = new_kern(width(b) - v);
    }
    free_node(b, BOX_NODE_SIZE);
    b = new_glue(ss_glue);
    link(b) = p;
    while (link(p) != NULL)
      p = link(p);
    link(p) = new_glue(ss_glue); 
    return (hpack(b, w, EXACTLY));
  } else {
    width(b) = w;
    return b;
  }
}

#define mu_mult(x) \
  nx_plus_y(n, x, xn_over_d(x, f, 0200000L))

/* sec 716 */
pointer math_glue (pointer g, scaled m)
{
  scaled f;
  integer n;
  pointer p;

  n = x_over_n(m, 0200000L);
  f = texremainder;
  p = get_node(GLUE_SPEC_SIZE);
  width(p) = mu_mult(width(g));
  stretch_order(p) = stretch_order(g);
  if (stretch_order(p) == NORMAL)
    stretch(p) = mu_mult(stretch(g));
  else 
    stretch(p) = stretch(g);
  shrink_order(p) = shrink_order(g);
  if (shrink_order(p) == NORMAL)
    shrink(p) = mu_mult(shrink(g));
  else 
    shrink(p) = shrink(g);

  return p;
}

/* sec 717 */
void math_kern (pointer p, scaled m)
{
  scaled f;
  integer n;

  if (subtype(p) == MU_GLUE) {
    n = x_over_n(m, 0200000L);
    f = texremainder;
    if (f < 0) {
      decr(n);
      f += 0200000L;
    }
    width(p) = mu_mult(width(p));
    subtype(p) = NORMAL;
  }
}

/* sec 718 */
void flush_math (void)
{
  flush_node_list(link(head));
  flush_node_list(incompleat_noad);
  link(head) = NULL;
  tail = head;
  incompleat_noad = NULL;
}
