#define last_active   active

enum {
  VERY_LOOSE_FIT = 0,
  LOOSE_FIT      = 1,
  DECENT_FIT     = 2,
  TIGHT_FIT      = 3
};

#define ACTIVE_NODE_SIZE 3
#define UNHYPHENATED  0
#define HYPHENATED   1
#define fitness    subtype
#define break_node   rlink
#define line_number   llink
#define total_demerits(D) mem[(D) + 2].i

#define PASSIVE_NODE_SIZE 2
#define cur_break   rlink
#define prev_break   llink
#define next_break   prev_break
#define serial    info

#define DELTA_NODE   2
#define DELTA_NODE_SIZE  7

#define do_all_six(F) \
 {F(1); F(2); F(3); F(4); F(5); F(6);}

extern pointer  just_box;

#ifdef STAT
void show_break_node (pointer q, int f, int h);
void show_break_status (pointer r, bool a, integer b, integer p, integer d);
void update_printed_node(void);
#endif
void set_break_width (int break_type);

void line_break (integer final_widow_penalty);

extern pointer  passive;
extern pointer  printed_node;
extern pointer  pass_number;

extern scaled active_width[];
extern scaled cur_active_width[];
extern scaled background[];
extern scaled break_width[];
extern bool no_shrink_error_yet;

pointer finite_shrink (pointer p);

extern pointer  cur_p;
extern bool second_pass;
extern integer  threshold;

void try_break (integer pi, int break_type);

#define AWFUL_BAD   07777777777

extern integer  minimal_demerits[];
extern integer  minimum_demerits;
extern pointer  best_place[];
extern halfword best_pl_line[];

extern halfword easy_line;
extern halfword last_special_line;
extern scaled first_width;
extern scaled second_width;
extern scaled first_indent;
extern scaled second_indent;
extern scaled disc_width;
extern pointer  best_bet;
extern integer  fewest_demerits;
extern halfword best_line;
extern integer  actual_looseness;
extern int  line_diff;

void post_line_break (integer final_widow_penalty);
