extern byte_file  tfm_file;

extern mword font_info[];
extern pointer  fmem_ptr;

extern four_quarters null_character;

extern four_quarters font_check[];
extern scaled font_size[];
extern scaled font_dsize[];
extern halfword font_params[];
extern str  font_name[];
extern str  font_area[];
extern byte font_bc[];
extern byte font_ec[];
extern pointer  font_glue[];
extern bool font_used[];
extern int  hyphen_char[];
extern int  skew_char[];

extern int  char_base[];
extern int  width_base[];
extern int  height_base[];
extern int  depth_base[];
extern int  italic_base[];
extern int  lig_kern_base[];
extern int  kern_base[];
extern int  exten_base[];
extern int  param_base[];

extern internal_font_number font_ptr;

#define char_exists(CI) \
 ((CI).b0 > MIN_QUARTERWORD)

#define char_info(F, C) \
 font_info[char_base[F] + (C)].qqqq

#define char_width(F, CI) \
 font_info[width_base[F] + CI.b0].sc

#define char_height(F, CB) \
 font_info[height_base[F] + (CB) / 16].sc

#define char_depth(F, CB) \
 font_info[depth_base[F] + (CB) % 16].sc

#define char_italic(F, CI) \
 font_info[italic_base[F] + qo(CI.b2) / 4].sc

enum {
NO_TAG   = 0,
LIG_TAG  = 1,
LIST_TAG = 2,
EXT_TAG  = 3
};

#define stop_bit(M)   M.b0
#define next_char(M)  M.b1
#define op_bit(M)   M.b2
#define rem_byte(M)   M.b3
#define STOP_FLAG   128
#define KERN_FLAG   128

#define ext_top(M)   M.b0
#define ext_mid(M)   M.b1
#define ext_bot(M)   M.b2
#define ext_rep(W)   W.b3

#define char_tag(CI) \
 qo(CI.b2) % 4

#define height_depth(CI) \
 qo(CI.b1)

#define lig_kern_start(F, CI) \
 lig_kern_base[F] + rem_byte(CI)

#define char_kern(F, CI) \
 font_info[kern_base[F] + rem_byte(CI)].sc

enum {
SLANT_CODE   = 1,
SPACE_CODE   = 2,
SPACE_STRETCH_CODE = 3,
SPACE_SHRINK_CODE = 4,
X_HEIGHT_CODE = 5,
QUAD_CODE  = 6,
EXTRA_SPACE_CODE = 7
};

#define param(F, CODE) \
 font_info[param_base[F] + CODE].sc

#define slant(F) \
 param(F, SLANT_CODE)

#define space(F) \
 param(F, SPACE_CODE)

#define space_stretch(F) \
 param(F, SPACE_STRETCH_CODE)

#define space_shrink(F) \
 param(F, SPACE_SHRINK_CODE)

#define x_height(F) \
 param(F, X_HEIGHT_CODE)

#define quad(F) \
 param(F, QUAD_CODE)

#define extra_space(F) \
 param(F, EXTRA_SPACE_CODE)

internal_font_number read_font_info (internal_font_number u, str nom, str aire, scaled s);
void find_font_dimen (bool writing);
void scan_font_ident (void);
void char_warning (internal_font_number f, byte c);
pointer new_character (internal_font_number f, byte c);
void init_tfm (void);
