typedef struct
{
  quarterword state_field;
  quarterword index_field;
  halfword start_field;
  halfword loc_field;
  halfword limit_field;
  halfword name_field;
} input;

extern input cur_input;
extern input input_stack[];
extern pointer  input_ptr;
extern pointer  max_in_stack;

#define state   cur_input.state_field
#define index   cur_input.index_field
#define start   cur_input.start_field
#define loc     cur_input.loc_field
#define limit   cur_input.limit_field
#define name    cur_input.name_field

#define MID_LINE  1
#define SKIP_BLANKS  (2 + MAX_CHAR_CODE)
#define NEW_LINE  (3 + MAX_CHAR_CODE + MAX_CHAR_CODE)

#define terminal_input (name == 0)

extern alpha_file input_file[];

extern pointer  in_open;
extern integer  line;
extern integer  line_stack[];

#define cur_file input_file[index]

#define TOKEN_LIST   0
#define param_start   limit
#define token_type   index

enum {
PARAMETER  = 0,
U_TEMPLATE  = 1,
V_TEMPLATE  = 2,
BACKED_UP  = 3,
INSERTED  = 4,
MACRO   = 5,
OUTPUT_TEXT  = 6,
EVERY_PAR_TEXT = 7,
EVERY_MATH_TEXT = 8,
EVERY_DISPLAY_TEXT = 9,
EVERY_HBOX_TEXT = 10,
EVERY_VBOX_TEXT = 11,
EVERY_JOB_TEXT = 12,
EVERY_CR_TEXT = 13,
MARK_TEXT  = 14,
WRITE_TEXT  = 15
};

extern pointer  param_ptr;
extern pointer  param_stack[];
extern pointer  max_param_stack;

void runaway (void);
void show_context (void);

extern integer  align_state;
extern pointer  base_ptr;
extern pointer  def_ref;
extern pointer  warning_index;
extern int  scanner_status;

enum {
SKIPPING = 1,
DEFINING = 2,
MATCHING = 3,
ALIGNING = 4,
ABSORBING = 5
};

#define set_trick_count() \
{first_count = tally; \
  trick_count = tally + 1 + ERROR_LINE - HALF_ERROR_LINE; \
  if (trick_count < ERROR_LINE) \
  trick_count = ERROR_LINE;}

#define magic_c() set_trick_count()

void push_input(void);
void pop_input(void);

void begin_token_list (pointer p, quarterword t);
void end_token_list (void);

#define back_list(L) begin_token_list(L, BACKED_UP)
#define ins_list(L)  begin_token_list(L, INSERTED)

void back_input (void);
void back_error (void);

void begin_file_reading (void);
void end_file_reading (void);

void clear_for_error_prompt (void);
