#include "stdafx.h"
#include "q2chwmCommon.h"
#include "MainFrm.h"
#include "q2chwmConnectionManager.h"

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
#include <initguid.h>
#include <connmgr.h>
#include <connmgr_proxy.h>
#include <ras.h>
#include <raserror.h>
#endif

Cq2chwmConnectionManager::Cq2chwmConnectionManager()
{
	m_hConnection = NULL;
}

Cq2chwmConnectionManager::~Cq2chwmConnectionManager()
{
}

BOOL Cq2chwmConnectionManager::Connect(
	int in_index)
{
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	CONNMGR_CONNECTIONINFO ci;
	CONNMGR_DESTINATION_INFO di;
	memset(&ci, 0x00, sizeof(ci));
	memset(&di, 0x00, sizeof(di));

	ci.cbSize = sizeof(ci);
	ci.dwParams = CONNMGR_PARAM_GUIDDESTNET;
	//ci.dwFlags = GetProxy() ? CONNMGR_FLAG_PROXY_HTTP: 0;
	ci.dwPriority = CONNMGR_PRIORITY_USERINTERACTIVE;
	if (in_index >= 0 && SUCCEEDED(ConnMgrEnumDestinations(in_index, &di))) {
		ci.guidDestNet = di.guid;
	} else {
		ci.guidDestNet = IID_DestNetInternet;
	}

	HRESULT hr = ConnMgrEstablishConnection(&ci, &m_hConnection);
	if (FAILED(hr)) {
		return FALSE;
	} else {
		BOOL bStop = FALSE;
		int in_timeout = 0;
		while (bStop == FALSE && Canceled() == FALSE) {
			DWORD dwResult = WaitForSingleObject(m_hConnection, 1000);
			DWORD dwStatus;
			if (dwResult == WAIT_OBJECT_0) {
				HRESULT hr = ConnMgrConnectionStatus(m_hConnection, &dwStatus);
				if( SUCCEEDED(hr) && (dwStatus == CONNMGR_STATUS_CONNECTED)) {
					bStop = TRUE;
				} else {
					MessageLoop();
				}
			} else {
				MessageLoop();
			}
			in_timeout++;
			if (in_timeout > TIMEOUT) {
				PRINTLOG("TIMEOUT: [%d][0x%x]", hr, dwStatus);
				return FALSE;
			}
		}
	}
#endif
	return TRUE;
}

BOOL Cq2chwmConnectionManager::Disconnect()
{
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)

	if (m_hConnection != NULL) {
		HRESULT hr = ConnMgrReleaseConnection(m_hConnection, FALSE);
		if (FAILED(hr)) {
			return FALSE;
		}
		m_hConnection = NULL;
	}

	RASCONN *stpRasConn = (RASCONN*)malloc(sizeof(RASCONN));;
	memset(stpRasConn, 0x00, sizeof(RASCONN));
	stpRasConn->dwSize = sizeof(RASCONN);
	DWORD nSize = sizeof(RASCONN);
	DWORD nCount = 0;

	switch (::RasEnumConnections(stpRasConn, &nSize, &nCount)) {
	case 0:
		break;
	case ERROR_BUFFER_TOO_SMALL:
		// Ď擾
		if (nSize > 0) {
			stpRasConn = (RASCONN*)realloc(stpRasConn, nSize);
			stpRasConn->dwSize = sizeof(RASCONN);
			if (::RasEnumConnections(stpRasConn, &nSize, &nCount) != 0) {
				// G[
				free(stpRasConn);
				return FALSE;
			}
		}
		break;
	default:
		// G[
		free(stpRasConn);
		return FALSE;
	}

	for (DWORD i = 0; i < nCount; i++) {
		::RasHangUp(stpRasConn[i].hrasconn);
		RASCONNSTATUS status;
		status.dwSize = sizeof(RASCONNSTATUS);
		while (1) {
			if (RasGetConnectStatus(stpRasConn[i].hrasconn, &status) == ERROR_INVALID_HANDLE) {
				break;
			}
			Sleep(1000);
		}
	}
	free(stpRasConn);

	HANDLE hConn = NULL;
	CONNMGR_CONNECTIONINFO ConnInfo = {0};
	ConnInfo.cbSize = sizeof(ConnInfo);
	ConnInfo.bDisabled = true;
	ConnMgrEstablishConnectionSync(&ConnInfo, &hConn, INFINITE, NULL);
	ConnMgrReleaseConnection(hConn, FALSE);
#endif
	return TRUE;
}

BOOL Cq2chwmConnectionManager::IsConnected(
	int in_index)
{
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	BOOL bRet = FALSE;
	HANDLE hConn = NULL;
	CONNMGR_CONNECTIONINFO ci;
	CONNMGR_DESTINATION_INFO di;
	memset(&ci, 0x00, sizeof(ci));
	memset(&di, 0x00, sizeof(di));

	ci.cbSize = sizeof(ci);
	ci.dwParams = CONNMGR_PARAM_GUIDDESTNET|CONNMGR_PARAM_MAXCONNLATENCY;
	//ci.dwFlags = bProxy?CONNMGR_FLAG_PROXY_HTTP:0;
	ci.ulMaxConnLatency = 4000;         // 4 second
	ci.bDisabled = TRUE;
	ci.dwPriority = CONNMGR_PRIORITY_USERINTERACTIVE;
	if (in_index >= 0 && SUCCEEDED(ConnMgrEnumDestinations(in_index, &di))) {
		ci.guidDestNet = di.guid;
	} else {
		ci.guidDestNet = IID_DestNetInternet;
	}

	HRESULT hr = ConnMgrEstablishConnection(&ci, &hConn);
	if (SUCCEEDED(hr)) {
		DWORD dwResult = WaitForSingleObject(hConn, 400);
		switch (dwResult) {
		case WAIT_OBJECT_0:
			DWORD dwStatus;
			hr = ConnMgrConnectionStatus(hConn, &dwStatus);
			if( SUCCEEDED(hr) && (dwStatus == CONNMGR_STATUS_CONNECTED || dwStatus == CONNMGR_STATUS_CONNECTIONDISABLED)) {
				bRet = TRUE;
			} else{
				PRINTLOG("ConnMgrConnectionStatus: [0x%x]", dwStatus);
				bRet = FALSE;
			}
			break;
		case WAIT_TIMEOUT:
			bRet = FALSE;
		}
		ConnMgrReleaseConnection(hConn, FALSE);
	}
	return bRet;
#else
	return TRUE;
#endif
}

BOOL Cq2chwmConnectionManager::Canceled()
{
	CMainFrame *pMain = (CMainFrame*)AfxGetMainWnd();
	return pMain->Canceled();
}
