/*
 * nEdit
 *
 * nEdit.h
 *
 * Copyright (C) 1996-2005 by Nakashima Tomoaki. All rights reserved.
 *		http://www.nakka.com/
 *		nakka@nakka.com
 */

#ifndef _INC_NEDIT_H
#define _INC_NEDIT_H

/* Include Files */
#include <windows.h>
#include <tchar.h>
#ifdef OP_XP_STYLE
#include <uxtheme.h>
#include <tmschema.h>
#endif	// OP_XP_STYLE

/* Define */
#define NEDIT_WND_CLASS					TEXT("nEdit")

#define WM_GETBUFFERINFO				(WM_APP + 1)
#define WM_REFLECT						(WM_APP + 2)
#define WM_GETWORDWRAP					(WM_APP + 3)
#define WM_SETWORDWRAP					(WM_APP + 4)
#define WM_GETMEMSIZE					(WM_APP + 5)
#define WM_GETMEM						(WM_APP + 6)
#define WM_SETMEM						(WM_APP + 7)

// added by FujitaYOSHITOMO
#ifndef EM_GETSELTEXT
#define EM_GETSELTEXT					(WM_APP + 9)
#endif
#define EM_GETLINEEND					(WM_APP + 10)
#define Q2CH_SETDRAWPROC				(WM_APP + 1000)
#define Q2CH_SETGETCOLORPROC			(WM_APP + 1001)
#define Q2CH_SETBEFOREWINDOWPROC		(WM_APP + 1002)
#define Q2CH_SETAFTERWINDOWPROC			(WM_APP + 1003)
// `̃R[obN֐`
enum {
	COLOR_FORE = 0,
	COLOR_BACK
};
typedef BOOL (*Q2CH_DRAWPROC)(HWND hWnd, HDC hDC, int in_left, int in_top, RECT *rect, const TCHAR *lpszText, int in_len, BOOL sel, const void *vop_user);
typedef BOOL (*Q2CH_GETCOLORPROC)(int in_id, COLORREF *color, const void *vop_user);
typedef BOOL (*Q2CH_WINDOWPROC)(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam, const void *vop_user);
// added end

#define EM_GETREADONLY					(WM_APP + 100)

#ifndef EM_REDO
#define EM_REDO							(WM_USER + 84)
#endif
#ifndef EM_CANREDO
#define EM_CANREDO						(WM_USER + 85)
#endif

#define UNDO_TYPE_INPUT					1
#define UNDO_TYPE_DELETE				2

/* Struct */
typedef struct _UNDO {
	BYTE type;

	DWORD st;
	DWORD len;
	TCHAR *buf;
} UNDO;

typedef struct _BUFFER {
	// ێĂe
	TCHAR *buf;
	DWORD buf_size;
	DWORD buf_len;

	// ̓obt@
	TCHAR *input_buf;
	DWORD input_size;
	DWORD input_len;

	// \s̃ItZbg
	DWORD *line;
	int line_size;
	int line_len;
	int line_add_index;
	int line_add_len;

	// UNDOobt@
	UNDO *undo;
	int undo_size;
	int undo_len;
	int undo_pos;

	// ͊Jnʒu
	TCHAR *ip;
	DWORD ip_len;
	// 폜Jnʒu
	TCHAR *dp;
	DWORD del_len;

	// Lbg̈ʒu
	DWORD cp;
	// Iʒu
	DWORD sp;
	// ㉺ړ̃LbgXW
	int cpx;

	// 1s̕
	int line_max;
	// s̍ő啝
	int line_width;
	// EBhE̕
	int width;

	// XN[ o[
	int pos_x;
	int max_x;
	int pos_y;
	int max_y;

	// ^uXgbv
	int tab_stop;
	// }[W
	int left_margin;
	// }[W
	int top_margin;
	// E}[W
	int right_margin;
	// }[W
	int bottom_margin;
	// s
	int spacing;

	// `p
	HDC mdc;
	HBITMAP ret_bmp;
	HRGN hrgn;
	HFONT hfont;
	HFONT ret_font;

	// tHg
	int font_height;
	int char_width;

	// ܂ԂtO
	BOOL wordwrap;
	// tH[JXĂI\
	BOOL no_hide_sel;
	// ɕϊ
	BOOL lowercase;
	// 啶ɕϊ
	BOOL uppercase;
	// bNtO
	BOOL lock;
	// CtO
	BOOL modified;
	// ̓[h
	BOOL insert_mode;
	// ItO
	BOOL sel;
	// }EXtO
	BOOL mousedown;
	// ͒
	DWORD limit_len;

	// ̕
	//BYTE cwidth[256];

	// Rg[ʎq
	int id;
	// IME
	HIMC himc;
#ifdef OP_XP_STYLE
	// XP
	HMODULE hModThemes;
	HTHEME hTheme;
#endif	// OP_XP_STYLE

	// added by FujitaYOSHITOMO
	void *draw_proc_data;
	Q2CH_DRAWPROC draw_proc;
	void *getcolor_proc_data;
	Q2CH_GETCOLORPROC getcolor_proc;
	void *before_window_proc_data;
	Q2CH_WINDOWPROC before_window_proc;
	void *after_window_proc_data;
	Q2CH_WINDOWPROC after_window_proc;
	// added end

} BUFFER;

// q2chg
typedef struct _NEDITMSG {
	UINT msg;
	WPARAM wParam;
	LPARAM lParam;
} NEDITMSG;
// ptH[}XAbv̂ߒڌĂׂ悤ɂ
DWORD line_get(const BUFFER *bf, const int lindex);
int line_get_length(const BUFFER *bf, const DWORD index);
TCHAR *index_to_char(const BUFFER *bf, const DWORD index);
void nedit_clear_cache();
BOOL string_insert(const HWND hWnd, BUFFER *bf, TCHAR *str, const int len, const BOOL insert_mode);
BOOL string_flush(BUFFER *bf, const BOOL undo_flag);
int get_buffer_length(BUFFER *bf);

/* Function Prototypes */
BOOL nedit_regist(const HINSTANCE hInstance);
#endif
/* End of source */
