#pragma once

#include "q2chwmListView.h"
#include "q2chwmBookmarkBoardFile.h"

// Cq2chwmBookmarkBoardView r[

class Cq2chwmBookmarkBoardView : public Cq2chwmListView
{
//	DECLARE_DYNCREATE(Cq2chwmBookmarkBoardView)
private:
	Cq2chwmBookmarkBoardFile m_cFile;
	BOOL m_bo_multiselect;
	BOOL m_bo_create;

private:
	BOOL readDirectory(const char *chp_dir, int& in_index);
	BOOL addItem(int in_index, const char *chp_filename, const char *chp_date);

protected:
	void SortItems(int in_col, BOOL bo_asc);
	virtual BOOL GetItemText(LPTSTR wchp_text, int in_size, int in_row, int in_col);

public:
	Cq2chwmBookmarkBoardView();           // IŎgp protected RXgN^
	virtual ~Cq2chwmBookmarkBoardView();

	BOOL CreateFromFile();
	BOOL Reload();
	void SetFont();
	void OnListClicked();
	void Sort();
	void Search(const char *chp_word);
	BOOL AddItem(const char *chp_bname, const char *chp_bid, const char *chp_burl);
	Cq2chwmListItem *GetSelectedItem();
	Cq2chwmListItem *GetItem(int iRow);
	virtual void CopyInformation();

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnInitialUpdate();
public:
	afx_msg void OnDestroy();
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
public:
	afx_msg void OnSortBname();
	afx_msg void OnUpdateSortBname(CCmdUI *pCmdUI);
	afx_msg void OnSortIndex();
	afx_msg void OnUpdateSortIndex(CCmdUI *pCmdUI);
	afx_msg void OnSortSearch();
	afx_msg void OnUpdateSortSearch(CCmdUI *pCmdUI);
	afx_msg void OnAdjustColumnWidth();
protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
};


