// q2chwmPageImage.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmPageImage.h"
#include "q2chwmConfig.h"
#include "q2chwmLayoutManager.h"

// Cq2chwmPageImage _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageImage, CDialog)

Cq2chwmPageImage::Cq2chwmPageImage(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageImage::IDD, pParent)
	, m_bo_useimageview(FALSE)
	, m_bo_inlineimage(FALSE)
	, m_in_inlineimageheight(0)
{
	m_bo_useimageview = Cq2chwmConfig::GetInstance()->GetUseImageView();
	m_bo_inlineimage = Cq2chwmConfig::GetInstance()->GetInlineImage();
	m_in_inlineimageheight = Cq2chwmConfig::GetInstance()->GetInlineImageHeight();
	m_bo_viewafterdownload = Cq2chwmConfig::GetInstance()->GetViewAfterDownload();
}

Cq2chwmPageImage::~Cq2chwmPageImage()
{
}

void Cq2chwmPageImage::DoDataExchange(CDataExchange* pDX)
{
	DDX_Check(pDX, IDC_CHECK_USEIMAGEVIEW, m_bo_useimageview);
	DDX_Check(pDX, IDC_CHECK_INLINEIMAGE, m_bo_inlineimage);
	DDX_Text(pDX, IDC_COMBO_INLINEIMAGEHEIGHT, m_in_inlineimageheight);
	DDX_Check(pDX, IDC_CHECK_VIEWAFTERDOWNLOAD, m_bo_viewafterdownload);
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageImage, Cq2chwmConfigPage)
	ON_WM_SIZE()
END_MESSAGE_MAP()


// Cq2chwmPageImage bZ[W nh

BOOL Cq2chwmPageImage::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmPageImage::OnSize(UINT nType, int cx, int cy)
{
	Cq2chwmConfigPage::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_USEIMAGEVIEW), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_VIEWAFTERDOWNLOAD), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_INLINEIMAGE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_INLINEIMAGEHEIGHT), 3, GetDlgItem(IDC_COMBO_INLINEIMAGEHEIGHT), 1)
	);
	cLayout.Layout(cx, cy);
}

void Cq2chwmPageImage::Write()
{
	UpdateData(TRUE);
	Cq2chwmConfig::GetInstance()->SetUseImageView(m_bo_useimageview);
	Cq2chwmConfig::GetInstance()->SetInlineImage(m_bo_inlineimage);
	Cq2chwmConfig::GetInstance()->SetInlineImageHeight(m_in_inlineimageheight);
	Cq2chwmConfig::GetInstance()->SetViewAfterDownload(m_bo_viewafterdownload);
}
