// q2chwmPageNetworkWrite.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmPageNetworkWrite.h"
#include "q2chwmConfig.h"
#include "q2chwmLayoutManager.h"

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
#include <connmgr.h>
#include <connmgr_proxy.h>
#endif // WIN32_PLATFORM_PSPC

// Cq2chwmPageNetworkWrite _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageNetworkWrite, CDialog)

Cq2chwmPageNetworkWrite::Cq2chwmPageNetworkWrite(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageNetworkWrite::IDD, pParent)
{
	m_cstr_proxy_host = Cq2chwmConfig::GetInstance()->GetWriteProxyHost();
	m_in_proxy_port = Cq2chwmConfig::GetInstance()->GetWriteProxyPort();
	m_cstr_proxy_id = Cq2chwmConfig::GetInstance()->GetWriteProxyId();
	m_cstr_proxy_pass = Cq2chwmConfig::GetInstance()->GetWriteProxyPass();
	if (strcmp(Cq2chwmConfig::GetInstance()->GetWriteUserAgent(), USERAGENT) != 0) {
		m_cstr_ua = Cq2chwmConfig::GetInstance()->GetWriteUserAgent();
	}
}

Cq2chwmPageNetworkWrite::~Cq2chwmPageNetworkWrite()
{
}

void Cq2chwmPageNetworkWrite::DoDataExchange(CDataExchange* pDX)
{
	DDX_Control(pDX, IDC_CHECK_PROXYUSE, m_cProxyUse);
	DDX_Text(pDX, IDC_COMBO_PROXYHOST, m_cstr_proxy_host);
	DDX_Text(pDX, IDC_EDIT_PROXYPORT, m_in_proxy_port);
	DDX_Text(pDX, IDC_EDIT_PROXYID, m_cstr_proxy_id);
	DDX_Text(pDX, IDC_EDIT_PROXYPASS, m_cstr_proxy_pass);
	DDX_Text(pDX, IDC_COMBO_UA, m_cstr_ua);
	DDX_Control(pDX, IDC_COMBO_CONN, m_cComboConnection);
	DDX_Control(pDX, IDC_STATIC_CONN, m_cStaticConnection);
	DDX_Control(pDX, IDC_COMBO_UA, m_cComboUserAgent);
	DDX_Control(pDX, IDC_COMBO_PROXYHOST, m_cComboProxyHost);
	DDX_Control(pDX, IDC_CHECK_WRITECHANGE, m_cWriteChange);
	Cq2chwmConfigPage::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageNetworkWrite, CDialog)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_CHECK_PROXYUSE, &Cq2chwmPageNetworkWrite::OnBnClickedCheckProxyuse)
	ON_BN_CLICKED(IDC_CHECK_WRITECHANGE, &Cq2chwmPageNetworkWrite::OnBnClickedCheckWriteChange)
END_MESSAGE_MAP()


// Cq2chwmPageNetworkWrite bZ[W nh

BOOL Cq2chwmPageNetworkWrite::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ
	m_cWriteChange.SetCheck(Cq2chwmConfig::GetInstance()->GetWriteChange());
	m_cProxyUse.SetCheck(Cq2chwmConfig::GetInstance()->GetWriteProxyUse());
	OnBnClickedCheckWriteChange();

	// vLVR{{bNX
	{
		m_cComboProxyHost.InsertString(0, _T(""));
		m_cComboProxyHost.InsertString(1, _T("vfkkwapproxy.vodafone.ne.jp"));
	}

	// UAR{{bNX
	{
		SETCOMBOTOUSERAGENT(m_cComboUserAgent);
	}

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	// ڑR{{bNX
	CONNMGR_DESTINATION_INFO di;
	for(int i = 0; SUCCEEDED(ConnMgrEnumDestinations(i, &di)); i++) {
		m_cComboConnection.InsertString(i, di.szDescription);
		if (Cq2chwmConfig::GetInstance()->GetWriteConnection() >= 0) {
			if (Cq2chwmConfig::GetInstance()->GetWriteConnection() == i) {
				m_cComboConnection.SetCurSel(i);
			}
		} else {
			if (di.guid == IID_DestNetInternet) {
				m_cComboConnection.SetCurSel(i);
			}
		}
	}
	m_cComboConnection.ShowWindow(SW_SHOW);
	m_cStaticConnection.ShowWindow(SW_SHOW);
#else
	m_cComboConnection.ShowWindow(SW_HIDE);
	m_cStaticConnection.ShowWindow(SW_HIDE);
#endif

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmPageNetworkWrite::OnSize(UINT nType, int cx, int cy)
{
	Cq2chwmConfigPage::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_WRITECHANGE), 1),
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_CONN), 1, GetDlgItem(IDC_COMBO_CONN), 3),
#endif
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_UA), 1, GetDlgItem(IDC_COMBO_UA), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_PROXYUSE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_PROXY), 1, GetDlgItem(IDC_COMBO_PROXYHOST), 2, GetDlgItem(IDC_EDIT_PROXYPORT), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_PROXYID), 1, GetDlgItem(IDC_EDIT_PROXYID), 1, GetDlgItem(IDC_EDIT_PROXYPASS), 1)
	);
	cLayout.Layout(cx, cy);
}

void Cq2chwmPageNetworkWrite::OnBnClickedCheckProxyuse()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	BOOL bo_check = (GetDlgItem(IDC_CHECK_PROXYUSE)->IsWindowEnabled() == TRUE &&
		((CButton*)GetDlgItem(IDC_CHECK_PROXYUSE))->GetCheck());
	GetDlgItem(IDC_STATIC_PROXY)->EnableWindow(bo_check);
	GetDlgItem(IDC_COMBO_PROXYHOST)->EnableWindow(bo_check);
	GetDlgItem(IDC_EDIT_PROXYPORT)->EnableWindow(bo_check);
	GetDlgItem(IDC_STATIC_PROXYID)->EnableWindow(bo_check);
	GetDlgItem(IDC_EDIT_PROXYID)->EnableWindow(bo_check);
	GetDlgItem(IDC_EDIT_PROXYPASS)->EnableWindow(bo_check);
}

void Cq2chwmPageNetworkWrite::Write()
{
	UpdateData(TRUE);
	Cq2chwmConfig::GetInstance()->SetWriteChange(m_cWriteChange.GetCheck());
	CYoString str_value;
	str_value = A(m_cstr_proxy_host);
	Cq2chwmConfig::GetInstance()->SetWriteProxyHost(str_value);
	Cq2chwmConfig::GetInstance()->SetWriteProxyPort(m_in_proxy_port);
	str_value = A(m_cstr_proxy_id);
	Cq2chwmConfig::GetInstance()->SetWriteProxyId(str_value);
	str_value = A(m_cstr_proxy_pass);
	Cq2chwmConfig::GetInstance()->SetWriteProxyPass(str_value);
	Cq2chwmConfig::GetInstance()->SetWriteProxyUse(m_cProxyUse.GetCheck());
	str_value = A(m_cstr_ua);
	Cq2chwmConfig::GetInstance()->SetWriteUserAgent(str_value);
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	Cq2chwmConfig::GetInstance()->SetWriteConnection(m_cComboConnection.GetCurSel());
#endif
}

void Cq2chwmPageNetworkWrite::OnBnClickedCheckWriteChange()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	BOOL bo_check = ((CButton*)GetDlgItem(IDC_CHECK_WRITECHANGE))->GetCheck();
	GetDlgItem(IDC_STATIC_CONN)->EnableWindow(bo_check);
	GetDlgItem(IDC_COMBO_CONN)->EnableWindow(bo_check);
	GetDlgItem(IDC_STATIC_UA)->EnableWindow(bo_check);
	GetDlgItem(IDC_COMBO_UA)->EnableWindow(bo_check);
	GetDlgItem(IDC_CHECK_PROXYUSE)->EnableWindow(bo_check);
	OnBnClickedCheckProxyuse();
}
