// q2chwmConfigDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmConfigDialog.h"
#include "q2chwmPageSystem.h"
#include "q2chwmPageFont.h"
#include "q2chwmPageColor.h"
#include "q2chwmPageNetwork.h"
#include "q2chwmPageNetworkWrite.h"
#include "q2chwmPageKey.h"
#include "q2chwmPageBoard.h"
#include "q2chwmPageNg.h"
#include "q2chwmPageMessage.h"
#include "q2chwmPageOther.h"
#include "q2chwmPageMovie.h"
#include "q2chwmPageImage.h"

// Cq2chwmConfigDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmConfigDialog, CDialog)

Cq2chwmConfigDialog::Cq2chwmConfigDialog(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmConfigDialog::IDD, pParent)
{
}

Cq2chwmConfigDialog::~Cq2chwmConfigDialog()
{
	for (int i = 0; i < m_cArray.GetCount(); i++) {
		Cq2chwmConfigPage *pPage = m_cArray.GetAt(i);
		delete pPage;
	}
}

void Cq2chwmConfigDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmConfigDialog, CDialog)
	ON_WM_SIZE()
	ON_COMMAND(ID_MENU_CANCEL, &Cq2chwmConfigDialog::OnMenuCancel)
	ON_COMMAND(ID_MENU_OK, &Cq2chwmConfigDialog::OnMenuOk)
	ON_COMMAND(ID_MENU_BOARD, &Cq2chwmConfigDialog::OnMenuBoard)
	ON_COMMAND(ID_MENU_COLOR, &Cq2chwmConfigDialog::OnMenuColor)
	ON_COMMAND(ID_MENU_FONT, &Cq2chwmConfigDialog::OnMenuFont)
	ON_COMMAND(ID_MENU_KEY, &Cq2chwmConfigDialog::OnMenuKey)
	ON_COMMAND(ID_MENU_NETWORK, &Cq2chwmConfigDialog::OnMenuNetwork)
	ON_COMMAND(ID_MENU_NETWORK_WRITE, &Cq2chwmConfigDialog::OnMenuNetworkWrite)
	ON_COMMAND(ID_MENU_SYSTEM, &Cq2chwmConfigDialog::OnMenuSystem)
	ON_COMMAND(ID_MENU_MESSAGE, &Cq2chwmConfigDialog::OnMenuMessage)
	ON_COMMAND(ID_MENU_OTHER, &Cq2chwmConfigDialog::OnMenuOther)
	ON_COMMAND(ID_MENU_MOVIE, &Cq2chwmConfigDialog::OnMenuMovie)
	ON_WM_INITMENUPOPUP()
	ON_COMMAND(ID_MENU_NG, &Cq2chwmConfigDialog::OnMenuNg)
	ON_COMMAND(ID_MENU_IMAGE, &Cq2chwmConfigDialog::OnMenuImage)
END_MESSAGE_MAP()


// Cq2chwmConfigDialog bZ[W nh

void Cq2chwmConfigDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	for (int i = 0; i < m_cArray.GetCount(); i++) {
		CDialog *pPage = m_cArray.GetAt(i);
		if (pPage != NULL && pPage->m_hWnd != NULL) {
			pPage->MoveWindow(0, 0, cx, cy);
		}
	}
}

BOOL Cq2chwmConfigDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	// y[W쐬
	CWnd *pParent = this;
	m_pSystem = new Cq2chwmPageSystem;
	m_pSystem->Create(Cq2chwmPageSystem::IDD, pParent);
	m_pFont = new Cq2chwmPageFont;
	m_pFont->Create(Cq2chwmPageFont::IDD, pParent);
	m_pColor= new Cq2chwmPageColor;
	m_pColor->Create(Cq2chwmPageColor::IDD, pParent);
	m_pNetwork = new Cq2chwmPageNetwork;
	m_pNetwork->Create(Cq2chwmPageNetwork::IDD, pParent);
	m_pNetworkWrite = new Cq2chwmPageNetworkWrite;
	m_pNetworkWrite->Create(Cq2chwmPageNetworkWrite::IDD, pParent);
	m_pKey = new Cq2chwmPageKey;
	m_pKey->Create(Cq2chwmPageKey::IDD, pParent);
	m_pBoard = new Cq2chwmPageBoard;
	m_pBoard->Create(Cq2chwmPageBoard::IDD, pParent);
	m_pNg = new Cq2chwmPageNg;
	m_pNg->Create(Cq2chwmPageNg::IDD, pParent);
	m_pMessage = new Cq2chwmPageMessage;
	m_pMessage->Create(Cq2chwmPageMessage::IDD, pParent);
	m_pImage = new Cq2chwmPageImage;
	m_pImage->Create(Cq2chwmPageImage::IDD, pParent);
	m_pOther = new Cq2chwmPageOther;
	m_pOther->Create(Cq2chwmPageOther::IDD, pParent);
	m_pMovie = new Cq2chwmPageMovie;
	m_pMovie->Create(Cq2chwmPageMovie::IDD, pParent);
	showPage(m_pSystem);
	m_cArray.Add(m_pSystem);
	m_cArray.Add(m_pFont);
	m_cArray.Add(m_pColor);
	m_cArray.Add(m_pKey);
	m_cArray.Add(m_pNetwork);
	m_cArray.Add(m_pNetworkWrite);
	m_cArray.Add(m_pBoard);
	m_cArray.Add(m_pNg);
	m_cArray.Add(m_pMessage);
	m_cArray.Add(m_pImage);
	m_cArray.Add(m_pMovie);
	m_cArray.Add(m_pOther);

	// CAEĝ
	RECT st_rect;
	GetClientRect(&st_rect);
	SendMessage(WM_SIZE, 0, MAKELPARAM(st_rect.right - st_rect.left, st_rect.bottom - st_rect.top));

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	if (!m_wndCommandBar.Create(this) ||
	    !m_wndCommandBar.InsertMenuBar(IDR_MENU_CONFIG) ||
	    !m_wndCommandBar.AddAdornments())
	{
		TRACE0("CommandBar ̍쐬Ɏs܂\n");
		return FALSE;
	}
	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() | CBRS_SIZE_FIXED);
#else
	m_cMenu.LoadMenu(IDR_MENU_CONFIG);
	SetMenu(&m_cMenu);
#endif // WIN32_PLATFORM_PSPC

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	TBBUTTONINFO tbbi = {0};
	tbbi.cbSize       = sizeof(tbbi);
	tbbi.dwMask       = TBIF_LPARAM | TBIF_BYINDEX;
	m_wndCommandBar.SendMessage(TB_GETBUTTONINFO,1, (LPARAM)&tbbi);

	HMENU hmenu = (HMENU)tbbi.lParam;
	CMenu *cMenu= CMenu::FromHandle( hmenu );
	ReplaceMenu(cMenu,Cq2chwmConfig::GetInstance()->GetMenuNumber());
#else
	CMenu *cMenu = GetMenu();

	CMenu *cMenu1 = cMenu->GetSubMenu(1);
	ReplaceMenu(cMenu1,Cq2chwmConfig::GetInstance()->GetMenuNumber());
#endif

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmConfigDialog::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	for (int i = 0; i < m_cArray.GetCount(); i++) {
		Cq2chwmConfigPage *pPage = m_cArray.GetAt(i);
		pPage->Write();
	}

	CDialog::OnOK();
}

BEGIN_MESSAGE_MAP(Cq2chwmConfigPage, CDialog)
	ON_WM_GETDLGCODE()
END_MESSAGE_MAP()

void Cq2chwmConfigDialog::showPage(
	Cq2chwmConfigPage *pPage)
{
	for (int i = 0; i < m_cArray.GetCount(); i++) {
		Cq2chwmConfigPage *pPage = m_cArray.GetAt(i);
		pPage->ShowWindow(SW_HIDE);
	}
	pPage->ShowWindow(SW_SHOW);
	pPage->SetFocus();
	m_pCurrentPage = pPage;
}

void Cq2chwmConfigDialog::OnMenuCancel()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnCancel();
}

void Cq2chwmConfigDialog::OnMenuOk()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnOK();
}

void Cq2chwmConfigDialog::OnMenuBoard()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pBoard);
}

void Cq2chwmConfigDialog::OnMenuColor()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pColor);
}

void Cq2chwmConfigDialog::OnMenuFont()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pFont);
}

void Cq2chwmConfigDialog::OnMenuKey()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pKey);
}

void Cq2chwmConfigDialog::OnMenuNetwork()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pNetwork);
}

void Cq2chwmConfigDialog::OnMenuNetworkWrite()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pNetworkWrite);
}

void Cq2chwmConfigDialog::OnMenuSystem()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pSystem);
}

void Cq2chwmConfigDialog::OnMenuNg()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pNg);
}

void Cq2chwmConfigDialog::OnMenuMessage()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pMessage);
}

void Cq2chwmConfigDialog::OnMenuOther()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pOther);
}

void Cq2chwmConfigDialog::OnMenuMovie()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pMovie);
}

void Cq2chwmConfigDialog::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu)
{
	CDialog::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);

	// TODO: ɃbZ[W nh R[hǉ܂B
	// CDialogON_UPDATE_COMMAND_UIgȂ
	pPopupMenu->CheckMenuItem(ID_MENU_SYSTEM, m_pCurrentPage == m_pSystem ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_FONT, m_pCurrentPage == m_pFont ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_COLOR, m_pCurrentPage == m_pColor ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_KEY, m_pCurrentPage == m_pKey ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_NETWORK, m_pCurrentPage == m_pNetwork ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_NETWORK_WRITE, m_pCurrentPage == m_pNetworkWrite ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_BOARD, m_pCurrentPage == m_pBoard ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_NG, m_pCurrentPage == m_pNg ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_MESSAGE, m_pCurrentPage == m_pMessage ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_IMAGE, m_pCurrentPage == m_pImage ? MF_CHECKED : MF_UNCHECKED);
	pPopupMenu->CheckMenuItem(ID_MENU_OTHER, m_pCurrentPage == m_pOther ? MF_CHECKED : MF_UNCHECKED);
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	pPopupMenu->CheckMenuItem(ID_MENU_MOVIE, m_pCurrentPage == m_pMovie ? MF_CHECKED : MF_UNCHECKED);
#else
	pPopupMenu->EnableMenuItem(ID_MENU_MOVIE, MF_GRAYED);
#endif
}

void Cq2chwmConfigDialog::AddUrl(
	const char *chp_url)
{
	if (chp_url == NULL || *chp_url == 0x00) return;
	CString cstr_url;
	cstr_url = chp_url;
	m_cUrlArray.Add(cstr_url);
}

void Cq2chwmConfigDialog::AddText(
	const char *chp_text)
{
	if (chp_text == NULL || *chp_text == 0x00) return;
	CString cstr_text;
	cstr_text = chp_text;
	m_cTextArray.Add(cstr_text);
}

void Cq2chwmConfigDialog::OnMenuImage()
{
	// TODO: ɃR}h nh R[hǉ܂B
	showPage(m_pImage);
}
