// MainFrm.h : CMainFrame NX̃C^[tFCX
//
#pragma once

#include "YoHttpClient.h"
#include "q2chwmCommon.h"
#include "q2chwmStatusDialog.h"
#include "q2chwmSearchDialog.h"
#include "q2chwmFind2chDialog.h"
#include "q2chwmConnectionManager.h"
#include "q2chwmJumpDialog.h"

class CMainFrame : public CFrameWnd
{
protected: // VÂݍ쐬܂B
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)


// 
public:

// I[o[Ch
public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

// 
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
#endif

protected:  // Rg[ o[po
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	CCommandBar m_wndCommandBar;
#endif

// ꂽAbZ[W蓖Ċ֐
protected:
	DECLARE_MESSAGE_MAP()

public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);

public:
	enum MODE {
		MODE_BOARD = 0,
		MODE_SUBJECT,
		MODE_DAT,
		MODE_BOOKMARK,
		MODE_CACHE,
		MODE_IMAGE,
	};
	void AddHistory(MODE mode);

private:
	BOOL m_bo_canceled;
	CYoPtrArray m_cModeArray;			// ߂鑀p̃[hz
	CYoPtrArray m_cModeForwardArray;	// iޑp̃[hz
	Cq2chwmStatusDialog m_cStatus;
	Cq2chwmSearchDialog m_cSearch;
	Cq2chwmFind2chDialog m_cFind2ch;
	DWORD m_dw_threadid;
	Cq2chwmConnectionManager m_cConnectionManager;
	Cq2chwmJumpDialog m_cJump;

protected:
	afx_msg long OnBoardClicked(WPARAM wParam, LPARAM lParam);
	afx_msg long OnSubjectClicked(WPARAM wParam, LPARAM lParam);
	afx_msg long OnBookmarkClicked(WPARAM wParam, LPARAM lParam);
	afx_msg long OnCacheClicked(WPARAM wParam, LPARAM lParam);
	afx_msg long OnCacheImageClicked(WPARAM wParam, LPARAM lParam);
	afx_msg long OnCancel(WPARAM wParam, LPARAM lParam);
	afx_msg long OnOpenBookmark(WPARAM wParam, LPARAM lParam);
	afx_msg long OnOpenFind2ch(WPARAM wParam, LPARAM lParam);
	afx_msg long OnOpenCache(WPARAM wParam, LPARAM lParam);
	afx_msg long OnAddBookmark(WPARAM wParam, LPARAM lParam);
	afx_msg long OnCustomMessage(WPARAM wParam, LPARAM lParam);
	afx_msg long OnShowStatusBar(WPARAM wParam, LPARAM lParam);
	afx_msg long OnShowSearchBar(WPARAM wParam, LPARAM lParam);
	afx_msg long OnShowFind2chBar(WPARAM wParam, LPARAM lParam);
	afx_msg long OnExecSearch(WPARAM wParam, LPARAM lParam);
	afx_msg long OnExecFind2ch(WPARAM wParam, LPARAM lParam);
	afx_msg long OnPopupMenu(WPARAM wParam, LPARAM lParam);
	afx_msg long OnOpenUrl(WPARAM wParam, LPARAM lParam);
	afx_msg long OnUpdateBookmark(WPARAM wParam, LPARAM lParam);
	afx_msg long OnNextArticle(WPARAM wParam, LPARAM lParam);
	afx_msg long OnSetProgress(WPARAM wParam, LPARAM lParam);
	afx_msg long OnViewBack(WPARAM wParam, LPARAM lParam);
	afx_msg long OnViewForward(WPARAM wParam, LPARAM lParam);
	afx_msg long OnDeleteDatFile(WPARAM wParam, LPARAM lParam);
	afx_msg long OnExecJump(WPARAM wParam, LPARAM lParam);
	afx_msg long OnShowJumpBar(WPARAM wParam, LPARAM lParam);
	afx_msg long OnDeleteImageFile(WPARAM wParam, LPARAM lParam);
	afx_msg long OnAddBookmarkBoard(WPARAM wParam, LPARAM lParam);
	afx_msg long OnGetImage(WPARAM wParam, LPARAM lParam);

public:
	static BOOL CallbackProc(CYoSocketMessage &cMsg, void *vop_user);
	static BOOL CallbackCanceledProc(void *vop_user);
	inline BOOL Canceled(){ return m_bo_canceled; }
	void SetCancel(BOOL bo_cancel);
	void SetProgress(const char *chp_message, int in_recv, int in_recv_all);
	void ShowStatusBar(BOOL bo_flg);
	void ShowSearchBar(BOOL bo_flg);
	void ShowFind2chBar(BOOL bo_flg);
	void ShowJumpBar(BOOL bo_flg);
	void OpenBrowser(const wchar_t *lpszUrl);
	BOOL Execute(const wchar_t *lpszImage, const wchar_t *lpszArg);
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	HMENU GetMenu(int in_menu_number);
#endif

public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
public:
	afx_msg void OnCancel();
	afx_msg void OnViewBack();
	afx_msg void OnViewForward();
public:
	afx_msg void OnSearch();
public:
	afx_msg void OnFind2ch();
	afx_msg void OnExit();
	afx_msg void OnConnect();
	afx_msg void OnDisconnect();
	afx_msg void OnCopyInformation();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnUpdateViewBack(CCmdUI *pCmdUI);
	afx_msg void OnUpdateViewForward(CCmdUI *pCmdUI);
	afx_msg void OnUpdateCancel(CCmdUI *pCmdUI);
	afx_msg void OnJump();
};


