// q2chwmColorSelectorDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmColorSelectorDialog.h"
#include "q2chwmColorSelectorButton.h"
#include "q2chwmColorSelector.h"

static COLORREF gColors[] = 
{
	RGB(255, 128, 128),
	RGB(255, 255, 128),
	RGB(128, 255, 128),
	RGB(0, 255, 128),
	RGB(128, 255, 255),
	RGB(0, 128, 255),
	RGB(255, 128, 192),
	RGB(255, 128, 255),
	RGB(255, 0, 0),
	RGB(255, 255, 0),
	RGB(128, 255, 0),
	RGB(0, 255, 64),
	RGB(0, 255, 255),
	RGB(0, 128, 192),
	RGB(128, 128, 192),
	RGB(255, 0, 255),
	RGB(128, 64, 64),
	RGB(255, 128, 64),
	RGB(0, 255, 0),
	RGB(0, 128, 128),
	RGB(0, 64, 128),
	RGB(128, 128, 255),
	RGB(128, 0, 64),
	RGB(255, 0, 128),
	RGB(128, 0, 0),
	RGB(255, 128, 0),
	RGB(0, 128, 0),
	RGB(0, 128, 64),
	RGB(0, 0, 255),
	RGB(0, 0, 160),
	RGB(128, 0, 128),
	RGB(128, 0, 255),
	RGB(64, 0, 0),
	RGB(128, 64, 0),
	RGB(0, 64, 0),
	RGB(0, 64, 64),
	RGB(0, 0, 128),
	RGB(0, 0, 64),
	RGB(64, 0, 64),
	RGB(64, 0, 128),
	RGB(0, 0, 0),
	RGB(128, 128, 0),
	RGB(128, 128, 64),
	RGB(128, 128, 128),
	RGB(64, 128, 128),
	RGB(192, 192, 192),
	RGB(64, 0, 64),
	RGB(255, 255, 255),
};

// Cq2chwmColorSelectorDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmColorSelectorDialog, CDialog)

Cq2chwmColorSelectorDialog::Cq2chwmColorSelectorDialog(Cq2chwmColorSelector* pParent)
	: CDialog(Cq2chwmColorSelectorDialog::IDD, pParent)
{
	m_pParent = pParent;
	m_ppColors = new Cq2chwmColorSelectorButton*[sizeof(gColors) / sizeof(gColors[0])];
	for (int i = 0; i < sizeof(gColors) / sizeof(gColors[0]); i++) {
		m_ppColors[i] = new Cq2chwmColorSelectorButton();
	}
}

Cq2chwmColorSelectorDialog::~Cq2chwmColorSelectorDialog()
{
	for (int i = 0; i < sizeof(gColors) / sizeof(gColors[0]); i++) {
		delete m_ppColors[i];
	}
	delete m_ppColors;
}

void Cq2chwmColorSelectorDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmColorSelectorDialog, CDialog)
	ON_WM_LBUTTONDOWN()
END_MESSAGE_MAP()


// Cq2chwmColorSelectorDialog bZ[W nh
#define MARGIN	2
#define WIDTH	36
#define HEIGHT	24
#define ID_USER	1000
BOOL Cq2chwmColorSelectorDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	CRect rect(MARGIN, MARGIN, WIDTH + MARGIN, HEIGHT + MARGIN);
	int iDialogWidth = 0;
	int iDialogHeight = 0;
	for (int i = 0; i < sizeof(gColors) / sizeof(gColors[0]); i++) {
		m_ppColors[i]->Create(gColors[i], rect, this, ID_USER + i);
		m_ppColors[i]->ShowWindow(SW_SHOW);
		if (((i + 1) % 6)) {
			rect.left += WIDTH + MARGIN;
			rect.right = rect.left + WIDTH;
		} else {
			rect.left = MARGIN;
			rect.right = rect.left + WIDTH;
			rect.top += HEIGHT + MARGIN;
			rect.bottom = rect.top + HEIGHT;
		}
		iDialogWidth = max(iDialogWidth, rect.right);
		iDialogHeight = max(iDialogHeight, rect.bottom);
	}

	// ͂ݏoꍇ̕␳
	RECT rcParent;
	m_pParent->GetWindowRect(&rcParent);
	if (rcParent.left < 0) rcParent.left = 0;

	// E͂ݏoꍇ̕␳
	RECT rcDesktop;
	CWnd *pDesktopWnd = GetDesktopWindow();
	pDesktopWnd->GetWindowRect(&rcDesktop);
	if (rcParent.left + iDialogWidth > rcDesktop.right) rcParent.left = rcDesktop.right - iDialogWidth;

	// ͂ݏoꍇ̕␳
	if (rcParent.bottom + iDialogHeight > rcDesktop.bottom) rcParent.bottom = rcParent.top - iDialogHeight + HEIGHT;

	SetWindowPos(0, rcParent.left, rcParent.bottom, iDialogWidth + MARGIN, iDialogHeight - HEIGHT + MARGIN, SWP_NOZORDER|SWP_NOREPOSITION);

	SetCapture();

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL Cq2chwmColorSelectorDialog::Create(CWnd *pParent)
{
	BOOL bRet = CDialog::Create(Cq2chwmColorSelectorDialog::IDD, pParent);
	if (bRet == TRUE) {
		this->ShowWindow(SW_SHOW);
	}
	return bRet;
}


void Cq2chwmColorSelectorDialog::PostNcDestroy()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	delete this;

	CDialog::PostNcDestroy();
}

BOOL Cq2chwmColorSelectorDialog::OnCommand(WPARAM wParam, LPARAM lParam)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	WORD wCode = HIWORD(wParam);
	WORD wId = LOWORD(wParam);
	if (wCode == BN_CLICKED) {
		if (wId >= ID_USER) {
			Cq2chwmColorSelectorButton *pButton = m_ppColors[wId - ID_USER];
			m_pParent->SetColor(pButton->GetColor());
		}
	}
	m_pParent->EndDialog();
	return TRUE;//CDialog::OnCommand(wParam, lParam);
}

BOOL Cq2chwmColorSelectorDialog::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	return CDialog::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void Cq2chwmColorSelectorDialog::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	// _CAOȊONbNꂽ_CAO
	RECT rect;
	GetClientRect(&rect);
	if (point.x < 0 || point.x > rect.right || point.y < 0 || point.y > rect.bottom) {
		ReleaseCapture();
		m_pParent->EndDialog();
		return;
	}

	// SetCaptureOnCommandȂ̂Ń{^̈ʒuǂ̃{^ꂽ𒲂ׂ
	POINT ptWindow = point;
	ClientToScreen(&ptWindow);
	for (int i = 0; i < sizeof(gColors) / sizeof(gColors[0]); i++) {
		Cq2chwmColorSelectorButton *pButton = m_ppColors[i];
		RECT rect;
		pButton->GetWindowRect(&rect);
		if (ptWindow.x > rect.left && ptWindow.x < rect.right && ptWindow.y > rect.top && ptWindow.y < rect.bottom) {
			ReleaseCapture();
			m_pParent->SetColor(pButton->GetColor());
			m_pParent->EndDialog();
			return;
		}
	}
	CDialog::OnLButtonDown(nFlags, point);
}
