#pragma once

#include "YoString.h"
#include "YoTable.h"
#include "YoRegex.h"

class Cq2chwmImageViewUrlReplaceData;

class Cq2chwmImageViewUrlReplaceBase
{
public:
	enum OPTION {
		VIEWER = 0,
		COOKIE,
		EXTRACT
	};
};

/*!
 * \brief
 * ʃNX.
 * 
 * Cq2chwmImageViewUrlReplace::Find\bhł̌ʂi[.
 * 
 */
class Cq2chwmImageViewUrlReplaceMatch : public Cq2chwmImageViewUrlReplaceBase
{
private:
	CYoString m_str_url;
	CYoString m_str_referer;
	CYoString m_str_cookie;

public:
	Cq2chwmImageViewUrlReplaceMatch(){}
	virtual ~Cq2chwmImageViewUrlReplaceMatch(){}

	inline const char *GetUrl(){ return m_str_url; }
	inline const char *GetReferer(){ return m_str_referer; }
	inline const char *GetCookie(){ return m_str_cookie; }
	void SetUrl(const char *chp_url){ m_str_url = chp_url; }
	void SetReferer(const char *chp_referer){ return m_str_referer = chp_referer; }
	void SetCookie(const char *chp_cookie){ return m_str_cookie = chp_cookie; }
};

/*!
 * \brief
 * ImageViewURLReplace.dat̓ǂݍ݁AsNX.
 * 
 * ImageViewURLReplace.datłȂAPȉ摜URĽ܂߂ĉ摜URĽ͑SẴNXōs.
 * VOgp^[ƂȂĂB
 */
class Cq2chwmImageViewUrlReplace : public CYoPtrArray
{
private:
	BOOL Create();
	static void Delete();
	static void ImageViewUrlReplace_do(CYoString str_url, CYoString& str_newurl, CYoString& str_newref);
	static int ImageViewUrlReplace_replace(CYoString &str_out, const char *str_rep, const CYoRegex *pRegexSearch, const CYoRegex *pRegexExtract = NULL);
	static int HttpGet(CYoString &str_html, CYoString &str_cookie, const char *str_url, const char *str_referer);
	inline Cq2chwmImageViewUrlReplaceData *GetData(int in_index){ return (Cq2chwmImageViewUrlReplaceData*)Get(in_index); }

	static Cq2chwmImageViewUrlReplace *m_pInstance;
	Cq2chwmImageViewUrlReplace();

public:
	virtual ~Cq2chwmImageViewUrlReplace();

	static Cq2chwmImageViewUrlReplace *GetInstance();
	HANDLE FindOpen(BOOL bo_refererence = FALSE);
	void FindClose(HANDLE hFind);
	int Find(HANDLE hFind, const wchar_t *wchp_text, int in_length = -1);
	int Find(HANDLE hFind, const char *chp_text, int in_length = -1);
	const wchar_t *FindGetUrl(HANDLE hFind);
	int Match(const wchar_t *wchp_url, Cq2chwmImageViewUrlReplaceMatch &cMatch);
	int Match(const char *chp_url, Cq2chwmImageViewUrlReplaceMatch &cMatch);
};
