#pragma once
#include "q2chwmCommon.h"
#include "YoDataArray.h"

class Cq2chwmConfigKey;

// VXe
#define CONF_ROOTDIR			"RootDirectory"
#define CONF_BOARDURL			"BoardUrl"
#define CONF_BROWSER			"Browser"
#define CONF_THREADMAX			"ThreadMax"
#define CONF_TABMAX				"TabMax"
#define CONF_TABWIDTH			"TabWidth"
#define CONF_ONLINE				"Online"
#define CONF_DEBUG				"Debug"

// lbg[N
#define CONF_PROXY_USE			"ProxyUse"
#define CONF_PROXY_USEWRITE		"ProxyUseWrite"
#define CONF_PROXY_HOST			"ProxyHost"
#define CONF_PROXY_PORT			"ProxyPort"
#define CONF_PROXY_ID			"ProxyId"
#define CONF_PROXY_PASS			"ProxyPass"
#define CONF_DOLIB_ID			"DoLibId"
#define CONF_DOLIB_PASS			"DoLibPass"
#define CONF_DOLIB_SID			"DoLibSid"
#define CONF_SAGE				"Sage"

// tHg
#define CONF_FONTNAME_LIST		"FontNameList"
#define CONF_FONTNAME_BOARD		"FontNameBoard"
#define CONF_FONTNAME_MESSAGE	"FontNameMessage"
#define CONF_FONTNAME_CACHE		"FontNameCache"
#define CONF_FONTNAME_BOOKMARK	"FontNameBookmark"
#define CONF_FONTNAME_TAB		"FontNameTab"
#define CONF_FONTNAME_ARTICLE	"FontNameArticle"
#define CONF_FONTSIZE_LIST		"FontSizeList"
#define CONF_FONTSIZE_BOARD		"FontSizeBoard"
#define CONF_FONTSIZE_MESSAGE	"FontSizeMessage"
#define CONF_FONTSIZE_CACHE		"FontSizeCache"
#define CONF_FONTSIZE_BOOKMARK	"FontSizeBookmark"
#define CONF_FONTSIZE_TAB		"FontSizeTab"
#define CONF_FONTSIZE_ARTICLE	"FontSizeArticle"

// F
#define CONF_COLOR_FORE			"ColorFore"
#define CONF_COLOR_BACK			"ColorBack"
#define CONF_COLOR_CACHE		"ColorCache"
#define CONF_COLOR_NEW			"ColorNew"
#define CONF_COLOR_ERROR		"ColorError"
#define CONF_COLOR_SEARCH		"ColorSearch"
#define CONF_COLOR_ACTIVE		"ColorActive"
#define CONF_COLOR_FROM			"ColorFrom"
#define CONF_COLOR_FROMWITHMAIL	"ColorFromWithMail"
#define CONF_COLOR_FROMWITHSAGE	"ColorFromWithSage"
#define CONF_COLOR_DATE			"ColorDate"
#define CONF_COLOR_DATENEW		"ColorDateNew"
#define CONF_COLOR_MESSAGE		"ColorMessage"
#define CONF_COLOR_LINK			"ColorLink"
#define CONF_COLOR_ABONE		"ColorAbone"

// L[
#define CONF_KEY_CANCEL			"KeyCancel"
#define CONF_KEY_ONLINE			"KeyOnline"
#define CONF_KEY_RELOAD			"KeyReload"
#define CONF_KEY_DELETE			"KeyDelete"
#define CONF_KEY_SEARCH			"KeySearch"
#define CONF_KEY_TOP			"KeyTop"
#define CONF_KEY_BOTTOM			"KeyBottom"
#define CONF_KEY_CLOSETAB		"KeyCloseTab"
#define CONF_KEY_NEXT			"KeyNext"
#define CONF_KEY_PREV			"KeyPrev"
#define CONF_KEY_NEXTLINK		"KeyNextLink"
#define CONF_KEY_PREVLINK		"KeyPrevLink"
#define CONF_KEY_MENU			"KeyMenu"
#define CONF_KEY_NEXTTAB		"KeyNextTab"
#define CONF_KEY_PREVTAB		"KeyPrevTab"
#define CONF_KEY_BACK			"KeyBack"
#define CONF_KEY_OPENBOOKMARK	"KeyOpenBookmark"
#define CONF_KEY_ADDBOOKMARK	"KeyAddBookmark"
#define CONF_KEY_SORT			"KeySort"
#define CONF_KEY_EDIT			"KeyEdit"
#define CONF_KEY_EDITREPLY		"KeyEditReply"
#define CONF_KEY_FIND2CH		"KeyFind2ch"
#define CONF_KEY_NEXTLINE		"KeyNextLine"
#define CONF_KEY_PREVLINE		"KeyPrevLine"

// n
#define CONF_HISTORY_NAME		"HistoryName"
#define CONF_HISTORY_MAIL		"HistoryMail"
#define CONF_HISTORY_SEARCHWORD	"HistorySearchWord"

// J
#define CONF_COLUMNWIDTH_BOOKMARK	"ColumnWidthBookmark"
#define CONF_COLUMNWIDTH_SUBJECT	"ColumnWidthSubject"
#define CONF_COLUMNWIDTH_CACHE		"ColumnWidthCache"

// \[g
#define CONF_SORTCOLUMN_BOOKMARK	"SortColumnBookmark"
#define CONF_SORTCOLUMN_SUBJECT		"SortColumnSubject"
#define CONF_SORTCOLUMN_CACHE		"SortColumnCache"
#define CONF_SORTASC_BOOKMARK		"SortAscBookmark"
#define CONF_SORTASC_SUBJECT		"SortAscSubject"
#define CONF_SORTASC_CACHE			"SortAscCache"

// oϐAQb^[AZb^[`}N
#define PROPERTY(var, type, argtype, conf) \
private: \
	type var; \
public: \
	argtype Get##var(){ return var; } \
	void Set##var(argtype v){ if (var != v) {var = v; write(conf, v);} }

#define PROPERTY_DIR(var, conf) \
private: \
	CYoString var; \
public: \
	const char *Get##var(){ return var; } \
	void Set##var(const char *v){ \
		if (var != v) { \
			var = v; \
			while (var.Right(1) == "\\") { \
				var.Remove(var.Length() - 1); \
			} \
			write(conf, (const char*)var);} \
		}

#define PROPERTY_HISTORY(var, max, conf) \
private: \
	CYoDataArray var; \
public: \
	int Get##var##Count(){ return var.Count(); } \
	const char *Get##var(int i){ return var.Get(i); } \
	void Add##var(const char *v) \
	{ \
		for (int i = 0; i < var.Count(); i++) { \
			if (strcmp(var.Get(i), v) == 0) { \
				var.Remove(i); \
				i--; \
			} \
		} \
		var.Insert(0, v); \
		if (var.Count() > max) var.Remove(var.Count() - 1); \
		write(conf, var); \
	}

#define PROPERTY_INTARRAY(var, conf) \
private: \
	CYoPtrArray var; \
public: \
	int Get##var##Count(){ return var.Count(); } \
	int Get##var(int i){ return (int)var.Get(i); } \
	void Set##var(CYoPtrArray &a) \
	{ \
		var.RemoveAll(); \
		var = a; \
		write(conf, var); \
	}

class Cq2chwmConfig
{
private:
	static Cq2chwmConfig *m_pInstance;
	CYoString m_str_filename;			// ݒt@C̃pX

	// VXe
	PROPERTY_DIR(RootDirectory, CONF_ROOTDIR);							// q2ch[gfBNg
	PROPERTY(BoardUrl, CYoString, const char*, CONF_BOARDURL);			// board.txtURL
	PROPERTY(Browser, CYoString, const char*, CONF_BROWSER);			// uEU
	PROPERTY(ThreadMax, int, int, CONF_THREADMAX);						// 񎞍őXbh
	PROPERTY(TabMax, int, int, CONF_TABMAX);							// ő^u
	PROPERTY(TabWidth, int, int, CONF_TABWIDTH);						// ő^u
	PROPERTY(Online, BOOL, BOOL, CONF_ONLINE);							// IC/ItC
	PROPERTY(Debug, BOOL, BOOL, CONF_DEBUG);							// IC/ItC

	// lbg[N
	PROPERTY(ProxyUse, BOOL, BOOL, CONF_PROXY_USE);						// vLVgptO
	PROPERTY(ProxyUseWrite, BOOL, BOOL, CONF_PROXY_USEWRITE);					// ݎvLVgptO
	PROPERTY(ProxyHost, CYoString, const char*, CONF_PROXY_HOST);		// vLVzXg
	PROPERTY(ProxyPort, int, int, CONF_PROXY_PORT);						// vLV|[gԍ
	PROPERTY(ProxyId, CYoString, const char*, CONF_PROXY_ID);			// vLVID
	PROPERTY(ProxyPass, CYoString, const char*, CONF_PROXY_PASS);		// vLVPASS
	PROPERTY(DoLibId, CYoString, const char*, CONF_DOLIB_ID);;			// DOLIB ID
	PROPERTY(DoLibPass, CYoString, const char*, CONF_DOLIB_PASS);		// DOLIB PASS
	PROPERTY(DoLibSid, CYoString, const char*, CONF_DOLIB_SID);			// DOLIB ZbVID
	PROPERTY(Sage, BOOL, BOOL, CONF_SAGE);								// sage

	// tHg
	PROPERTY(FontNameList, CYoString, const char*, CONF_FONTNAME_LIST);			// List
	PROPERTY(FontNameBoard, CYoString, const char*, CONF_FONTNAME_BOARD);		// Board
	PROPERTY(FontNameMessage, CYoString, const char*, CONF_FONTNAME_MESSAGE);	// Message
	PROPERTY(FontNameCache, CYoString, const char*, CONF_FONTNAME_CACHE);		// Cache
	PROPERTY(FontNameBookmark, CYoString, const char*, CONF_FONTNAME_BOOKMARK);	// Bookmark
	PROPERTY(FontNameTab, CYoString, const char*, CONF_FONTNAME_TAB);			// ^u
	PROPERTY(FontNameArticle, CYoString, const char*, CONF_FONTNAME_ARTICLE);	// Article
	PROPERTY(FontSizeList, int, int, CONF_FONTSIZE_LIST);			// List
	PROPERTY(FontSizeBoard, int, int, CONF_FONTSIZE_BOARD);			// Board
	PROPERTY(FontSizeMessage, int, int, CONF_FONTSIZE_MESSAGE);		// Message
	PROPERTY(FontSizeCache, int, int, CONF_FONTSIZE_CACHE);			// Cache
	PROPERTY(FontSizeBookmark, int, int, CONF_FONTSIZE_BOOKMARK);	// Bookmark
	PROPERTY(FontSizeTab, int, int, CONF_FONTSIZE_TAB);				// ^u
	PROPERTY(FontSizeArticle, int, int, CONF_FONTSIZE_ARTICLE);		// Article

	// F
	PROPERTY(ColorFore, int, int, CONF_COLOR_FORE);
	PROPERTY(ColorBack, int, int, CONF_COLOR_BACK);
	PROPERTY(ColorCache, int, int, CONF_COLOR_CACHE);
	PROPERTY(ColorNew, int, int, CONF_COLOR_NEW);
	PROPERTY(ColorError, int, int, CONF_COLOR_ERROR);
	PROPERTY(ColorSearch, int, int, CONF_COLOR_SEARCH);
	PROPERTY(ColorActive, int, int, CONF_COLOR_ACTIVE);
	PROPERTY(ColorFrom, int, int, CONF_COLOR_FROM);
	PROPERTY(ColorFromWithMail, int, int, CONF_COLOR_FROMWITHMAIL);
	PROPERTY(ColorFromWithSage, int, int, CONF_COLOR_FROMWITHSAGE);
	PROPERTY(ColorDate, int, int, CONF_COLOR_DATE);
	PROPERTY(ColorDateNew, int, int, CONF_COLOR_DATENEW);
	PROPERTY(ColorMessage, int, int, CONF_COLOR_MESSAGE);
	PROPERTY(ColorLink, int, int, CONF_COLOR_LINK);
	PROPERTY(ColorAbone, int, int, CONF_COLOR_ABONE);

	// L[
	PROPERTY(KeyCancel, int, int, CONF_KEY_CANCEL);
	PROPERTY(KeyOnline, int, int, CONF_KEY_ONLINE);
	PROPERTY(KeyReload, int, int, CONF_KEY_RELOAD);
	PROPERTY(KeyDelete, int, int, CONF_KEY_DELETE);
	PROPERTY(KeySearch, int, int, CONF_KEY_SEARCH);
	PROPERTY(KeyTop, int, int, CONF_KEY_TOP);
	PROPERTY(KeyBottom, int, int, CONF_KEY_BOTTOM);
	PROPERTY(KeyCloseTab, int, int, CONF_KEY_CLOSETAB);
	PROPERTY(KeyNext, int, int, CONF_KEY_NEXT);
	PROPERTY(KeyPrev, int, int, CONF_KEY_PREV);
	PROPERTY(KeyNextLink, int, int, CONF_KEY_NEXTLINK);
	PROPERTY(KeyPrevLink, int, int, CONF_KEY_PREVLINK);
	PROPERTY(KeyMenu, int, int, CONF_KEY_MENU);
	PROPERTY(KeyNextTab, int, int, CONF_KEY_NEXTTAB);
	PROPERTY(KeyPrevTab, int, int, CONF_KEY_PREVTAB);
	PROPERTY(KeyBack, int, int, CONF_KEY_BACK);
	PROPERTY(KeyOpenBookmark, int, int, CONF_KEY_OPENBOOKMARK);
	PROPERTY(KeyAddBookmark, int, int, CONF_KEY_ADDBOOKMARK);
	PROPERTY(KeySort, int, int, CONF_KEY_SORT);
	PROPERTY(KeyEdit, int, int, CONF_KEY_EDIT);
	PROPERTY(KeyEditReply, int, int, CONF_KEY_EDITREPLY);
	PROPERTY(KeyFind2ch, int, int, CONF_KEY_FIND2CH);
	PROPERTY(KeyNextLine, int, int, CONF_KEY_NEXTLINE);
	PROPERTY(KeyPrevLine, int, int, CONF_KEY_PREVLINE);

	// ŕۑ
	PROPERTY_HISTORY(HistoryName, 30, CONF_HISTORY_NAME);
	PROPERTY_HISTORY(HistoryMail, 30, CONF_HISTORY_MAIL);
	PROPERTY_HISTORY(HistorySearchWord, 30, CONF_HISTORY_SEARCHWORD);

	// J
	PROPERTY_INTARRAY(ColumnWidthBookmark, CONF_COLUMNWIDTH_BOOKMARK);
	PROPERTY_INTARRAY(ColumnWidthSubject, CONF_COLUMNWIDTH_SUBJECT);
	PROPERTY_INTARRAY(ColumnWidthCache, CONF_COLUMNWIDTH_CACHE);

	// \[g
	PROPERTY(SortColumnBookmark, int, int, CONF_SORTCOLUMN_BOOKMARK);
	PROPERTY(SortColumnSubject, int, int, CONF_SORTCOLUMN_SUBJECT);
	PROPERTY(SortColumnCache, int, int, CONF_SORTCOLUMN_CACHE);
	PROPERTY(SortAscBookmark, BOOL, BOOL, CONF_SORTASC_BOOKMARK);
	PROPERTY(SortAscSubject, BOOL, BOOL, CONF_SORTASC_SUBJECT);
	PROPERTY(SortAscCache, BOOL, BOOL, CONF_SORTASC_CACHE);

	Cq2chwmConfig(const char *chp_filename);
	static void Delete();

	void write(const char *chp_name, const char *chp_value);
	void write(const char *chp_name, int in_value);
	void write(const char *chp_name, CYoDataArray& cArray);
	void write(const char *chp_name, CYoPtrArray& cArray);
	void readKeyConf();

public:
	static Cq2chwmConfig *GetInstance();

	~Cq2chwmConfig();
	void SetConfigKey(const Cq2chwmConfigKey &cConfigKey);

};

class Cq2chwmConfigKey
{
private:
	struct _key_list {
		char cha_name[64];
		char cha_conf_name[64];
		int in_code;
		BOOL bo_changed;
	};
	struct _key_list *m_stp_key_list;
	int m_in_count;

public:
	Cq2chwmConfigKey()
	{
	struct _key_list sta_key_list[] = {
		{"LZ", CONF_KEY_CANCEL, Cq2chwmConfig::GetInstance()->GetKeyCancel(), FALSE},
		{"j[", CONF_KEY_MENU, Cq2chwmConfig::GetInstance()->GetKeyMenu(), FALSE},
		{"On/Off", CONF_KEY_ONLINE, Cq2chwmConfig::GetInstance()->GetKeyOnline(), FALSE},
		{"[h", CONF_KEY_RELOAD, Cq2chwmConfig::GetInstance()->GetKeyReload(), FALSE},
		{"폜", CONF_KEY_DELETE, Cq2chwmConfig::GetInstance()->GetKeyDelete(), FALSE},
		{"Q˂錟", CONF_KEY_FIND2CH, Cq2chwmConfig::GetInstance()->GetKeyFind2ch(), FALSE},
//		{"ID", CONF_KEYSEARCHID, Cq2chwmConfig::GetInstance()->GetKeySearchId(), FALSE},
		{"", CONF_KEY_SEARCH, Cq2chwmConfig::GetInstance()->GetKeySearch(), FALSE},
		{"", CONF_KEY_TOP, Cq2chwmConfig::GetInstance()->GetKeyTop(), FALSE},
		{"", CONF_KEY_BOTTOM, Cq2chwmConfig::GetInstance()->GetKeyBottom(), FALSE},
		{"\[g", CONF_KEY_SORT, Cq2chwmConfig::GetInstance()->GetKeySort(), FALSE},
		{"XN[", CONF_KEY_PREVLINE, Cq2chwmConfig::GetInstance()->GetKeyPrevLine(), FALSE},
		{"XN[", CONF_KEY_NEXTLINE, Cq2chwmConfig::GetInstance()->GetKeyNextLine(), FALSE},
//		{"N", CONF_KEYGOTOURL, Cq2chwmConfig::GetInstance()->GetKeyGotoUrl(), FALSE},
//		{"VKXbh쐬", CONF_KEYCREATETHREAD, Cq2chwmConfig::GetInstance()->GetKeyCreateThread(), FALSE},
//		{"S\", CONF_KEYVIEWLOGO, Cq2chwmConfig::GetInstance()->GetKeyViewLogo(), FALSE},
//		{"ۑ", CONF_KEYIMAGESAVE, Cq2chwmConfig::GetInstance()->GetKeyImageSave(), FALSE},

//		{"XN[(Article)", CONF_KEYAPAGEUP, Cq2chwmConfig::GetInstance()->GetKeyArticleUp(), FALSE},
//		{"XN[(Article)", CONF_KEYAPAGEDOWN, Cq2chwmConfig::GetInstance()->GetKeyArticleDown(), FALSE},
//		{"y[WAbv(Article)", CONF_KEYASCROLLUP, Cq2chwmConfig::GetInstance()->GetKeyArticleScrollUp(), FALSE},
//		{"y[W_E(Article)", CONF_KEYASCROLLDOWN, Cq2chwmConfig::GetInstance()->GetKeyArticleScrollDown(), FALSE},
		{"̃bZ[W", CONF_KEY_NEXT, Cq2chwmConfig::GetInstance()->GetKeyNext(), FALSE},
		{"ÕbZ[W", CONF_KEY_PREV, Cq2chwmConfig::GetInstance()->GetKeyPrev(), FALSE},
		{"̃N", CONF_KEY_NEXTLINK, Cq2chwmConfig::GetInstance()->GetKeyNextLink(), FALSE},
		{"ÕN", CONF_KEY_PREVLINK, Cq2chwmConfig::GetInstance()->GetKeyPrevLink(), FALSE},
		{"Nֈړ", CONF_KEY_BACK, Cq2chwmConfig::GetInstance()->GetKeyBack(), FALSE},
		{"̃^u", CONF_KEY_NEXTTAB, Cq2chwmConfig::GetInstance()->GetKeyNextTab(), FALSE},
		{"Õ^u", CONF_KEY_PREVTAB, Cq2chwmConfig::GetInstance()->GetKeyPrevTab(), FALSE},
//		{"̃ubN}[N", CONF_KEYNEXTBOOKMARK, Cq2chwmConfig::GetInstance()->GetKeyNextBookmark(), FALSE},
//		{"\X̔ꗗ", CONF_KEYOPENLIST, Cq2chwmConfig::GetInstance()->GetKeyOpenList(), FALSE},
		{"^u", CONF_KEY_CLOSETAB, Cq2chwmConfig::GetInstance()->GetKeyCloseTab(), FALSE},
//		{"Xځ[/", CONF_KEYHIDEMESSAGE, Cq2chwmConfig::GetInstance()->GetKeyHideMessage(), FALSE},
//		{"ځ[؂ւ", CONF_KEYTOGGLELOCALABONE, Cq2chwmConfig::GetInstance()->GetKeyToggleLocalAbone(), FALSE},
//		{"܂Ԃ؂ւ", CONF_KEYTOGGLEWRAP, Cq2chwmConfig::GetInstance()->GetKeyToggleWrap(), FALSE},
//		{"tHg؂ւ", CONF_KEYCHANGEAFONT, Cq2chwmConfig::GetInstance()->GetKeyChangeAFont(), FALSE},

		{"bZ[W쐬", CONF_KEY_EDIT, Cq2chwmConfig::GetInstance()->GetKeyEdit(), FALSE},
		{"bZ[W쐬(ԐM)", CONF_KEY_EDITREPLY, Cq2chwmConfig::GetInstance()->GetKeyEditReply(), FALSE},
//		{"M", CONF_KEYSEND, Cq2chwmConfig::GetInstance()->GetKeySend(), FALSE},
		{"ubN}[N", CONF_KEY_OPENBOOKMARK, Cq2chwmConfig::GetInstance()->GetKeyOpenBookmark(), FALSE},
		{"ubN}[Nǉ", CONF_KEY_ADDBOOKMARK, Cq2chwmConfig::GetInstance()->GetKeyAddBookmark(), FALSE},
//		{"ubN}[N\t", CONF_KEYPASTEBOOKMARK, Cq2chwmConfig::GetInstance()->GetKeyPasteBookmark(), FALSE},
	};
	m_stp_key_list = (struct _key_list*)malloc(sizeof(sta_key_list));
	memcpy(m_stp_key_list, &sta_key_list, sizeof(sta_key_list));
	m_in_count = sizeof(sta_key_list)/sizeof(sta_key_list[0]);
	}
	~Cq2chwmConfigKey(){ free(m_stp_key_list); }
	inline const char *GetName(int in_index) const {return m_stp_key_list[in_index].cha_name;}
	inline const char *GetConfName(int in_index) const {return m_stp_key_list[in_index].cha_conf_name;}
	inline int GetCode(int in_index) const {return m_stp_key_list[in_index].in_code;}
	inline BOOL GetChanged(int in_index) const {return m_stp_key_list[in_index].bo_changed;}
	inline void SetCode(int in_index, int in_code)
	{
		if (m_stp_key_list[in_index].in_code == in_code) return;
		m_stp_key_list[in_index].in_code = in_code;
		m_stp_key_list[in_index].bo_changed = TRUE;
	}
	const char *GetCodeName(int in_index);
	void Write();
	inline int Count() const {return m_in_count;}
};
