// q2chwmConfigDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmConfigDialog.h"
#include "q2chwmPageSystem.h"
#include "q2chwmPageFont.h"
#include "q2chwmPageColor.h"
#include "q2chwmPageNetwork.h"
#include "q2chwmPageKey.h"
#include "q2chwmPageBoard.h"

// Cq2chwmConfigDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmConfigDialog, CDialog)

Cq2chwmConfigDialog::Cq2chwmConfigDialog(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmConfigDialog::IDD, pParent), m_cTab(FALSE)
{
	m_pSystem = NULL;
	m_pFont= NULL;
	m_pColor= NULL;
	m_pNetwork = NULL;
	m_pKey = NULL;
}

Cq2chwmConfigDialog::~Cq2chwmConfigDialog()
{
	delete m_pSystem;
	delete m_pFont;
	delete m_pColor;
	delete m_pNetwork;
	delete m_pKey;
	delete m_pBoard;
}

void Cq2chwmConfigDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmConfigDialog, CDialog)
	ON_WM_SIZE()
	ON_MESSAGE(WM_USER_TABCLICKED, OnTabClicked)
	ON_COMMAND(ID_MENU_CANCEL, &Cq2chwmConfigDialog::OnMenuCancel)
	ON_COMMAND(ID_MENU_OK, &Cq2chwmConfigDialog::OnMenuOk)
END_MESSAGE_MAP()


// Cq2chwmConfigDialog bZ[W nh

void Cq2chwmConfigDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	CTabCtrl *pTab = (CTabCtrl*)GetDlgItem(IDC_TAB);
	if (pTab != NULL && pTab->m_hWnd != NULL) {
		// ^uTCY
		RECT r;
		pTab->GetItemRect(0, &r);
		pTab->MoveWindow(0, 0, cx, r.bottom - r.top);
		//pTab->MoveWindow(0, 0, cx, cy);

		// ^uɊ֘AtSy[WTCY
		for (int i = 0; i < pTab->GetItemCount(); i++) {
			TCITEM st_item;
			st_item.mask = TCIF_PARAM;
			pTab->GetItem(i, &st_item);
			CDialog *pPage = (CDialog*)st_item.lParam;
			if (pPage != NULL) {
				pPage->MoveWindow(0, r.bottom, cx, cy - r.bottom);
			}
		}
	}
}

BOOL Cq2chwmConfigDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	m_cTab.Create(WS_BORDER|TCS_BUTTONS|TCS_FLATBUTTONS, CRect(0, 0, 0, 0), this, IDC_TAB);
	m_cTab.ShowWindow(SW_SHOW);
	m_cTab.SetFont(GetFont());
	CTabCtrl *pTab = (CTabCtrl*)GetDlgItem(IDC_TAB);

	// ^u쐬
	pTab->InsertItem(0, _T("VXe"));
	pTab->InsertItem(1, _T("tHg"));
	pTab->InsertItem(2, _T("J["));
	pTab->InsertItem(3, _T("lbg[N"));
	pTab->InsertItem(4, _T("L["));
	pTab->InsertItem(5, _T(""));

	// y[W쐬
	CWnd *pParent = this;
	m_pSystem = new Cq2chwmPageSystem;
	m_pSystem->Create(IDD_CONFIG_SYSTEM, pParent);
	pTab->SetWindowPos(m_pSystem, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE|SWP_NOACTIVATE);
	m_pFont = new Cq2chwmPageFont;
	m_pFont->Create(IDD_CONFIG_FONT, pParent);
	m_pColor= new Cq2chwmPageColor;
	m_pColor->Create(IDD_CONFIG_COLOR, pParent);
	m_pNetwork = new Cq2chwmPageNetwork;
	m_pNetwork->Create(IDD_CONFIG_NETWORK, pParent);
	m_pKey = new Cq2chwmPageKey;
	m_pKey->Create(IDD_CONFIG_KEY, pParent);
	m_pBoard = new Cq2chwmPageBoard;
	m_pBoard->Create(IDD_CONFIG_BOARD, pParent);

	// ^uɃy[W֘At
	TCITEM st_item;
	st_item.mask = TCIF_PARAM;
	st_item.lParam = (LPARAM)m_pSystem;
	pTab->SetItem(0, &st_item);
	st_item.lParam = (LPARAM)m_pFont;
	pTab->SetItem(1, &st_item);
	st_item.lParam = (LPARAM)m_pColor;
	pTab->SetItem(2, &st_item);
	st_item.lParam = (LPARAM)m_pNetwork;
	pTab->SetItem(3, &st_item);
	st_item.lParam = (LPARAM)m_pKey;
	pTab->SetItem(4, &st_item);
	st_item.lParam = (LPARAM)m_pBoard;
	pTab->SetItem(5, &st_item);

	pTab->SetCurSel(0);
	m_pSystem->ShowWindow(SW_SHOW);

	// CAEĝ
	RECT st_rect;
	GetClientRect(&st_rect);
	SendMessage(WM_SIZE, 0, MAKELPARAM(st_rect.right - st_rect.left, st_rect.bottom - st_rect.top));

#ifdef WIN32_PLATFORM_PSPC
	if (!m_wndCommandBar.Create(this) ||
	    !m_wndCommandBar.InsertMenuBar(IDR_MENU_DIALOG) ||
	    !m_wndCommandBar.AddAdornments())
	{
		TRACE0("CommandBar ̍쐬Ɏs܂\n");
		return FALSE;
	}
	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() | CBRS_SIZE_FIXED);
#endif // WIN32_PLATFORM_PSPC

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmConfigDialog::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	m_pSystem->Write();
	m_pFont->Write();
	m_pColor->Write();
	m_pNetwork->Write();
	m_pKey->Write();
	m_pBoard->Write();

	CDialog::OnOK();
}

BOOL Cq2chwmConfigDialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	CTabCtrl *pTab = (CTabCtrl*)GetDlgItem(IDC_TAB);
	int in_cur = pTab->GetCurSel();
	TCITEM st_item;
	st_item.mask = TCIF_PARAM;
	pTab->GetItem(in_cur, &st_item);
	Cq2chwmConfigPage *pPage = (Cq2chwmConfigPage*)st_item.lParam;
	if (pPage->GetLastCtrl()->m_hWnd == pMsg->hwnd) {
		TRACE(_T("%x %d\n"), pMsg->hwnd, pMsg->message);
	}
	return CDialog::PreTranslateMessage(pMsg);
}

BOOL Cq2chwmConfigPage::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	cs.style |= WS_TABSTOP|WS_GROUP;
	return CDialog::PreCreateWindow(cs);
}
BEGIN_MESSAGE_MAP(Cq2chwmConfigPage, CDialog)
	ON_WM_GETDLGCODE()
END_MESSAGE_MAP()

UINT Cq2chwmConfigPage::OnGetDlgCode()
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	return CDialog::OnGetDlgCode();
}

BOOL Cq2chwmConfigDialog::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	return CDialog::OnNotify(wParam, lParam, pResult);
}

BOOL Cq2chwmConfigPage::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	//TRACE(_T("Cq2chwmConfigPage::OnNotify: wParam=%08x lParam=%08x\n"), wParam, lParam);
	return CDialog::OnNotify(wParam, lParam, pResult);
}

BOOL Cq2chwmConfigPage::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	//TRACE(_T("Cq2chwmConfigPage::OnChildNotify: wParam=%08x lParam=%08x\n"), wParam, lParam);
	return CDialog::OnChildNotify(message, wParam, lParam, pLResult);
}

void Cq2chwmConfigDialog::OnMenuCancel()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnCancel();
}

void Cq2chwmConfigDialog::OnMenuOk()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnOK();
}

long Cq2chwmConfigDialog::OnTabClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	CTabCtrl *pTab = (CTabCtrl*)GetDlgItem(IDC_TAB);

	// Sy[W\ɂ
	for (int i = 0; i < pTab->GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		pTab->GetItem(i, &st_item);
		CDialog *pPage = (CDialog*)st_item.lParam;
		if (pPage != NULL) {
			pPage->ShowWindow(SW_HIDE);
		}
	}

	// Jg^uɊ֘Aty[W\
	int in_cur = pTab->GetCurSel();
	TCITEM st_item;
	st_item.mask = TCIF_PARAM;
	pTab->GetItem(in_cur, &st_item);
	Cq2chwmConfigPage *pPage = (Cq2chwmConfigPage*)st_item.lParam;
	pPage->ShowWindow(SW_SHOW);

	return 0;
}
