// q2chwmPageFont.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmPageFont.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"
#include "q2chwmConfigDialog.h"

// Cq2chwmPageFont _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageFont, CDialog)

Cq2chwmPageFont::Cq2chwmPageFont(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageFont::IDD, pParent)
{

}

Cq2chwmPageFont::~Cq2chwmPageFont()
{
}

void Cq2chwmPageFont::DoDataExchange(CDataExchange* pDX)
{
	DDX_Control(pDX, IDC_COMBO_FONTLIST, m_cComboFontList);
	DDX_Control(pDX, IDC_COMBO_FONTBOARD, m_cComboFontBoard);
	DDX_Control(pDX, IDC_COMBO_FONTMESSAGE, m_cComboFontMessage);
	DDX_Control(pDX, IDC_COMBO_FONTCACHE, m_cComboFontCache);
	DDX_Control(pDX, IDC_COMBO_FONTBOOKMARK, m_cComboFontBookmark);
	DDX_Control(pDX, IDC_COMBO_FONTTAB, m_cComboFontTab);
	DDX_Control(pDX, IDC_COMBO_FONTARTICLE, m_cComboFontArticle);
	DDX_Control(pDX, IDC_COMBO_SIZELIST, m_cComboSizeList);
	DDX_Control(pDX, IDC_COMBO_SIZEBOARD, m_cComboSizeBoard);
	DDX_Control(pDX, IDC_COMBO_SIZEMESSAGE, m_cComboSizeMessage);
	DDX_Control(pDX, IDC_COMBO_SIZECACHE, m_cComboSizeCache);
	DDX_Control(pDX, IDC_COMBO_SIZEBOOKMARK, m_cComboSizeBookmark);
	DDX_Control(pDX, IDC_COMBO_SIZETAB, m_cComboSizeTab);
	DDX_Control(pDX, IDC_COMBO_SIZEARTICLE, m_cComboSizeArticle);
	Cq2chwmConfigPage::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageFont, Cq2chwmConfigPage)
	ON_WM_SIZE()
END_MESSAGE_MAP()


// Cq2chwmPageFont bZ[W nh

void Cq2chwmPageFont::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FONTLIST), 2, GetDlgItem(IDC_COMBO_FONTLIST), 3, GetDlgItem(IDC_COMBO_SIZELIST), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FONTBOARD), 2, GetDlgItem(IDC_COMBO_FONTBOARD), 3, GetDlgItem(IDC_COMBO_SIZEBOARD), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FONTARTICLE), 2, GetDlgItem(IDC_COMBO_FONTARTICLE), 3, GetDlgItem(IDC_COMBO_SIZEARTICLE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FONTBOOKMARK), 2, GetDlgItem(IDC_COMBO_FONTBOOKMARK), 3, GetDlgItem(IDC_COMBO_SIZEBOOKMARK), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FONTCACHE), 2, GetDlgItem(IDC_COMBO_FONTCACHE), 3, GetDlgItem(IDC_COMBO_SIZECACHE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FONTMESSAGE), 2, GetDlgItem(IDC_COMBO_FONTMESSAGE), 3, GetDlgItem(IDC_COMBO_SIZEMESSAGE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FONTTAB), 2, GetDlgItem(IDC_COMBO_FONTTAB), 3, GetDlgItem(IDC_COMBO_SIZETAB), 1)
	);
	cLayout.Layout(cx, cy);
}

int CALLBACK EnumFontFamExProc(
	ENUMLOGFONTEX *lpelfe,
	NEWTEXTMETRICEX *lpntm,
	int FontType, LPARAM lParam)
{
	CComboBox *pComboBox = (CComboBox *)lParam;
	// {TrueTypeFont̂݃R{{bNXɃtHgǉ
	if( FontType == TRUETYPE_FONTTYPE
		// && lpelfe->elfLogFont.lfPitchAndFamily & FIXED_PITCH	// 
		&& lpelfe->elfLogFont.lfCharSet == SHIFTJIS_CHARSET)
	{
		pComboBox->AddString(lpelfe->elfLogFont.lfFaceName);
	}
	// tHg̗񋓂pɂ1C~ɂ0߂B
	return( 1 );
}

BOOL Cq2chwmPageFont::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ
	// tHgꗗZbg
	HDC hdc = ::GetDC(this->GetSafeHwnd());
	LOGFONT LogFont;
	ZeroMemory(&LogFont, sizeof(LOGFONT));
	LogFont.lfCharSet = DEFAULT_CHARSET;

	EnumFontFamiliesEx(hdc, &LogFont, (FONTENUMPROC)EnumFontFamExProc, (LPARAM)&m_cComboFontList, 0);
	EnumFontFamiliesEx(hdc, &LogFont, (FONTENUMPROC)EnumFontFamExProc, (LPARAM)&m_cComboFontBoard, 0);
	EnumFontFamiliesEx(hdc, &LogFont, (FONTENUMPROC)EnumFontFamExProc, (LPARAM)&m_cComboFontMessage, 0);
	EnumFontFamiliesEx(hdc, &LogFont, (FONTENUMPROC)EnumFontFamExProc, (LPARAM)&m_cComboFontCache, 0);
	EnumFontFamiliesEx(hdc, &LogFont, (FONTENUMPROC)EnumFontFamExProc, (LPARAM)&m_cComboFontBookmark, 0);
	EnumFontFamiliesEx(hdc, &LogFont, (FONTENUMPROC)EnumFontFamExProc, (LPARAM)&m_cComboFontTab, 0);
	EnumFontFamiliesEx(hdc, &LogFont, (FONTENUMPROC)EnumFontFamExProc, (LPARAM)&m_cComboFontArticle, 0);

	// tHgݒlJgɃZbg
	CString cstr_name;
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameList();
	m_cComboFontList.SelectString(-1, cstr_name);
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameBoard();
	m_cComboFontBoard.SelectString(-1, cstr_name);
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameMessage();
	m_cComboFontMessage.SelectString(-1, cstr_name);
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameCache();
	m_cComboFontCache.SelectString(-1, cstr_name);
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameBookmark();
	m_cComboFontBookmark.SelectString(-1, cstr_name);
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameTab();
	m_cComboFontTab.SelectString(-1, cstr_name);
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameArticle();
	m_cComboFontArticle.SelectString(-1, cstr_name);

	// tHgTCYݒlJgɃZbg
	cstr_name.Format(_T("%d"), Cq2chwmConfig::GetInstance()->GetFontSizeList());
	m_cComboSizeList.SelectString(-1, cstr_name);
	cstr_name.Format(_T("%d"), Cq2chwmConfig::GetInstance()->GetFontSizeBoard());
	m_cComboSizeBoard.SelectString(-1, cstr_name);
	cstr_name.Format(_T("%d"), Cq2chwmConfig::GetInstance()->GetFontSizeMessage());
	m_cComboSizeMessage.SelectString(-1, cstr_name);
	cstr_name.Format(_T("%d"), Cq2chwmConfig::GetInstance()->GetFontSizeCache());
	m_cComboSizeCache.SelectString(-1, cstr_name);
	cstr_name.Format(_T("%d"), Cq2chwmConfig::GetInstance()->GetFontSizeBookmark());
	m_cComboSizeBookmark.SelectString(-1, cstr_name);
	cstr_name.Format(_T("%d"), Cq2chwmConfig::GetInstance()->GetFontSizeTab());
	m_cComboSizeTab.SelectString(-1, cstr_name);
	cstr_name.Format(_T("%d"), Cq2chwmConfig::GetInstance()->GetFontSizeArticle());
	m_cComboSizeArticle.SelectString(-1, cstr_name);

	::ReleaseDC(this->GetSafeHwnd( ), hdc);
	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmPageFont::Write()
{
	CString cstr_val;
	CYoString str_val;

	// tHg
	m_cComboFontList.GetLBText(m_cComboFontList.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontNameList(str_val);
	m_cComboFontBoard.GetLBText(m_cComboFontBoard.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontNameBoard(str_val);
	m_cComboFontMessage.GetLBText(m_cComboFontMessage.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontNameMessage(str_val);
	m_cComboFontCache.GetLBText(m_cComboFontCache.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontNameCache(str_val);
	m_cComboFontBookmark.GetLBText(m_cComboFontBookmark.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontNameBookmark(str_val);
	m_cComboFontTab.GetLBText(m_cComboFontTab.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontNameTab(str_val);
	m_cComboFontArticle.GetLBText(m_cComboFontArticle.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontNameArticle(str_val);

	// tHgTCY
	m_cComboSizeList.GetLBText(m_cComboSizeList.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontSizeList(str_val);
	m_cComboSizeBoard.GetLBText(m_cComboSizeBoard.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontSizeBoard(str_val);
	m_cComboSizeMessage.GetLBText(m_cComboSizeMessage.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontSizeMessage(str_val);
	m_cComboSizeCache.GetLBText(m_cComboSizeCache.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontSizeCache(str_val);
	m_cComboSizeBookmark.GetLBText(m_cComboSizeBookmark.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontSizeBookmark(str_val);
	m_cComboSizeTab.GetLBText(m_cComboSizeTab.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontSizeTab(str_val);
	m_cComboSizeArticle.GetLBText(m_cComboSizeArticle.GetCurSel(), cstr_val);
	str_val = A(cstr_val);
	Cq2chwmConfig::GetInstance()->SetFontSizeArticle(str_val);
}
