#include "StdAfx.h"
#include "q2chwmSubjectItem.h"
#include "q2chwmCommon.h"
#include "q2chwmBookmarkFile.h"

Cq2chwmSubjectItem::Cq2chwmSubjectItem(
	int in_index,
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_burl,
	const char *chp_bid,
	const char *chp_count) : Cq2chwmListItem(in_index, chp_aname, chp_aid, chp_bname, chp_bid, chp_burl)
{
	m_str_count = chp_count;
	m_in_count_new = 0;
}

Cq2chwmSubjectItem::~Cq2chwmSubjectItem()
{
}

BOOL Cq2chwmSubjectItem::GetCache()
{
	return ExistFile(GetFileName());
}

int Cq2chwmSubjectItem::GetState()
{
	int in_state = Cq2chwmListItem::STATE_NORMAL;
	if (Cq2chwmBookmarkFile::GetInstance()->Search(GetArticleUrl()) >= 0) {
		in_state |= Cq2chwmListItem::STATE_BOOKMARK;
	}
	if (GetNew() == TRUE) in_state |= Cq2chwmListItem::STATE_NEW;
	return in_state;
}
