#include "StdAfx.h"
#include "YoHttpClient.h"
#include "MainFrm.h"
#include "q2chwmCommon.h"
#include "q2chwmBoardFile.h"
#include "q2chwmConfig.h"

Cq2chwmBoardFileEtc::Cq2chwmBoardFileEtc() : Cq2chwmBoardFile()
{
	m_str_filename = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	m_str_filename += "\\etc.txt";
}

Cq2chwmBoardFile::Cq2chwmBoardFile(
	const char *chp_filename)
{
	if (chp_filename == NULL) {
		m_str_filename = Cq2chwmConfig::GetInstance()->GetRootDirectory();
		m_str_filename += "\\board.txt";
	} else {
		m_str_filename = chp_filename;
	}
}

Cq2chwmBoardFile::~Cq2chwmBoardFile()
{
}

int Cq2chwmBoardFile::CreateFromFile()
{
	RemoveAll();
	CYoTextFile cFile(m_str_filename, CYoFile::READ);
	if (cFile.Open() == FALSE) return ERR_FILE_OPEN;
	CYoString str_line;
	CYoRegex cRegex("ʊ|`bg|c[|̃TCg", CYoRegex::SJIS);
	while (cFile.Eof() == FALSE) {
		cFile.ReadLine(str_line);
		str_line.Trim();
		// 3sZbgœǂ
		CYoString str_name = str_line;
		cFile.ReadLine(str_line);
		str_line.Trim();
		if (cFile.Eof() == TRUE) break;
		CYoString str_url = str_line;
		cFile.ReadLine(str_line);
		str_line.Trim();
		if (cFile.Eof() == TRUE) break;
		CYoString str_key = str_line;

		if (cRegex.Match(str_name) == -1) {
			Add((const char *)str_name, (const char*)str_url, (const char*)str_key, NULL);
		}
	}
	cFile.Close();

	return ERR_NONE;
}

int Cq2chwmBoardFile::CreateFromHttp(
	const char *chp_url)
{
	RemoveAll();
	CYoHttpClient cHttp(chp_url);
	cHttp.SetUserAgent(USERAGENT);
	if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
		cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
		cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
	}
	cHttp.SetCallbackProc(CMainFrame::CallbackProc, AfxGetMainWnd());

	if (cHttp.Connect(TIMEOUT) == FALSE) {
		return ERR_HTTP_CONNECT;
	}

	if (cHttp.Get() == FALSE) {
		return ERR_HTTP_GET;
	}

	if (cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300) {
		return ERR_HTTP_GET;
	}

	// bbsmenu.html̂܂board.txt.tmpɏ
	CString cstr_filename;
	cstr_filename = m_str_filename;
	CString cstr_filename_tmp = cstr_filename + _T(".tmp");
	{
		CFile cFileTmp;
		if (cFileTmp.Open(cstr_filename_tmp, CFile::modeCreate|CFile::modeWrite) == FALSE) {
			return ERR_FILE_OPEN;
		}

		CYoString str_length = cHttp.GetResponseHeader("Content-Length");
		int in_length = str_length.Atoi();
		int in_recv = 0;

		char cha_buff[RECV_BUFF];
		int in_ret;
		while ((in_ret = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0) {
			cFileTmp.Write(cha_buff, in_ret);
			in_recv += in_ret;
			AfxGetMainWnd()->SendMessage(cHttp.GetRecvSize(), in_length);
		}
		cFileTmp.Close();
		if (in_ret == 0 && ((CMainFrame*)AfxGetMainWnd())->Canceled() == TRUE) {
			return ERR_CANCELED;
		}
		if( in_ret == SOCKET_ERROR ){
			return ERR_HTTP_RECV;
		}
	}

	// obNAbvt@C쐬(board.txt -> board.txt.bak)
	CYoString str_filename_bak = m_str_filename + ".bak";
	RenameFile(m_str_filename, str_filename_bak);

	// board.txt.tmp(gbbsmenu.html)board.txt쐬
	CFile cFile;
	if (cFile.Open(cstr_filename, CFile::modeCreate|CFile::modeWrite) == FALSE) {
		return ERR_FILE_OPEN;
	}
	CYoString str_filename_tmp = A(cstr_filename_tmp);
	CYoTextFile cFileTmp(str_filename_tmp, CYoFile::READ);
	if (cFileTmp.Open() == FALSE) {
		return ERR_FILE_OPEN;
	}

	CYoRegex cRegexParent("^<[bB][rR]><[bB][rR]><[bB]>(.+)</[bB]><[bB][rR]>", CYoRegex::SJIS);
	CYoRegex cRegexChild1("^<[aA] [hH][rR][eE][fF]=(http://.+/(.+)/)>(.+)</[aA]>", CYoRegex::SJIS);
	CYoRegex cRegexChild2("^<[aA] [hH][rR][eE][fF]=(http://([^ ]+)/)>(.+)</[aA]>", CYoRegex::SJIS);
	CYoRegex cRegexChild3("^<[aA] [hH][rR][eE][fF]=(http://([^ ]+)/) TARGET=_blank>(.+)</[aA]>", CYoRegex::SJIS); // ܂aar
	CYoRegex *pRegex;
	CYoString str_line;
	while (cFileTmp.Eof() == FALSE) {
		cFileTmp.ReadLine(str_line);
		str_line.Trim();
		if (cRegexParent.Match(str_line) >= 0) {
			// e
			char *chp_name = cRegexParent.Get(1);
			cFile.Write(chp_name, strlen(chp_name));
			// siLF)R
			char *chp_lf = LF""LF""LF;
			cFile.Write(chp_lf, strlen(chp_lf));

			while (cFileTmp.ReadLine(str_line) > 0) {
				str_line.Trim();
				if (str_line.Length() == 0) {
					break;
				}
				
				if (cRegexChild1.Match(str_line) >= 0) {
					pRegex = &cRegexChild1;
				} else if (cRegexChild2.Match(str_line) >= 0) {
					pRegex = &cRegexChild2;
				} else if (cRegexChild3.Match(str_line) >= 0) {
					pRegex = &cRegexChild3;
				} else {
					break;
				}

				// q
				char *chp_name = pRegex->Get(3);
				char *chp_url = pRegex->Get(1);
				char *chp_dir = pRegex->Get(2);
				char *chp_lf = LF;
				cFile.Write(chp_name, strlen(chp_name));
				cFile.Write(chp_lf, strlen(chp_lf));
				cFile.Write(chp_url, strlen(chp_url));
				cFile.Write(chp_lf, strlen(chp_lf));
				cFile.Write(chp_dir, strlen(chp_dir));
				cFile.Write(chp_lf, strlen(chp_lf));
			}
		}
	}
	cFile.Close();
	cFileTmp.Close();
	RemoveFile(str_filename_tmp);

	return CreateFromFile();
}

int Cq2chwmBoardFile::SearchFromUrl(
	const char *chp_url)
{
	return CYoTable::Search(chp_url, 1);
}

int Cq2chwmBoardFile::SearchFromId(
	const char *chp_id)
{
	return CYoTable::Search(chp_id, 2);
}

BOOL Cq2chwmBoardFile::Exist()
{
	return ExistFile(m_str_filename);
}

#define FORMAT "%s\r\n%s\r\n%s\r\n"
int Cq2chwmBoardFile::Write()
{
	CFile cFile;
	CString cstr_filename;
	cstr_filename = GetFileName();
	if (cFile.Open(cstr_filename, CFile::modeCreate|CFile::modeWrite) == FALSE) {
		return ERR_FILE_OPEN;
	}
	CYoString str_fmt;
	CYoString str_name;

	for( int i = 0;i < Rows(); i++ ){
		str_name = GetBoardName(i);
		if(strlen(GetBoardUrl(i)) == 0) {
			// e
			str_fmt.Format(FORMAT, (const char*)str_name, "", "");
		}
		else
		{
			str_fmt.Format(FORMAT, (char*)str_name, GetBoardUrl(i), GetBoardId(i));
		}
		cFile.Write((char*)str_fmt, str_fmt.Length());
	}
	cFile.Close();
	return ERR_NONE;
}

void Cq2chwmBoardFile::AddBoard(
	const char *chp_name,
	const char *chp_url,
	const char *chp_id)
{
	Add(chp_name, chp_url, chp_id, NULL);
}

void Cq2chwmBoardFile::InsertBoard(
	const char *chp_name,
	const char *chp_url,
	const char *chp_id)
{
	Insert(0, chp_name, chp_url, chp_id, NULL);
}
