#pragma once

#include "YoString.h"
#include "q2chwmDatCtrl.h"

// Cq2chwmGrepDialog _CAO

class Cq2chwmGrepDialog : public CDialog
{
	DECLARE_DYNAMIC(Cq2chwmGrepDialog)

private:
	Cq2chwmDatCtrl *m_pDat;
	const wchar_t *m_wchp_text;
	int m_in_jump;
#ifdef WIN32_PLATFORM_PSPC
	CCommandBar m_wndCommandBar;
#else
	CMenu m_cMenu;
#endif

public:
	Cq2chwmGrepDialog(CWnd* pParent = NULL);   // WRXgN^
	virtual ~Cq2chwmGrepDialog();

	void SetText(const wchar_t *wchp_text);
	int GetJumpNumber(){ return m_in_jump; }

// _CAO f[^
	enum { IDD = IDD_DIALOG_GREP };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnInitDialog();
	afx_msg void OnMenuCancel();
	afx_msg void OnMenuCopy();
	afx_msg void OnMenuJump();
	afx_msg void OnMenuCopyAll();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnMenuWrap();
	afx_msg void OnUpdateMenuWrap(CCmdUI *pCmdUI);
};
