#pragma once

#include "q2chwmCommon.h"
#include "YoString.h"
#include "YoPtrArray.h"
#include "YoTable.h"

class Cq2chwmInfoFile
{
private:
	CYoString m_str_filename;
	int m_in_number;			// OɌĂbZ[Wԍ
	int m_in_count;				// dat̍s
	int m_in_max;				// ő{Xԍ
	BOOL m_bo_new;				// VtO
	CYoString m_str_name;		// Oɏ񂾖O
	CYoString m_str_date;		// Oɏ񂾓tH
	CYoString m_str_mail;		// Oɏ񂾃[AhX
	BOOL m_bl_name;				// OZbgꂽ
	BOOL m_bl_date;				// tZbgꂽ
	BOOL m_bl_mail;				// [AhXZbgꂽ
	CYoPtrArray m_cHideArray;	// hidep
	CYoPtrArray m_cImportantArray;	// importantp(q2chłimportantXgNG[hłځ[񂳂ꂽX̕\pɎgp)

public:
	Cq2chwmInfoFile();
	~Cq2chwmInfoFile();

	BOOL Create(const char *chp_burl, const char *chp_aid);
	inline int GetNumber(){ return m_in_number; }
	inline int GetCount(){ return m_in_count; }
	inline int GetMax(){ return m_in_max; }
	inline BOOL GetNew(){ return m_bo_new; }
	const char* GetName();
	const char* GetDate();
	const char* GetMail();
	void SetNumber(int in_number){ m_in_number = in_number; }
	void SetCount(int in_count){ m_in_count = in_count; }
	void SetMax(int in_max){ m_in_max = in_max; }
	void SetNew(BOOL bo_new){ m_bo_new = bo_new; }
	void SetName(const char *chp_name){ m_bl_name = TRUE; m_str_name = chp_name; }
	void SetDate(const char *chp_date){ m_bl_date = TRUE; m_str_date = chp_date; }
	void SetMail(const char *chp_mail){ m_bl_mail = TRUE; m_str_mail = chp_mail; }
	int Write();
	void Clear();
	void AddHideMessage(int in_number){ m_cHideArray.Add(in_number); }
	BOOL RemoveHideMessage(int in_number);
	CYoPtrArray& GetHideArray(){ return m_cHideArray; }
	void AddImportantMessage(int in_number){ m_cImportantArray.Add(in_number); }
	BOOL RemoveImportantMessage(int in_number);
	CYoPtrArray& GetImportantArray(){ return m_cImportantArray; }
	static BOOL Exist(const char *chp_burl, const char *chp_aid);
	const char *GetFileName(){ return m_str_filename; }
	static int Count(const char *chp_burl, const char *chp_aid);
};
