// q2chwmProgramSelector.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmProgramSelector.h"

// Cq2chwmProgramSelector _CAO

IMPLEMENT_DYNAMIC(Cq2chwmProgramSelector, CDialog)

Cq2chwmProgramSelector::Cq2chwmProgramSelector(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmProgramSelector::IDD, pParent)
{
	m_cImageList.Create(32, 32, ILC_COLOR24, 4, 4);
	m_cImageList.SetBkColor(CLR_NONE);

}

Cq2chwmProgramSelector::~Cq2chwmProgramSelector()
{
}

void Cq2chwmProgramSelector::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmProgramSelector, CDialog)
	ON_COMMAND(ID_MENU_OK, &Cq2chwmProgramSelector::OnMenuOk)
	ON_COMMAND(ID_MENU_CANCEL, &Cq2chwmProgramSelector::OnMenuCancel)
	ON_WM_SIZE()
END_MESSAGE_MAP()


// Cq2chwmProgramSelector bZ[W nh

BOOL Cq2chwmProgramSelector::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	// C[WXg̐ݒ
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	pList->SetImageList(&m_cImageList, LVSIL_NORMAL);

	// u\Windows\X^[g j[\vOv擾
	TCHAR szPath[MAX_PATH];
	SHGetSpecialFolderPath(m_hWnd, szPath, CSIDL_PROGRAMS, FALSE);

	// 1̃fBNg*.lnk
	TCHAR *lpszTmp = _tcsrchr(szPath, '\\');
	if (lpszTmp != NULL) *lpszTmp = '\0';

	// 
	if (findShortcut(szPath) == FALSE) {
		return FALSE;
	}

#ifdef WIN32_PLATFORM_PSPC
	if (!m_wndCommandBar.Create(this) ||
	    !m_wndCommandBar.InsertMenuBar(IDR_MENU_DIALOG) ||
	    !m_wndCommandBar.AddAdornments())
	{
		TRACE0("CommandBar ̍쐬Ɏs܂\n");
		return FALSE;
	}
	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() | CBRS_SIZE_FIXED);
#endif // WIN32_PLATFORM_PSPC

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmProgramSelector::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		m_str_path = A(m_cTargetArray.GetAt(pList->GetItemData((int)pos - 1)));
		m_str_path.Replace("\"", "");
	}

	CDialog::OnOK();
}

void Cq2chwmProgramSelector::OnCancel()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	CDialog::OnCancel();
}

void Cq2chwmProgramSelector::OnMenuOk()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnOK();
}

void Cq2chwmProgramSelector::OnMenuCancel()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnCancel();
}

void Cq2chwmProgramSelector::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (GetDlgItem(IDC_LIST) != NULL) {
		GetDlgItem(IDC_LIST)->MoveWindow(0, 0, cx, cy, TRUE);
	}
}

BOOL Cq2chwmProgramSelector::findShortcut(
	const TCHAR *lpszDir)
{
	TCHAR szPath[MAX_PATH];
	_tcscpy_s(szPath, MAX_PATH, lpszDir);
	_tcscat_s(szPath, MAX_PATH, _T("\\*"));
	WIN32_FIND_DATA st_find;
	HANDLE hFind;
	hFind = ::FindFirstFile(szPath, &st_find);
	if (hFind != INVALID_HANDLE_VALUE) {
		do {
			if (_tcscmp(st_find.cFileName, _T(".")) == 0 || _tcscmp(st_find.cFileName, _T("..")) == 0) continue;
			if (st_find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
				CString cstr_dir;
				cstr_dir = lpszDir;
				cstr_dir += "\\";
				cstr_dir += st_find.cFileName;
				if (findShortcut(cstr_dir) == FALSE) {
					return FALSE;
				}
			} else if (_tcscmp(st_find.cFileName + lstrlen(st_find.cFileName) - 4, _T(".lnk")) == 0) {
				// tpX
				CString cstr_link;
				cstr_link = lpszDir;
				cstr_link += "\\";
				cstr_link += st_find.cFileName;

				// ^[Qbg擾
				TCHAR szTarget[MAX_PATH];
				memset(szTarget, 0x00, sizeof(szTarget));
				if (GetShortcutTarget(cstr_link, szTarget, MAX_PATH) == FALSE) {
					return FALSE;
				}
				CString cstr_target = szTarget;
				cstr_target.MakeLower();
				if (_tcsstr(cstr_target, _T(".exe")) != NULL) {
					// V[gJbgt@CACR擾
					SHFILEINFO shinfo;
					HIMAGELIST hImageList = (HIMAGELIST)::SHGetFileInfo(cstr_link, 0, &shinfo, sizeof(shinfo),
						SHGFI_DISPLAYNAME|SHGFI_ICON|SHGFI_SMALLICON|SHGFI_SYSICONINDEX);
					if (hImageList != 0) {
						m_cImageList.Add(shinfo.hIcon);
					} else {
						// ACRȂ
						m_cImageList.Add(AfxGetApp()->LoadIcon(IDI_NORMAL));
					}

					// .lnk폜
					TCHAR szName[MAX_PATH];
					_tcscpy_s(szName, MAX_PATH, st_find.cFileName);
					TCHAR *lpszTmp = _tcsrchr(szName, '.');
					if (lpszTmp != NULL) *lpszTmp = '\0';

					// ACeǉ
					CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
					LVITEM lvi;
					memset(&lvi, 0x00, sizeof(lvi));
					lvi.mask = LVIF_TEXT|LVIF_IMAGE|LVIF_PARAM;
					lvi.pszText = szName;
					lvi.cchTextMax = MAX_PATH;
					lvi.iImage = m_cImageList.GetImageCount() - 1;
					lvi.lParam = pList->GetItemCount();
					lvi.iItem = pList->GetItemCount();
					pList->InsertItem(&lvi);
					m_cTargetArray.Add(szTarget);
				}
			}
		} while (FindNextFile(hFind, &st_find));
		::FindClose(hFind);
	}
	return TRUE;
}

BOOL Cq2chwmProgramSelector::GetShortcutTarget(
	const TCHAR *lpszLinkFile,
	TCHAR *lpszTargetFile,
	int in_size)
{
#ifdef WIN32_PLATFORM_PSPC
	return ::SHGetShortcutTarget(lpszLinkFile, lpszTargetFile, MAX_PATH);
#else
	IShellLink *psl;
	::CoInitialize(NULL);
	if (CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLink, (void**)&psl) == S_OK) {
		// V[gJbg̃[h
		IPersistFile *ppf;
		if (psl->QueryInterface(IID_IPersistFile, (void**)&ppf) == S_OK) {
			HRESULT hResult = ppf->Load(lpszLinkFile, STGM_READ);
			ppf->Release();
			if (hResult == S_OK) {
				// N擾
				WIN32_FIND_DATA st_find;
				psl->GetPath(lpszTargetFile, in_size, &st_find, SLGP_UNCPRIORITY);
				psl->Release();
				CoUninitialize();
				return TRUE;
			}
		}
		psl->Release();
	}
	CoUninitialize();
	return FALSE;
#endif
}
