// q2chwmGrepDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmGrepDialog.h"
#include "q2chwmConfig.h"

// Cq2chwmGrepDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmGrepDialog, CDialog)

Cq2chwmGrepDialog::Cq2chwmGrepDialog(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmGrepDialog::IDD, pParent)
{
	m_pDat = NULL;
	m_wchp_text = NULL;
	m_in_jump = 0;
}

Cq2chwmGrepDialog::~Cq2chwmGrepDialog()
{
	if (m_pDat != NULL) delete m_pDat;
}

void Cq2chwmGrepDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmGrepDialog, CDialog)
	ON_COMMAND(ID_MENU_CANCEL, &Cq2chwmGrepDialog::OnMenuCancel)
	ON_COMMAND(ID_MENU_COPY, &Cq2chwmGrepDialog::OnMenuCopy)
	ON_COMMAND(ID_MENU_JUMP, &Cq2chwmGrepDialog::OnMenuJump)
	ON_COMMAND(ID_MENU_COPY_ALL, &Cq2chwmGrepDialog::OnMenuCopyAll)
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_MENU_WRAP, &Cq2chwmGrepDialog::OnMenuWrap)
	ON_UPDATE_COMMAND_UI(ID_MENU_WRAP, &Cq2chwmGrepDialog::OnUpdateMenuWrap)
END_MESSAGE_MAP()


// Cq2chwmGrepDialog bZ[W nh

BOOL Cq2chwmGrepDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_pDat = new Cq2chwmDatCtrl(this, AfxGetMainWnd());
	m_pDat->SetFont(Cq2chwmConfig::GetInstance()->GetFontNameArticle(),
		Cq2chwmConfig::GetInstance()->GetFontSizeArticle(),
		Cq2chwmConfig::GetInstance()->GetFontBoldArticle());
	m_pDat->SetColorFore(Cq2chwmConfig::GetInstance()->GetColorFore());
	m_pDat->SetColorBack(Cq2chwmConfig::GetInstance()->GetColorBack());
	m_pDat->SetColorFrom(Cq2chwmConfig::GetInstance()->GetColorFrom());
	m_pDat->SetColorFromWithMail(Cq2chwmConfig::GetInstance()->GetColorFromWithMail());
	m_pDat->SetColorFromWithSage(Cq2chwmConfig::GetInstance()->GetColorFromWithSage());
	m_pDat->SetColorNew(Cq2chwmConfig::GetInstance()->GetColorDateNew());
	m_pDat->SetColorDate(Cq2chwmConfig::GetInstance()->GetColorDate());
	m_pDat->SetColorLink(Cq2chwmConfig::GetInstance()->GetColorLink());
	m_pDat->SetColorAbone(Cq2chwmConfig::GetInstance()->GetColorAbone());
	m_pDat->SetColorMessage(Cq2chwmConfig::GetInstance()->GetColorMessage());
	m_pDat->SetText(m_wchp_text);

	// IMEIt
	SipOff(m_hWnd);

	// TODO:  ɏǉĂ
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	if (!m_wndCommandBar.Create(this) ||
	    !m_wndCommandBar.InsertMenuBar(IDR_MENU_GREP) ||
	    !m_wndCommandBar.AddAdornments())
	{
		TRACE0("CommandBar ̍쐬Ɏs܂\n");
		return FALSE;
	}
	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() | CBRS_SIZE_FIXED);
#else
	m_cMenu.LoadMenu(IDR_MENU_GREP);
	SetMenu(&m_cMenu);
#endif // WIN32_PLATFORM_PSPC

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmGrepDialog::OnMenuCancel()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnCancel();
}

void Cq2chwmGrepDialog::OnMenuCopy()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_pDat->CopyMessage(m_pDat->GetCurrentMessageNumber());
}

void Cq2chwmGrepDialog::OnMenuJump()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_in_jump = m_pDat->GetCurrentMessageNumber();
	OnOK();
}

void Cq2chwmGrepDialog::OnMenuCopyAll()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_pDat->CopyMessageAll();
}

void Cq2chwmGrepDialog::SetText(
	const wchar_t *wchp_text)
{
	m_wchp_text = wchp_text;
}

void Cq2chwmGrepDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (m_pDat != NULL) {
		m_pDat->MoveWindow(0, 0, cx, cy);
	}
}

void Cq2chwmGrepDialog::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("Cq2chwmGrepDialog::OnKeyDown: %02x(%d)\n"), nChar, nChar);
	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL Cq2chwmGrepDialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (pMsg->message == WM_KEYDOWN) {
		TRACE(_T("Cq2chwmGrepDialog::PreTranslateMessage: WM_KEYDOWN(%d)\n"), pMsg->wParam);
		if (Cq2chwmConfig::GetInstance()->IsKeyPageUp(pMsg->wParam)) {
			if (m_pDat != NULL) m_pDat->SendMessage(WM_KEYDOWN, VK_PRIOR);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyPageDown(pMsg->wParam)) {
			if (m_pDat != NULL) m_pDat->SendMessage(WM_KEYDOWN, VK_NEXT);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyNext(pMsg->wParam)) {
			if (m_pDat != NULL) m_pDat->JumpNextMessage();
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyPrev(pMsg->wParam)) {
			if (m_pDat != NULL) m_pDat->JumpPrevMessage();
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyTop(pMsg->wParam)) {
			if (m_pDat != NULL) m_pDat->JumpFirstMessage();
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyBottom(pMsg->wParam)) {
			if (m_pDat != NULL) m_pDat->JumpLastMessage();
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyNextLine(pMsg->wParam)) {
			if (m_pDat != NULL) m_pDat->JumpNextLine(FALSE);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyPrevLine(pMsg->wParam)) {
			if (m_pDat != NULL) m_pDat->JumpPrevLine(FALSE);
			return TRUE;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void Cq2chwmGrepDialog::OnMenuWrap()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (m_pDat == NULL) return;
	m_pDat->SetWrap(!m_pDat->GetWrap());
}

void Cq2chwmGrepDialog::OnUpdateMenuWrap(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	if (m_pDat == NULL) return;
	pCmdUI->SetCheck(m_pDat->GetWrap());
}
