#pragma once

#include "YoString.h"

class Cq2chwmListItem
{
public:
	enum {
		STATE_NORMAL = 1,
		STATE_NETWORK = 2,
		STATE_BOOKMARK = 4,
		STATE_NEW = 8,
	};

private:
	BOOL m_bo_cache;
	BOOL m_bo_new;
	BOOL m_bo_search;
	BOOL m_bo_error;
	CYoString m_str_aname;
	CYoString m_str_aurl;
	CYoString m_str_aid;
	CYoString m_str_bname;
	CYoString m_str_burl;
	CYoString m_str_bid;
	CYoString m_str_filename;
	int m_in_index;

public:
	Cq2chwmListItem(int in_index, const char *chp_aname, const char *chp_aid, const char *chp_bname, const char *chp_bid, const char *chp_burl);
	virtual ~Cq2chwmListItem();

	void SetCache(BOOL bo_cache){ m_bo_cache = bo_cache; }
	void SetNew(BOOL bo_new){ m_bo_new = bo_new; }
	void SetSearch(BOOL bo_search){ m_bo_search = bo_search; }
	void SetError(BOOL bo_error){ m_bo_error = bo_error; }
	virtual BOOL GetCache(){ return m_bo_cache; }
	virtual BOOL GetNew(){ return m_bo_new; }
	virtual BOOL GetSearch(){ return m_bo_search; }
	virtual BOOL GetError(){ return m_bo_error; }
	virtual int GetState() = 0;
	virtual void SetIndex(int in_index){ m_in_index = in_index; }
	virtual void SetArticleName(const char *chp_aname){ m_str_aname = chp_aname; }
	virtual void SetBoardUrl(const char *chp_burl){ m_str_burl = chp_burl; }
	virtual int GetIndex(){ return m_in_index; }
	virtual const char *GetArticleName(){ return m_str_aname; }
	virtual const char *GetArticleUrl();
	virtual const char *GetArticleId(){ return m_str_aid; }
	virtual const char *GetBoardName(){ return m_str_bname; }
	virtual const char *GetBoardUrl(){ return m_str_burl; }
	virtual const char *GetBoardId(){ return m_str_bid; }
	virtual const char *GetFileName();
//	virtual BOOL GetItemText(int in_col, CString& cstr_text) = 0;
};
