// q2chwmPageMessage.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmConfig.h"
#include "q2chwmPageMessage.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmTemplateFile.h"

// Cq2chwmPageMessage _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageMessage, CDialog)

Cq2chwmPageMessage::Cq2chwmPageMessage(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageMessage::IDD, pParent)
	, m_cstr_template(_T(""))
{
	m_bo_update = FALSE;
}

Cq2chwmPageMessage::~Cq2chwmPageMessage()
{
}

void Cq2chwmPageMessage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_CBString(pDX, IDC_COMBO_TEMPLATE, m_cstr_template);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageMessage, Cq2chwmConfigPage)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_ADD, &Cq2chwmPageMessage::OnBnClickedButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_MOD, &Cq2chwmPageMessage::OnBnClickedButtonMod)
	ON_BN_CLICKED(IDC_BUTTON_DEL, &Cq2chwmPageMessage::OnBnClickedButtonDel)
	ON_BN_CLICKED(IDC_BUTTON_UP, &Cq2chwmPageMessage::OnBnClickedButtonUp)
	ON_BN_CLICKED(IDC_BUTTON_DOWN, &Cq2chwmPageMessage::OnBnClickedButtonDown)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, &Cq2chwmPageMessage::OnLvnItemchangedList)
END_MESSAGE_MAP()


// Cq2chwmPageMessage bZ[W nh

void Cq2chwmPageMessage::Write()
{
	// W^gp
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_USEDEFAULTTEMPLATE);
		Cq2chwmConfig::GetInstance()->SetUseDefaultTemplate(pButton->GetCheck());
	}

	// ftHgsage
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_SAGE);
		Cq2chwmConfig::GetInstance()->SetSage(pButton->GetCheck());
	}

	// ҏWXɃtH[JX
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_FOCUSONMESSAGE);
		Cq2chwmConfig::GetInstance()->SetFocusOnMessage(pButton->GetCheck());
	}

	// template.txt
	if (m_bo_update == TRUE) {
		Cq2chwmTemplateFile::GetInstance()->RemoveAll();
		CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
		for (int i = 0; i < pList->GetItemCount(); i++) {
			CYoString str_template = A(pList->GetItemText(i, 0));
			Cq2chwmTemplateFile::GetInstance()->AddTemplate(str_template);
		}
		Cq2chwmTemplateFile::GetInstance()->Write();
	}
}

void Cq2chwmPageMessage::OnSize(UINT nType, int cx, int cy)
{
	Cq2chwmConfigPage::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_USEDEFAULTTEMPLATE), 1, GetDlgItem(IDC_CHECK_SAGE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_FOCUSONMESSAGE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_TEMPLATE), 1, GetDlgItem(IDC_COMBO_TEMPLATE), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_BUTTON_ADD), 1, GetDlgItem(IDC_BUTTON_MOD), 1, GetDlgItem(IDC_BUTTON_DEL), 1,
			GetDlgItem(IDC_BUTTON_UP), 1, GetDlgItem(IDC_BUTTON_DOWN), 1),
		new Cq2chwmLayoutLine(3, GetDlgItem(IDC_LIST), 1)
	);
	cLayout.Layout(cx, cy);

	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	if (pList != NULL) {
		pList->SetColumnWidth(0, cx);
	}
}

BOOL Cq2chwmPageMessage::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	pList->SetExtendedStyle(LVS_EX_FULLROWSELECT);
	pList->InsertColumn(0, _T("^"));
	for (int i = 0; i < Cq2chwmTemplateFile::GetInstance()->Rows(); i++) {
		CString cstr_tmp;
		cstr_tmp = Cq2chwmTemplateFile::GetInstance()->GetTemplate(i);
		pList->InsertItem(i, cstr_tmp);
	}
	// ^R{{bNXɃZbg
	{
		CStringArray *pArray = ((Cq2chwmConfigDialog*)GetParent())->GetTextArray();
		CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_TEMPLATE);
		for (int i = 0; i < pArray->GetCount(); i++) {
			pCombo->AddString(pArray->GetAt(i));
		}
	}

	// W^gp
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_USEDEFAULTTEMPLATE);
		pButton->SetCheck(Cq2chwmConfig::GetInstance()->GetUseDefaultTemplate());
	}

	// ftHgsage
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_SAGE);
		pButton->SetCheck(Cq2chwmConfig::GetInstance()->GetSage());
	}

	// ҏWXɃtH[JX
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_FOCUSONMESSAGE);
		pButton->SetCheck(Cq2chwmConfig::GetInstance()->GetFocusOnMessage());
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL Cq2chwmPageMessage::checkDuplicate()
{
	UpdateData(TRUE);
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	for (int i = 0; i < pList->GetItemCount(); i++) {
		CString cstr_template = pList->GetItemText(i, 0);
		if (cstr_template == m_cstr_template) {
			return FALSE;
		}
	}
	return TRUE;
}

void Cq2chwmPageMessage::OnBnClickedButtonAdd()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	if (checkDuplicate() == FALSE) {
		::MessageBox(m_hWnd, _T("^o^Ă܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK);
		return;
	}
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	pList->InsertItem(0, m_cstr_template);
	m_bo_update = TRUE;
}

void Cq2chwmPageMessage::OnBnClickedButtonMod()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	if (checkDuplicate() == FALSE) {
		::MessageBox(m_hWnd, _T("^o^Ă܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK);
		return;
	}
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		pList->SetItemText(in_index, 0, m_cstr_template);
	}
	m_bo_update = TRUE;
}

void Cq2chwmPageMessage::OnBnClickedButtonDel()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		pList->DeleteItem(in_index);
	}
	m_bo_update = TRUE;
}

void Cq2chwmPageMessage::OnBnClickedButtonUp()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		if (in_index == 0) return;
		CString cstr_template = pList->GetItemText(in_index, 0);
		pList->SetItemText(in_index, 0, pList->GetItemText(in_index - 1, 0));
		pList->SetItemText(in_index - 1, 0, cstr_template);
		pList->SetItemState(in_index - 1, LVIS_SELECTED, LVIS_SELECTED);
	}
	m_bo_update = TRUE;
}

void Cq2chwmPageMessage::OnBnClickedButtonDown()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		if (in_index == pList->GetItemCount() - 1) return;
		CString cstr_template = pList->GetItemText(in_index, 0);
		pList->SetItemText(in_index, 0, pList->GetItemText(in_index + 1, 0));
		pList->SetItemText(in_index + 1, 0, cstr_template);
		pList->SetItemState(in_index + 1, LVIS_SELECTED, LVIS_SELECTED);
	}
	m_bo_update = TRUE;
}

void Cq2chwmPageMessage::OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		CString cstr_template = pList->GetItemText(in_index, 0);
		CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_TEMPLATE);
		pCombo->SetWindowText(cstr_template);
	}
	*pResult = 0;
}
