#include "stdafx.h"
#include "YoFile.h"
#include "q2chwmCommon.h"
#include "q2chwmConfig.h"
#include "q2chwmTemplateFile.h"

Cq2chwmTemplateFile::Cq2chwmTemplateFile()
{
}

Cq2chwmTemplateFile::~Cq2chwmTemplateFile()
{
}

Cq2chwmTemplateFile *Cq2chwmTemplateFile::m_pInstance = NULL;
Cq2chwmTemplateFile *Cq2chwmTemplateFile::GetInstance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new Cq2chwmTemplateFile();
		m_pInstance->Create();
		atexit(Cq2chwmTemplateFile::Delete);
	}

	return m_pInstance;
}

BOOL Cq2chwmTemplateFile::Create()
{
	// template.txt̃pXinit@C̃pXɐ
	CYoString str_filename = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	str_filename += "\\template.txt";

	CYoTextFile cFile(str_filename, CYoFile::READ);
	if (cFile.Open() == FALSE) {
		return FALSE;
	}

	RemoveAll();
	CYoString str_line;
	while (cFile.Eof() == FALSE) {
		cFile.ReadLine(str_line);
		char *chp_tmp = str_line;
		while (*(chp_tmp + strlen(chp_tmp) - 1) == '\r' ||
			*(chp_tmp + strlen(chp_tmp) - 1) == '\n')
		{
			*(chp_tmp + strlen(chp_tmp) - 1) = 0x00;
		}
		if (str_line.Length() > 0) Add((const char*)str_line, NULL);
	}
	cFile.Close();
	
	return TRUE;
}

void Cq2chwmTemplateFile::Delete()
{
	if (m_pInstance != NULL) {
		delete m_pInstance;
		m_pInstance = NULL;
	}
}

BOOL Cq2chwmTemplateFile::Write()
{
	CYoString str_filename = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	str_filename += "\\template.txt";

	CYoTextFile cFile(str_filename, CYoFile::WRITE);
	if (cFile.Open() == FALSE) {
		return FALSE;
	}

	for (int i = 0; i < Rows(); i++) {
		CYoString str_line;
		str_line.Format("%s\r\n", Get(i, 0));
		cFile.Write(str_line);
	}
	cFile.Close();
	return TRUE;
}
