#include "StdAfx.h"
#include "q2chwmMessage.h"

Cq2chwmMessage::Cq2chwmMessage(
	int in_type,
	const char *chp_aid,
	const char *chp_burl,
	const char *chp_filename)
{
	m_in_msg = WM_USER_CUSTOM;
	m_in_type = in_type;
	m_str_aid = chp_aid;
	m_str_burl = chp_burl;
	m_str_filename = chp_filename;
}

Cq2chwmMessage::~Cq2chwmMessage()
{
	//TRACE(_T("Cq2chwmMessage::~Cq2chwmMessage\n"));
}

Cq2chwmWriteFileMessage::Cq2chwmWriteFileMessage(
	const char *chp_id,
	const char *chp_url,
	const char *chp_file,
	const char *chp_data)
	: Cq2chwmMessage(TYPE_WRITEFILE, chp_id, chp_url, chp_file)
{
	m_str_data = chp_data;
}

Cq2chwmWriteFileMessage::~Cq2chwmWriteFileMessage()
{
	//TRACE(_T("Cq2chwmWriteFileMessage::~Cq2chwmWriteFileMessage\n"));
}

Cq2chwmReadUrlMessage::Cq2chwmReadUrlMessage(
	const char *chp_id,
	const char *chp_url,
	const char *chp_file,
	int in_recv,
	int in_recv_all)
	: Cq2chwmMessage(TYPE_READURL, chp_id, chp_url, chp_file)
{
	m_in_recv = in_recv;
	m_in_recv_all = in_recv_all;
}

Cq2chwmReadUrlMessage::~Cq2chwmReadUrlMessage()
{
	//TRACE(_T("Cq2chwmReadUrlMessage::~Cq2chwmReadUrlMessage\n"));
}

Cq2chwmOpenFileMessage::Cq2chwmOpenFileMessage(
	const char *chp_id,
	const char *chp_url,
	const char *chp_file,
	BOOL bo_create)
	: Cq2chwmMessage(TYPE_OPENFILE, chp_id, chp_url, chp_file)
{
	m_bo_create = bo_create;
}

Cq2chwmOpenFileMessage::~Cq2chwmOpenFileMessage()
{
	//TRACE(_T("Cq2chwmOpenFileMessage::~Cq2chwmOpenFileMessage\n"));
}

Cq2chwmCloseFileMessage::Cq2chwmCloseFileMessage(
	const char *chp_id,
	const char *chp_url,
	const char *chp_file,
	int in_write)
	: Cq2chwmMessage(TYPE_CLOSEFILE, chp_id, chp_url, chp_file)
{
	m_in_write = in_write;
}

Cq2chwmCloseFileMessage::~Cq2chwmCloseFileMessage()
{
	//TRACE(_T("Cq2chwmCloseFileMessage::~Cq2chwmCloseFileMessage\n"));
}

Cq2chwmReloadFileMessage::Cq2chwmReloadFileMessage(
	const char *chp_id,
	const char *chp_url,
	const char *chp_file)
	: Cq2chwmMessage(TYPE_RELOADFILE, chp_id, chp_url, chp_file)
{
}

Cq2chwmReloadFileMessage::~Cq2chwmReloadFileMessage()
{
	//TRACE(_T("Cq2chwmReloadFileMessage::~Cq2chwmReloadFileMessage\n"));
}

Cq2chwmCloseTabMessage::Cq2chwmCloseTabMessage(
	const char *chp_id,
	const char *chp_url,
	const char *chp_file)
	: Cq2chwmMessage(TYPE_CLOSETAB, chp_id, chp_url, chp_file)
{
}

Cq2chwmCloseTabMessage::~Cq2chwmCloseTabMessage()
{
	//TRACE(_T("Cq2chwmCloseTabMessage::~Cq2chwmCloseTabMessage\n"));
}
