// q2chwmCacheView.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmCacheImageView.h"
#include "q2chwmConfig.h"

// Cq2chwmCacheImageView

//IMPLEMENT_DYNCREATE(Cq2chwmCacheImageView, Cq2chwmListView)

Cq2chwmCacheImageView::Cq2chwmCacheImageView()
{
	m_bo_multiselect = FALSE;
	m_bo_create = FALSE;
}

Cq2chwmCacheImageView::~Cq2chwmCacheImageView()
{
}

BEGIN_MESSAGE_MAP(Cq2chwmCacheImageView, Cq2chwmListView)
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_DELETE, &Cq2chwmCacheImageView::OnDelete)
	ON_COMMAND(ID_SORT_ANAME, &Cq2chwmCacheImageView::OnSortAname)
	ON_UPDATE_COMMAND_UI(ID_SORT_ANAME, &Cq2chwmCacheImageView::OnUpdateSortAname)
	ON_COMMAND(ID_SORT_DATE, &Cq2chwmCacheImageView::OnSortDate)
	ON_UPDATE_COMMAND_UI(ID_SORT_DATE, &Cq2chwmCacheImageView::OnUpdateSortDate)
	ON_COMMAND(ID_SORT_INDEX, &Cq2chwmCacheImageView::OnSortIndex)
	ON_UPDATE_COMMAND_UI(ID_SORT_INDEX, &Cq2chwmCacheImageView::OnUpdateSortIndex)
	ON_COMMAND(ID_SORT_SEARCH, &Cq2chwmCacheImageView::OnSortSearch)
	ON_UPDATE_COMMAND_UI(ID_SORT_SEARCH, &Cq2chwmCacheImageView::OnUpdateSortSearch)
	ON_WM_SHOWWINDOW()
	ON_COMMAND(ID_ADJUST_COLUMN_WIDTH, &Cq2chwmCacheImageView::OnAdjustColumnWidth)
	ON_COMMAND(ID_MULTISELECT, &Cq2chwmCacheImageView::OnMultiSelect)
	ON_UPDATE_COMMAND_UI(ID_MULTISELECT, &Cq2chwmCacheImageView::OnUpdateMultiSelect)
END_MESSAGE_MAP()


// Cq2chwmCacheImageView ff

#ifdef _DEBUG
void Cq2chwmCacheImageView::AssertValid() const
{
	Cq2chwmListView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmCacheImageView::Dump(CDumpContext& dc) const
{
	Cq2chwmListView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmCacheImageView bZ[W nh
BOOL Cq2chwmCacheImageView::CreateList()
{
	if (m_bo_create == TRUE) return TRUE;
	// \[gԂۑ
	Cq2chwmConfig::GetInstance()->SetSortColumnCacheImage(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscCacheImage(GetSortAsc());

	m_cCacheFile.RemoveAll();
	m_cCacheFile.Create();
	GetListCtrl().SetItemCountEx(m_cCacheFile.Count());
	SortItems(Cq2chwmConfig::GetInstance()->GetSortColumnCacheImage(),
		Cq2chwmConfig::GetInstance()->GetSortAscCacheImage());
	GoTop();
	m_bo_create = TRUE;
	return TRUE;
}

void Cq2chwmCacheImageView::OnInitialUpdate()
{
	Cq2chwmListView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetListCtrl().InsertColumn(0, _T("No"));
	GetListCtrl().InsertColumn(1, _T("URL"));
	GetListCtrl().InsertColumn(2, _T("XV"));
	if (Cq2chwmConfig::GetInstance()->GetColumnWidthCacheImageCount() == 0) {
		GetListCtrl().SetColumnWidth(0, 50);
		GetListCtrl().SetColumnWidth(1, 300);
		GetListCtrl().SetColumnWidth(2, 100);
	} else {
		GetListCtrl().SetColumnWidth(0, Cq2chwmConfig::GetInstance()->GetColumnWidthCacheImage(0));
		GetListCtrl().SetColumnWidth(1, Cq2chwmConfig::GetInstance()->GetColumnWidthCacheImage(1));
		GetListCtrl().SetColumnWidth(2, Cq2chwmConfig::GetInstance()->GetColumnWidthCacheImage(2));
	}
	SetFont();
	SetSortColumn(Cq2chwmConfig::GetInstance()->GetSortColumnCacheImage());
	SetSortAsc(Cq2chwmConfig::GetInstance()->GetSortAscCacheImage());
}

void Cq2chwmCacheImageView::SetFont()
{
	Cq2chwmListView::SetFont(Cq2chwmConfig::GetInstance()->GetFontNameCache(),
		Cq2chwmConfig::GetInstance()->GetFontSizeCache(), Cq2chwmConfig::GetInstance()->GetFontBoldCache());
}

void Cq2chwmCacheImageView::OnDestroy()
{
	CYoPtrArray cArray;
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(0));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(1));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(2));
	Cq2chwmConfig::GetInstance()->SetColumnWidthCacheImage(cArray);
	Cq2chwmConfig::GetInstance()->SetSortColumnCacheImage(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscCacheImage(GetSortAsc());
	m_cCacheFile.RemoveAll();
	Cq2chwmListView::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
}

void Cq2chwmCacheImageView::OnListClicked()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return;
	Cq2chwmCacheImageItem *pItem = m_cCacheFile.GetItem((int)pos - 1);
	if (pItem == NULL) return;

	if (m_bo_multiselect == TRUE) {
		pItem->SetSelected(!pItem->GetSelected());
		RECT rect;
		GetListCtrl().GetItemRect((int)pos - 1, &rect, LVIR_BOUNDS);
		InvalidateRect(&rect, FALSE);
	} else {
		AfxGetMainWnd()->SendMessage(WM_USER_CACHEIMAGECLICKED, 0, (LPARAM)pItem);
	}
}

void Cq2chwmCacheImageView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (Cq2chwmConfig::GetInstance()->IsKeyDelete(nChar)) {
		Delete();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeySort(nChar)) {
		Sort();
		return;
	}

	Cq2chwmListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void Cq2chwmCacheImageView::Delete()
{
	if (m_bo_multiselect == TRUE) {
		// I[h͊Sɏ𕪂
		if (::MessageBox(m_hWnd, _T("IACeSč폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
			AfxGetApp()->DoWaitCursor(1);
			for (int i = 0; i < m_cCacheFile.Count(); i++) {
				Cq2chwmCacheImageItem *pItem = m_cCacheFile.GetItem(i);
				int in_state = pItem->GetState();
				if (in_state & Cq2chwmListItem::STATE_SELECTED) {
					RemoveFile(pItem->GetFileName());
					m_cCacheFile.RemoveItem(i);
					i--;
				}
			}
			GetListCtrl().SetItemCountEx(m_cCacheFile.Count());
			InvalidateRect(NULL);
			UpdateWindow();
			AfxGetApp()->DoWaitCursor(-1);
		}
	} else {
		POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
		if ((int)pos == -1) return;
		Cq2chwmCacheImageItem *pItem = m_cCacheFile.GetItem((int)pos - 1);
		if (pItem == NULL) return;
		if (::MessageBox(m_hWnd, _T("폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
			RemoveFile(pItem->GetFileName());
			m_cCacheFile.RemoveItem((int)pos - 1);
			GetListCtrl().SetItemCountEx(m_cCacheFile.Count());
			InvalidateRect(NULL);
			UpdateWindow();
		}
	}
}

void Cq2chwmCacheImageView::OnDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Delete();
}

void Cq2chwmCacheImageView::Sort()
{
	int in_col = GetSortColumn();
	if (in_col == Cq2chwmCacheImageFile::IDX_SEARCH) {
		in_col = Cq2chwmCacheImageFile::IDX_INDEX;
	} else {
		in_col++;
	}
	SortItems(in_col, TRUE);
}

void Cq2chwmCacheImageView::SortItems(
	int in_col,
	BOOL bo_asc)
{
	// \[gsƂ^Cgo[ς
	/*
	CString cstr_title = _T("LbV");
	switch (in_col) {
	case Cq2chwmCacheFile::IDX_INDEX:
		cstr_title += _T("[No]");
		break;
	case Cq2chwmCacheFile::IDX_ANAME:
		cstr_title += _T("[Xbh]");
		break;
	case Cq2chwmCacheFile::IDX_BNAME:
		cstr_title += _T("[]");
		break;
	case Cq2chwmCacheFile::IDX_DATE:
		cstr_title += _T("[XV]");
		break;
	case Cq2chwmCacheFile::IDX_SEARCH:
		cstr_title += _T("[]");
		break;
	};
	AfxGetMainWnd()->SetWindowText(cstr_title);
	*/

	m_cCacheFile.Sort(in_col, bo_asc);
	if (IsWindowVisible() == TRUE) RedrawWindow();
	SetSortColumn(in_col);
	SetSortAsc(bo_asc);
}

void Cq2chwmCacheImageView::Search(
	const char *chp_word)
{
	BOOL bo_ret = FALSE;
	CYoRegex cRegex(chp_word, CYoRegex::SJIS, TRUE);
	for (int i = 0; i < m_cCacheFile.Count(); i++) {
		Cq2chwmCacheImageItem *pItem = m_cCacheFile.GetItem(i);
		if (cRegex.Match(pItem->GetName()) >= 0) {
			pItem->SetSearch(TRUE);
			bo_ret = TRUE;
		} else {
			pItem->SetSearch(FALSE);
		}
	}

	// }b`ꍇ̂݁A[]Ń\[g&ֈړ
	if (bo_ret == TRUE) {
		SortItems(Cq2chwmCacheImageFile::IDX_SEARCH, TRUE);
		GoTop();
	}
}

BOOL Cq2chwmCacheImageView::GetItemText(
	LPTSTR wchp_text,
	int in_size,
	int in_row,
	int in_col)
{
	Cq2chwmCacheImageItem *pItem = m_cCacheFile.GetItem(in_row);
	if (pItem == NULL) return FALSE;
	CString cstr_tmp;
	switch (in_col) {
	case Cq2chwmCacheImageFile::IDX_INDEX:
		cstr_tmp.Format(_T("%d"), pItem->GetIndex());
		break;
	case Cq2chwmCacheImageFile::IDX_NAME:
		cstr_tmp = pItem->GetName();
		break;
	case Cq2chwmCacheImageFile::IDX_DATE:
		cstr_tmp = pItem->GetDate();
		break;
	};
	_tcscpy_s(wchp_text, in_size, cstr_tmp);
	return TRUE;
}

Cq2chwmListItem *Cq2chwmCacheImageView::GetSelectedItem()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return NULL;
	return m_cCacheFile.GetItem((int)pos - 1);
}

Cq2chwmListItem *Cq2chwmCacheImageView::GetItem(
	int iRow)
{
	return m_cCacheFile.GetItem(iRow);
}

void Cq2chwmCacheImageView::OnSortAname()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmCacheImageFile::IDX_NAME, TRUE);
}

void Cq2chwmCacheImageView::OnUpdateSortAname(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmCacheImageFile::IDX_NAME);
}

void Cq2chwmCacheImageView::OnSortDate()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmCacheImageFile::IDX_DATE, FALSE);
}

void Cq2chwmCacheImageView::OnUpdateSortDate(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmCacheImageFile::IDX_DATE);
}

void Cq2chwmCacheImageView::OnSortIndex()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmCacheImageFile::IDX_INDEX, TRUE);
}

void Cq2chwmCacheImageView::OnUpdateSortIndex(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmCacheImageFile::IDX_INDEX);
}

void Cq2chwmCacheImageView::OnSortSearch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmCacheImageFile::IDX_SEARCH, TRUE);
}

void Cq2chwmCacheImageView::OnUpdateSortSearch(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmCacheImageFile::IDX_SEARCH);
}

void Cq2chwmCacheImageView::OnAdjustColumnWidth()
{
	// TODO: ɃR}h nh R[hǉ܂B
	for (int i = 0; i < GetListCtrl().GetHeaderCtrl()->GetItemCount(); i++) {
		GetListCtrl().SetColumnWidth(i, LVSCW_AUTOSIZE);
	}
	// Xbh1/2
	GetListCtrl().SetColumnWidth(1, GetListCtrl().GetColumnWidth(1) / 2);
}

void Cq2chwmCacheImageView::OnMultiSelect()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (m_bo_multiselect == FALSE) {
		m_bo_multiselect = TRUE;
	} else {
		m_bo_multiselect = FALSE;
		// SẴACeSTATE_SELECTED
		for (int i = 0; i < m_cCacheFile.Count(); i++) {
			Cq2chwmCacheImageItem *pItem = m_cCacheFile.GetItem(i);
			pItem->SetSelected(FALSE);
		}
		InvalidateRect(NULL);
		UpdateWindow();
	}
}

void Cq2chwmCacheImageView::OnUpdateMultiSelect(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(m_bo_multiselect);
}

BOOL Cq2chwmCacheImageView::AddItem(
	const char *chp_filename)
{
	for (int i = 0; i < m_cCacheFile.Count(); i++) {
		Cq2chwmCacheImageItem *pItem = m_cCacheFile.GetItem(i);
		if (strcmp(chp_filename, pItem->GetFileName()) == 0) {
			return FALSE;
		}
	}
	if (m_cCacheFile.AddItem(chp_filename) == FALSE) {
		return FALSE;
	}
	GetListCtrl().SetItemCountEx(m_cCacheFile.Count());
	InvalidateRect(NULL);
	UpdateWindow();
	return TRUE;
}

BOOL Cq2chwmCacheImageView::UpdateItem(
	const char *chp_filename)
{
	if (chp_filename == NULL) return FALSE;
	int in_find = m_cCacheFile.SearchItem(chp_filename);
	if (in_find >= 0) {
		m_cCacheFile.UpdateItem(in_find);
	} else {
		m_cCacheFile.AddItem(chp_filename);
	}

	// UpdateItemō폜ꂽ\邽߃JEgăZbg
	GetListCtrl().SetItemCountEx(m_cCacheFile.Count());

	// XV\[gԂȂă\[g
	if (GetSortColumn() == Cq2chwmCacheImageFile::IDX_DATE) {
		SortItems(Cq2chwmCacheImageFile::IDX_DATE, FALSE);
	}

	return TRUE;
}

void Cq2chwmCacheImageView::CopyInformation()
{
	// Rs[񐶐
	Cq2chwmCacheImageItem *pItem = (Cq2chwmCacheImageItem*)GetSelectedItem();
	if (pItem == NULL) return;

	CString cstr_text;
	cstr_text = (const char*)pItem->GetUrl();
	StringToClipboard(cstr_text);
}

BOOL Cq2chwmCacheImageView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	cs.style &= ~WS_BORDER;
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	return Cq2chwmListView::PreCreateWindow(cs);
}
