// q2chwmImageView.cpp : t@C
//

#include "stdafx.h"
#include "YoHttpClient.h"
#include "MainFrm.h"
#include "q2chwmCommon.h"
#include "q2chwmBoardFile.h"
#include "q2chwmConfig.h"
#include "q2chwmImageView.h"
#ifdef _WIN32_WCE
#include <initguid.h>
#include <imgguids.h>
#endif

#define SETERRORMESSAGE(fmt, ...) setErrorMessage(__FUNCTION__, __LINE__, ::GetLastError(), fmt, __VA_ARGS__)

// Cq2chwmImageView

IMPLEMENT_DYNCREATE(Cq2chwmImageView, CScrollView)

Cq2chwmImageView::Cq2chwmImageView()
{
	m_hBitmap = NULL;
#ifdef _WIN32_WCE
#else
	m_pImage = NULL;
#endif
	m_bo_running = FALSE;
	m_bo_fit = TRUE;
}

Cq2chwmImageView::~Cq2chwmImageView()
{
	if (m_hBitmap != NULL) ::DeleteObject(m_hBitmap);
#ifdef _WIN32_WCE
#else
	if(m_pImage != NULL) delete m_pImage;
#endif
}


BEGIN_MESSAGE_MAP(Cq2chwmImageView, CScrollView)
	ON_WM_KEYDOWN()
	ON_WM_SIZE()
	ON_COMMAND(ID_RELOAD, &Cq2chwmImageView::OnReload)
	ON_COMMAND(ID_DELETE, &Cq2chwmImageView::OnDelete)
	ON_UPDATE_COMMAND_UI(ID_DELETE, &Cq2chwmImageView::OnUpdateDelete)
END_MESSAGE_MAP()


// Cq2chwmImageView `

void Cq2chwmImageView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	// TODO: ̃r[̃TCY̍vvZ܂B
	// IMEIt
	SipOff(m_hWnd);
}

void Cq2chwmImageView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB
	RECT rcView;
	GetClientRect(&rcView);
	if (m_hBitmap != NULL) {
		// DC쐬
		CDC cMemoryDC;
		cMemoryDC.CreateCompatibleDC(pDC);
		HGDIOBJ hOldBitmap = cMemoryDC.SelectObject(m_hBitmap);
		if (m_bo_fit == TRUE) {
			CRect cAdjustRect = getAdjustRect(m_sizeImage, CSize(rcView.right - rcView.left, rcView.bottom - rcView.top));
			::SetStretchBltMode(pDC->GetSafeHdc(), COLORONCOLOR);
			pDC->StretchBlt(cAdjustRect.left, cAdjustRect.top, cAdjustRect.right, cAdjustRect.bottom, &cMemoryDC, 0, 0, m_sizeImage.cx, m_sizeImage.cy, SRCCOPY);
		} else {
			int hx = 0;
			int hy = 0;
			CSize sizeView = getViewSize();
			if (sizeView.cx > m_sizeImage.cx) hx = (sizeView.cx - m_sizeImage.cx) / 2;
			if (sizeView.cy > m_sizeImage.cy) hy = (sizeView.cy - m_sizeImage.cy) / 2;
#ifdef _WIN32_WCE
			CPoint pt = GetScrollPosition();
			pDC->BitBlt(hx, hy, m_sizeImage.cx, m_sizeImage.cy, &cMemoryDC, pt.x, pt.y, SRCCOPY);
#else
			pDC->BitBlt(hx, hy, m_sizeImage.cx, m_sizeImage.cy, &cMemoryDC, 0, 0, SRCCOPY);
#endif
		}
		cMemoryDC.SelectObject(hOldBitmap);
		cMemoryDC.DeleteDC();
	}

	if (m_cstr_error.GetLength() > 0) {
		pDC->DrawText(m_cstr_error, -1, &rcView, DT_LEFT | DT_WORDBREAK | DT_NOPREFIX | DT_NOCLIP);
	}
}


// Cq2chwmImageView ff

#ifdef _DEBUG
void Cq2chwmImageView::AssertValid() const
{
	CScrollView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmImageView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif
#endif //_DEBUG

BOOL Cq2chwmImageView::SetUrl(
	const char *chp_url,
	BOOL bo_force)
{
	if (m_bo_running == TRUE) {
		return FALSE;
	}
	if (m_hBitmap != NULL) {
		::DeleteObject(m_hBitmap);
		m_hBitmap = NULL;
	}
	m_cstr_error = "";
	m_bo_running = TRUE;
	m_str_url = chp_url;
	m_str_filename = UrlToImagePath(chp_url);
	int in_ret = ERR_NONE;
	if(ExistFile(m_str_filename) == FALSE || bo_force == TRUE){
		if (bo_force == TRUE || Cq2chwmConfig::GetInstance()->GetOnline() == TRUE ||
			::MessageBox(m_hWnd, _T("t@C݂܂BT[o擾܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES)
		{
			AfxGetMainWnd()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)TRUE);
			in_ret = httpGet(chp_url);
			AfxGetMainWnd()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);
		} else {
			goto error;
		}
	}

	if (in_ret != ERR_NONE) {
		m_sizeImage.cx = 0;
		m_sizeImage.cy = 0;
		setSize();
		if (m_cstr_error.GetLength() == 0) {
			ErrorMessageBox(in_ret);
			goto error;
		}
	} else {
		CString cstr_filename;
		cstr_filename = m_str_filename;

#ifdef _WIN32_WCE
		IImage *pImage = NULL;
		IImagingFactory *pImageFactory = NULL;
		::CoInitializeEx(NULL, COINIT_MULTITHREADED);

		// IImagingFactory쐬
		HRESULT hr;
		hr = CoCreateInstance(CLSID_ImagingFactory, NULL, CLSCTX_INPROC_SERVER, IID_IImagingFactory, (void **)&pImageFactory);
		if (hr == S_OK) {
			// IImage쐬
			hr = pImageFactory->CreateImageFromFile(cstr_filename, &pImage);
			if (hr == S_OK) {
				// 摜TCY擾
				ImageInfo info;
				if (pImage->GetImageInfo(&info) == S_OK) {
					// rbg}bv쐬
					CWindowDC dc(this);
					m_hBitmap = ::CreateCompatibleBitmap(dc.GetSafeHdc(), info.Width, info.Height);
					if (m_hBitmap == NULL) {
						// 摜傫ăG[Ȃr[ƓTCỸTlC摜̕\
						MessageBox(_T("摜TCY傫邽ߏk܂(CreateCompatibleBitmap)"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);

						// N㏉߂Ẳ摜\ł͎g̃TCYȂ̂ŐeEBhEr[TCY擾
						RECT rcView;
						GetParent()->GetClientRect(&rcView);

						// r[TCYɏkꂽ摜TCYvZ
						CRect cRect = getAdjustRect(CSize(info.Width, info.Height), CSize(rcView.right - rcView.left, rcView.bottom - rcView.top));

						// TlC摜쐬
						IImage *pThumbImage = NULL;
						hr = pImage->GetThumbnail(cRect.Width(), cRect.Height(), &pThumbImage);
						if (hr != S_OK) {
							SETERRORMESSAGE(_T("IImage::GetThumbnail error: %d(%d)"), hr, ::GetLastError());
						} else {
							info.Width = cRect.Width();
							info.Height = cRect.Height();
							m_hBitmap = ::CreateCompatibleBitmap(dc.GetSafeHdc(), info.Width, info.Height);
							pImage->Release();
							pImage = pThumbImage;
						}
					}

					// `
					if (m_hBitmap != NULL) {
						CDC cMemoryDC;
						cMemoryDC.CreateCompatibleDC(&dc);
						HGDIOBJ hOldBitmap = cMemoryDC.SelectObject(m_hBitmap);
						hr = pImage->Draw(cMemoryDC.GetSafeHdc(), CRect(0, 0, info.Width, info.Height), NULL);
						if (hr == S_OK) {
							m_sizeImage.cx = info.Width;
							m_sizeImage.cy = info.Height;
						} else {
							// 摜傫ăG[Ȃr[ƓTCỸTlC摜̕\
							// ̏ƂقƂǓB܂킩Ȃ̂łB
							MessageBox(_T("摜TCY傫邽ߏk܂(IImage::Draw)"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);

							// N㏉߂Ẳ摜\ł͎g̃TCYȂ̂ŐeEBhEr[TCY擾
							RECT rcView;
							GetParent()->GetClientRect(&rcView);

							// r[TCYɏkꂽ摜TCYvZ
							CRect cRect = getAdjustRect(CSize(info.Width, info.Height), CSize(rcView.right - rcView.left, rcView.bottom - rcView.top));

							// TlC摜쐬
							IImage *pThumbImage = NULL;
							hr = pImage->GetThumbnail(cRect.Width(), cRect.Height(), &pThumbImage);
							if (hr != S_OK) {
								SETERRORMESSAGE(_T("IImage::GetThumbnail error: %d(%d)"), hr, ::GetLastError());
								::DeleteObject(m_hBitmap);
								m_hBitmap = NULL;
								m_sizeImage.cx = 0;
								m_sizeImage.cy = 0;
							} else {
								cMemoryDC.SelectObject(hOldBitmap);
								::DeleteObject(m_hBitmap);
								m_hBitmap = ::CreateCompatibleBitmap(dc.GetSafeHdc(), cRect.Width(), cRect.Height());
								pImage->Release();
								hOldBitmap = cMemoryDC.SelectObject(m_hBitmap);
								hr = pThumbImage->Draw(cMemoryDC.GetSafeHdc(), CRect(0, 0, cRect.Width(), cRect.Height()), NULL);
								if (hr != S_OK) {
									SETERRORMESSAGE(_T("IImage::Draw error: %d(%d)"), hr, ::GetLastError());
									::DeleteObject(m_hBitmap);
									m_hBitmap = NULL;
									m_sizeImage.cx = 0;
									m_sizeImage.cy = 0;
									pThumbImage->Release();
								} else {
									m_sizeImage.cx = cRect.Width();
									m_sizeImage.cy = cRect.Height();
									pThumbImage->Release();
								}
							}
						}
						cMemoryDC.SelectObject(hOldBitmap);
						cMemoryDC.DeleteDC();
					} else {
						SETERRORMESSAGE(_T("CreateCompatibleBitmap error: NULL(%d)"), ::GetLastError());
						m_sizeImage.cx = 0;
						m_sizeImage.cy = 0;
					}
				} else {
					// G[
					SETERRORMESSAGE(_T("GetImageInfo error: %d(%d)"), hr, ::GetLastError());
					m_sizeImage.cx = 0;
					m_sizeImage.cy = 0;
				}
				pImage->Release();
			} else {
				// G[
				SETERRORMESSAGE(_T("CreateImageFromFile error: %d(%d)"), hr, ::GetLastError());
				RemoveFile(m_str_filename);
			}
			pImageFactory->Release();
		} else {
			// G[
			SETERRORMESSAGE(_T("CoCreateInstance error: %d(%d)"), hr, ::GetLastError());
		}
		::CoUninitialize();
#else
		if (m_pImage != NULL) delete m_pImage;
		m_pImage = new CImage();
		if (m_pImage->Load(cstr_filename) != S_OK) {
			m_sizeImage.cx = 0;
			m_sizeImage.cy = 0;
			SETERRORMESSAGE(_T("CImage::Load error: (%d)"), ::GetLastError());
			RemoveFile(m_str_filename);
		} else {
			m_sizeImage.cx = m_pImage->GetWidth();
			m_sizeImage.cy = m_pImage->GetHeight();
		}
		m_hBitmap = *m_pImage;
#endif
		setSize();

		// ǂ݂݂Ɏs摜t@C폜
		if (m_hBitmap == NULL) {
			RemoveFile(m_str_filename);
		}
	}
	m_bo_running = FALSE;
	return TRUE;

error:
	m_bo_running = FALSE;
	return FALSE;
}

int Cq2chwmImageView::httpGet(
	const char *chp_url)
{
	CYoHttpClient cHttp(chp_url);
	cHttp.SetUserAgent(Cq2chwmConfig::GetInstance()->GetUserAgent());
	if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
		cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
		cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
	}
	cHttp.SetCallbackProc(CMainFrame::CallbackProc, AfxGetMainWnd());

	if (cHttp.Connect(TIMEOUT) == FALSE) {
		return ERR_HTTP_CONNECT;
	}

	if (cHttp.Get() == FALSE) {
		return ERR_HTTP_GET;
	}

	if (cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300) {
		CYoString str_header = cHttp.GetResponseHeader();
		str_header.Remove(str_header.Find("\r\n"));
		m_cstr_error = W(str_header);
		return ERR_HTTP_GET;
	}

	// bbsmenu.html̂܂board.txt.tmpɏ
	CString cstr_filename;
	CYoString str_filename = UrlToImagePath(chp_url);
	cstr_filename = str_filename;

	{
		// fBNg쐬
		CYoString str_dir = GetBaseName(str_filename);
		MakeDirectory(str_dir);

		CFile cFileTmp;
		if (cFileTmp.Open(cstr_filename, CFile::modeCreate|CFile::modeWrite) == FALSE) {
			return ERR_FILE_OPEN;
		}

		CYoString str_length = cHttp.GetResponseHeader("Content-Length");
		int in_length = str_length.Atoi();
		int in_recv = 0;

		char cha_buff[RECV_BUFF];
		int in_ret;
		while ((in_ret = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0) {
			cFileTmp.Write(cha_buff, in_ret);
			in_recv += in_ret;
			AfxGetMainWnd()->SendMessage(WM_USER_SETPROGRESS, cHttp.GetRecvSize(), in_length);
		}
		cFileTmp.Close();
		if (in_ret == 0 && ((CMainFrame*)AfxGetMainWnd())->Canceled() == TRUE) {
			RemoveFile(str_filename);
			return ERR_CANCELED;
		}
		if( in_ret == SOCKET_ERROR ){
			RemoveFile(str_filename);
			return ERR_HTTP_RECV;
		}
	}

	return ERR_NONE;
}

// Cq2chwmImageView bZ[W nh
void Cq2chwmImageView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("Cq2chwmImageView::OnKeyDown: %02x(%d)\n"), nChar, nChar);
	if (Cq2chwmConfig::GetInstance()->IsKeyViewBack(nChar)) {
		GetParent()->SendMessage(WM_USER_VIEWBACK, 0, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyReload(nChar)) {
		OnReload();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyDelete(nChar)) {
		OnDelete();
		return;
	} else if (nChar == VK_RETURN) {
		m_bo_fit = !m_bo_fit;
		setSize();
		Invalidate();
		return;
	} else if(nChar == VK_LEFT ||
		nChar == VK_RIGHT ||
		nChar == VK_UP ||
		nChar == VK_DOWN)
	{
		PRINTLOG("Cq2chwmImageView::OnKeyDown: %02x(%d)",nChar,nChar);
		if (m_bo_fit == TRUE) {
			return;
		}

		CSize sizeView = getViewSize();
		CPoint pt = GetScrollPosition();
		if (nChar == VK_LEFT) {
			if (m_sizeImage.cx <= sizeView.cx) return;
			pt.x -= sizeView.cx / 5;
			if (pt.x < 0) pt.x = 0;
		} else if (nChar == VK_UP) {
			if (m_sizeImage.cy <= sizeView.cy) return;
			pt.y -= sizeView.cy / 5;
			if (pt.y < 0) pt.y = 0;
		} else if (nChar == VK_RIGHT) {
			if (m_sizeImage.cx <= sizeView.cx) return;
			pt.x += sizeView.cx / 5;
			if (pt.x > m_sizeImage.cx - sizeView.cx) pt.x = m_sizeImage.cx - sizeView.cx;
		} else if (nChar == VK_DOWN) {
			if (m_sizeImage.cy <= sizeView.cy) return;
			pt.y += sizeView.cy / 5;
			if (pt.y > m_sizeImage.cy - sizeView.cy) pt.y = m_sizeImage.cy - sizeView.cy;
		}
		ScrollToPosition(pt);
		return;
	}

	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void Cq2chwmImageView::OnReload()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SetUrl(m_str_url, TRUE);
}

BOOL Cq2chwmImageView::setSize()
{
	if (m_bo_fit == TRUE) {
		// RecTCY = r[TCY
		CSize sizeView = getViewSize();
		SetScrollSizes(MM_TEXT, sizeView);
	} else {
		// RecTCY = 摜TCY
		SetScrollSizes(MM_TEXT, m_sizeImage);
	}
	return TRUE;
}

CRect Cq2chwmImageView::getAdjustRect(
	const CSize sizeImage,		// 摜IWiTCY
	const CSize sizeHint)		// qgTCY(̃TCY̒Ɏ܂CRectԂ)
{
	double w1 = sizeHint.cx;
	double h1 = sizeHint.cy;
	double w2 = sizeImage.cx;
	double h2 = sizeImage.cy;
	double ww = w1 / w2;
	double hh = h1 / h2;
	int x = 0;
	int y = 0;
	if (ww < hh) {
		x = (int)(w2 * ww);
		y = (int)(h2 * ww);
	} else {
		x = (int)(w2 * hh);
		y = (int)(h2 * hh);
	}
	int hx = (int)((w1 - x) / 2);
	int hy = (int)((h1 - y) / 2);
	return CRect(hx, hy, x, y);
}

void Cq2chwmImageView::setErrorMessage(
	const char *chp_func,
	DWORD dwLine,
	DWORD dwError,
	LPCTSTR lpszFormat, ...)
{
	va_list va_argp;
	va_start(va_argp, lpszFormat);
	CString strMessage;
	strMessage.FormatV(lpszFormat, va_argp);
	va_end(va_argp);

    LPTSTR lpBuffer;
    FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM, NULL, dwError,
        LANG_USER_DEFAULT, (LPTSTR)&lpBuffer, 0, NULL);
	m_cstr_error = lpBuffer;
	m_cstr_error += strMessage;
    LocalFree(lpBuffer);
}

CSize Cq2chwmImageView::getViewSize()
{
	RECT rcView;
	GetClientRect(&rcView);
	return CSize(rcView.right - rcView.left, rcView.bottom - rcView.top);
}

void Cq2chwmImageView::OnDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (::MessageBox(m_hWnd, _T("폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		if (m_hBitmap != NULL) {
			::DeleteObject(m_hBitmap);
			m_hBitmap = NULL;
		}
		RemoveFile(m_str_filename);
		GetParent()->SendMessage(WM_USER_VIEWBACK, 0, 0);
		GetParent()->SendMessage(WM_USER_DELETEIMAGEFILE, 0, (LPARAM)(const char*)m_str_filename);
	}
}

void Cq2chwmImageView::OnUpdateDelete(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_hBitmap != NULL);
}
