#include "StdAfx.h"
#include "YoRegex.h"
#include "q2chwm.h"
#include "q2chwmBoardView.h"
#include "q2chwmDatFile.h"
#include "q2chwmCacheFile.h"
#include "q2chwmConfig.h"
#include "q2chwmCommon.h"

Cq2chwmCacheFile::Cq2chwmCacheFile(void)
{
}

Cq2chwmCacheFile::~Cq2chwmCacheFile(void)
{
}

void Cq2chwmCacheFile::RemoveAll()
{
	for (int i = 0; i < Count(); i++) {
		Cq2chwmCacheItem *pItem = (Cq2chwmCacheItem*)Get(i);
		delete pItem;
	}
	CYoPtrArray::RemoveAll();
}

int Cq2chwmCacheFile::Create()
{
	int in_index = 1;
	readDirectory(Cq2chwmConfig::GetInstance()->GetRootDirectory(), in_index);
	return TRUE;
}

BOOL Cq2chwmCacheFile::readDirectory(
	const char *chp_dir,
	int& in_index)
{
	CString cstr_find;		// \MyDocuments\.navi2ch\*.*
	WIN32_FIND_DATA st_find;
	FILETIME st_filetime;
	SYSTEMTIME st_systemtime;
	HANDLE hFind;

	cstr_find = chp_dir;
	cstr_find += "\\*.*";
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		// t@CȂ
		return FALSE;
	}

	do {
		if (wcscmp(st_find.cFileName, _T(".")) == 0 || wcscmp(st_find.cFileName, _T("..")) == 0) continue;
		if (st_find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
//			TRACE(_T("fBNg: %s\n"), st_find.cFileName);
			CYoString str_dir = chp_dir;
			str_dir += "\\";
			str_dir += A(st_find.cFileName);
			readDirectory(str_dir, in_index);
		} else if (wcscmp(st_find.cFileName + wcslen(st_find.cFileName) - 4, _T(".dat")) == 0) {
			// XVԎ擾
			FileTimeToLocalFileTime(&st_find.ftLastWriteTime, &st_filetime);
			FileTimeToSystemTime(&st_filetime, &st_systemtime);

			CString cstr_filename;
			cstr_filename = chp_dir;
			cstr_filename += _T("\\");
			cstr_filename += st_find.cFileName;

			CString cstr_date;
			cstr_date.Format(_T("%04d/%02d/%02d %02d:%02d:%02d"),
				st_systemtime.wYear, st_systemtime.wMonth, st_systemtime.wDay, st_systemtime.wHour, st_systemtime.wMinute, st_systemtime.wSecond);

			CYoString str_filename = A(cstr_filename);
			CYoString str_date = A(cstr_date);
			if (addItem(in_index, str_filename, str_date) == TRUE) in_index++;
//			TRACE(_T("t@C: %s"), cstr_filename/*st_find.cFileName*/);
//			TRACE(_T("\nZt@C: %s\n"), st_find.cAlternateFileName);
//			TRACE(_T("(%dbytes) "), st_find.nFileSizeLow);
//			TRACE(_T("%04d/%02d/%02d %02d:%02d:%02d\n"),
//				st_systemtime.wYear, st_systemtime.wMonth, st_systemtime.wDay, st_systemtime.wHour, st_systemtime.wMinute, st_systemtime.wSecond);
		}
	} while (FindNextFile(hFind, &st_find));
	::FindClose(hFind);

	return ERR_NONE;
}

BOOL Cq2chwmCacheFile::addItem(
	int in_index,
	const char *chp_filename,
	const char *chp_date)
{
	// `FbN
	CYoRegex cRegex("^\\\\(.+\\\\(.+)\\\\)([0-9]+)\\.dat$");
	if (cRegex.Match(chp_filename + strlen(Cq2chwmConfig::GetInstance()->GetRootDirectory())) < 0) {
		return FALSE;
	}

	// Xbh
	CYoString str_aname;
	if (Cq2chwmDatFile::GetName(str_aname, chp_filename) == FALSE) {
		return FALSE;
	}

	// XbhID
	CYoString str_aid = cRegex.Get(3);

	// URL
	CYoString str_tmp = cRegex.Get(1);
	str_tmp.Replace("\\", "/");
	CYoString str_burl = "http://";
	str_burl += str_tmp;

	// AID
	CYoString str_bname;
	CYoString str_bid = cRegex.Get(2);
	Cq2chwmBoardView *pView = ((Cq2chwmApp*)AfxGetApp())->GetBoardView();
	int in_find = pView->SearchFromId(str_bid);
	if (in_find == -1) {
		in_find = pView->SearchFromUrl(str_burl);
	}
	if (in_find >= 0) {
		str_bname = pView->GetBoardName(in_find);
	}

	// ACeǉ
	Cq2chwmCacheItem *pItem = new Cq2chwmCacheItem(in_index, str_aname, str_aid, str_bname, str_bid, str_burl, chp_date);
	Insert(in_index - 1, pItem);

	// ǉACeȍ~NoCNg
	for (int i = in_index; i < Count(); i++) {
		Cq2chwmCacheItem *pItem = GetItem(i);
		pItem->SetIndex(pItem->GetIndex() + 1);
	}

	return TRUE;
}

void Cq2chwmCacheFile::Sort(
	int in_col,
	BOOL bo_asc)
{
	if (bo_asc == TRUE) {
		CYoPtrArray::Sort(Cq2chwmCacheFile::compAsc, (const void*)in_col);
	} else {
		CYoPtrArray::Sort(Cq2chwmCacheFile::compDesc, (const void*)in_col);
	}
}

int Cq2chwmCacheFile::compAsc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmCacheItem *aa;
	Cq2chwmCacheItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmCacheItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmCacheItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() > bb->GetIndex() ? 1 : -1;
	case IDX_ANAME:
		return strcmp(aa->GetArticleName(), bb->GetArticleName());
	case IDX_BNAME:
		return strcmp(aa->GetBoardName(), bb->GetBoardName());
	case IDX_DATE:
		return strcmp(aa->GetDate(), bb->GetDate());
	case IDX_SEARCH:
		// tO, NoŃ\[g
		return MAKESORTINT(bb->GetSearch(), -bb->GetIndex(), 0) >
			MAKESORTINT(aa->GetSearch(), -aa->GetIndex(), 0) ? 1 : -1;
	}
	return 0;
}

int Cq2chwmCacheFile::compDesc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmCacheItem *aa;
	Cq2chwmCacheItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmCacheItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmCacheItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() < bb->GetIndex() ? 1 : -1;
	case IDX_ANAME:
		return strcmp(bb->GetArticleName(), aa->GetArticleName());
	case IDX_BNAME:
		return strcmp(bb->GetBoardName(), aa->GetBoardName());
	case IDX_DATE:
		return strcmp(bb->GetDate(), aa->GetDate());
	}
	return 0;
}

void Cq2chwmCacheFile::RemoveItem(
	int in_index)
{
	Cq2chwmCacheItem *pItem = (Cq2chwmCacheItem*)Get(in_index);
	if (pItem == NULL) return;
	delete pItem;
	CYoPtrArray::Remove(in_index);

	// 폜ACeȍ~NofNg
	for (int i = in_index; i < Count(); i++) {
		Cq2chwmCacheItem *pItem = GetItem(i);
		pItem->SetIndex(pItem->GetIndex() - 1);
	}
}

int Cq2chwmCacheFile::SearchItem(
	const char *chp_filename)
{
	for (int i = 0; i < Count(); i++) {
		Cq2chwmCacheItem *pItem = GetItem(i);
		if (strcmp(pItem->GetFileName(), chp_filename) == 0) {
			return i;
		}
	}
	return -1;
}

BOOL Cq2chwmCacheFile::UpdateItem(
	int in_row)
{
	Cq2chwmCacheItem *pItem = GetItem(in_row);
	if (pItem == NULL) return FALSE;
	WIN32_FIND_DATA st_find;
	HANDLE hFind;

	CString cstr_find;;
	cstr_find = pItem->GetFileName();
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		// t@C폜ꂽ
		RemoveItem(in_row);
	} else {
		// XVԎ擾
		FILETIME st_filetime;
		SYSTEMTIME st_systemtime;
		FileTimeToLocalFileTime(&st_find.ftLastWriteTime, &st_filetime);
		FileTimeToSystemTime(&st_filetime, &st_systemtime);

		CYoString str_date;
		str_date.Format("%04d/%02d/%02d %02d:%02d:%02d",
			st_systemtime.wYear, st_systemtime.wMonth, st_systemtime.wDay, st_systemtime.wHour, st_systemtime.wMinute, st_systemtime.wSecond);
		pItem->SetDate(str_date);
		::FindClose(hFind);
	}
	return TRUE;
}

BOOL Cq2chwmCacheFile::AddItem(
	const char *chp_filename)
{
	WIN32_FIND_DATA st_find;
	HANDLE hFind;

	CString cstr_find;;
	cstr_find = chp_filename;
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		return FALSE;
	} else {
		// XVԎ擾
		FILETIME st_filetime;
		SYSTEMTIME st_systemtime;
		FileTimeToLocalFileTime(&st_find.ftLastWriteTime, &st_filetime);
		FileTimeToSystemTime(&st_filetime, &st_systemtime);

		CYoString str_date;
		str_date.Format("%04d/%02d/%02d %02d:%02d:%02d",
			st_systemtime.wYear, st_systemtime.wMonth, st_systemtime.wDay, st_systemtime.wHour, st_systemtime.wMinute, st_systemtime.wSecond);
		addItem(1, chp_filename, str_date);
		::FindClose(hFind);
	}
	return TRUE;
}