// q2chwmBookmarkBoardView.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmBookmarkBoardView.h"
#include "q2chwmConfig.h"

// Cq2chwmBookmarkBoardView

//IMPLEMENT_DYNCREATE(Cq2chwmBookmarkBoardView, Cq2chwmListView)

Cq2chwmBookmarkBoardView::Cq2chwmBookmarkBoardView()
{
	m_bo_multiselect = FALSE;
	m_bo_create = FALSE;
}

Cq2chwmBookmarkBoardView::~Cq2chwmBookmarkBoardView()
{
}

BEGIN_MESSAGE_MAP(Cq2chwmBookmarkBoardView, Cq2chwmListView)
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_SORT_BNAME, &Cq2chwmBookmarkBoardView::OnSortBname)
	ON_UPDATE_COMMAND_UI(ID_SORT_BNAME, &Cq2chwmBookmarkBoardView::OnUpdateSortBname)
	ON_COMMAND(ID_SORT_INDEX, &Cq2chwmBookmarkBoardView::OnSortIndex)
	ON_UPDATE_COMMAND_UI(ID_SORT_INDEX, &Cq2chwmBookmarkBoardView::OnUpdateSortIndex)
	ON_COMMAND(ID_SORT_SEARCH, &Cq2chwmBookmarkBoardView::OnSortSearch)
	ON_UPDATE_COMMAND_UI(ID_SORT_SEARCH, &Cq2chwmBookmarkBoardView::OnUpdateSortSearch)
	ON_WM_SHOWWINDOW()
	ON_COMMAND(ID_ADJUST_COLUMN_WIDTH, &Cq2chwmBookmarkBoardView::OnAdjustColumnWidth)
	ON_COMMAND(ID_DELETE, &Cq2chwmBookmarkBoardView::OnDelete)
END_MESSAGE_MAP()


// Cq2chwmBookmarkBoardView ff

#ifdef _DEBUG
void Cq2chwmBookmarkBoardView::AssertValid() const
{
	Cq2chwmListView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmBookmarkBoardView::Dump(CDumpContext& dc) const
{
	Cq2chwmListView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmBookmarkBoardView bZ[W nh
BOOL Cq2chwmBookmarkBoardView::CreateFromFile()
{
	if (m_bo_create == TRUE) return TRUE;
	// \[gԂۑ
	Cq2chwmConfig::GetInstance()->SetSortColumnBookmarkBoard(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscBookmarkBoard(GetSortAsc());

	m_cFile.RemoveAll();
	m_cFile.Create();
	GetListCtrl().SetItemCountEx(m_cFile.Count());
	SortItems(Cq2chwmConfig::GetInstance()->GetSortColumnBookmarkBoard(),
		Cq2chwmConfig::GetInstance()->GetSortAscBookmarkBoard());
	GoTop();
	m_bo_create = TRUE;
	return TRUE;
}

BOOL Cq2chwmBookmarkBoardView::Reload()
{
	m_bo_create = FALSE;
	return CreateFromFile();
}

void Cq2chwmBookmarkBoardView::OnInitialUpdate()
{
	Cq2chwmListView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetListCtrl().InsertColumn(0, _T("No"));
	GetListCtrl().InsertColumn(1, _T(""));
	GetListCtrl().InsertColumn(2, _T("L["));
	if (Cq2chwmConfig::GetInstance()->GetColumnWidthBookmarkBoardCount() == 0) {
		GetListCtrl().SetColumnWidth(0, 50);
		GetListCtrl().SetColumnWidth(1, 300);
		GetListCtrl().SetColumnWidth(2, 100);
	} else {
		GetListCtrl().SetColumnWidth(0, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmarkBoard(0));
		GetListCtrl().SetColumnWidth(1, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmarkBoard(1));
		GetListCtrl().SetColumnWidth(2, Cq2chwmConfig::GetInstance()->GetColumnWidthBookmarkBoard(2));
	}
	SetFont();
	SetSortColumn(Cq2chwmConfig::GetInstance()->GetSortColumnBookmarkBoard());
	SetSortAsc(Cq2chwmConfig::GetInstance()->GetSortAscBookmarkBoard());
}

void Cq2chwmBookmarkBoardView::SetFont()
{
	Cq2chwmListView::SetFont(Cq2chwmConfig::GetInstance()->GetFontNameBookmark(),
		Cq2chwmConfig::GetInstance()->GetFontSizeBookmark(), Cq2chwmConfig::GetInstance()->GetFontBoldBookmark());
}

void Cq2chwmBookmarkBoardView::OnDestroy()
{
	CYoPtrArray cArray;
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(0));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(1));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(2));
	Cq2chwmConfig::GetInstance()->SetColumnWidthBookmarkBoard(cArray);
	Cq2chwmConfig::GetInstance()->SetSortColumnBookmarkBoard(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscBookmarkBoard(GetSortAsc());
	m_cFile.RemoveAll();
	Cq2chwmListView::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
}

void Cq2chwmBookmarkBoardView::OnListClicked()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return;
	Cq2chwmBookmarkBoardItem *pItem = m_cFile.GetItem((int)pos - 1);
	if (pItem == NULL) return;

	if (m_bo_multiselect == TRUE) {
		pItem->SetSelected(!pItem->GetSelected());
		RECT rect;
		GetListCtrl().GetItemRect((int)pos - 1, &rect, LVIR_BOUNDS);
		InvalidateRect(&rect, FALSE);
	} else {
		Cq2chwmBoardItem cItem(pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
		AfxGetMainWnd()->SendMessage(WM_USER_BOARDCLICKED, 0, (LPARAM)&cItem);
	}
}

void Cq2chwmBookmarkBoardView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (Cq2chwmConfig::GetInstance()->IsKeySort(nChar)) {
		Sort();
		return;
	}

	Cq2chwmListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void Cq2chwmBookmarkBoardView::Sort()
{
	int in_col = GetSortColumn();
	if (in_col == Cq2chwmBookmarkBoardFile::IDX_SEARCH) {
		in_col = Cq2chwmBookmarkBoardFile::IDX_INDEX;
	} else {
		in_col++;
	}
	SortItems(in_col, TRUE);
}

void Cq2chwmBookmarkBoardView::SortItems(
	int in_col,
	BOOL bo_asc)
{
	// \[gsƂ^Cgo[ς
	/*
	CString cstr_title = _T("LbV");
	switch (in_col) {
	case Cq2chwmCacheFile::IDX_INDEX:
		cstr_title += _T("[No]");
		break;
	case Cq2chwmCacheFile::IDX_ANAME:
		cstr_title += _T("[Xbh]");
		break;
	case Cq2chwmCacheFile::IDX_BNAME:
		cstr_title += _T("[]");
		break;
	case Cq2chwmCacheFile::IDX_DATE:
		cstr_title += _T("[XV]");
		break;
	case Cq2chwmCacheFile::IDX_SEARCH:
		cstr_title += _T("[]");
		break;
	};
	AfxGetMainWnd()->SetWindowText(cstr_title);
	*/

	m_cFile.Sort(in_col, bo_asc);
	if (IsWindowVisible() == TRUE) RedrawWindow();
	SetSortColumn(in_col);
	SetSortAsc(bo_asc);
}

void Cq2chwmBookmarkBoardView::Search(
	const char *chp_word)
{
	BOOL bo_ret = FALSE;
	CYoRegex cRegex(chp_word, CYoRegex::SJIS, TRUE);
	for (int i = 0; i < m_cFile.Count(); i++) {
		Cq2chwmBookmarkBoardItem *pItem = m_cFile.GetItem(i);
		if (cRegex.Match(pItem->GetBoardName()) >= 0) {
			pItem->SetSearch(TRUE);
			bo_ret = TRUE;
		} else {
			pItem->SetSearch(FALSE);
		}
	}

	// }b`ꍇ̂݁A[]Ń\[g&ֈړ
	if (bo_ret == TRUE) {
		SortItems(Cq2chwmBookmarkBoardFile::IDX_SEARCH, TRUE);
		GoTop();
	}
}

BOOL Cq2chwmBookmarkBoardView::GetItemText(
	LPTSTR wchp_text,
	int in_size,
	int in_row,
	int in_col)
{
	Cq2chwmBookmarkBoardItem *pItem = m_cFile.GetItem(in_row);
	if (pItem == NULL) return FALSE;
	CString cstr_tmp;
	switch (in_col) {
	case Cq2chwmBookmarkBoardFile::IDX_INDEX:
		cstr_tmp.Format(_T("%d"), pItem->GetIndex());
		break;
	case Cq2chwmBookmarkBoardFile::IDX_BNAME:
		cstr_tmp = pItem->GetBoardName();
		break;
	case Cq2chwmBookmarkBoardFile::IDX_BID:
		cstr_tmp = pItem->GetBoardId();
		break;
	};
	_tcscpy_s(wchp_text, in_size, cstr_tmp);
	return TRUE;
}

Cq2chwmListItem *Cq2chwmBookmarkBoardView::GetSelectedItem()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return NULL;
	return m_cFile.GetItem((int)pos - 1);
}

Cq2chwmListItem *Cq2chwmBookmarkBoardView::GetItem(
	int iRow)
{
	return m_cFile.GetItem(iRow);
}

void Cq2chwmBookmarkBoardView::OnSortBname()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkBoardFile::IDX_BNAME, TRUE);
}

void Cq2chwmBookmarkBoardView::OnUpdateSortBname(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkBoardFile::IDX_BNAME);
}

void Cq2chwmBookmarkBoardView::OnSortIndex()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkBoardFile::IDX_INDEX, TRUE);
}

void Cq2chwmBookmarkBoardView::OnUpdateSortIndex(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkBoardFile::IDX_INDEX);
}

void Cq2chwmBookmarkBoardView::OnSortSearch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmBookmarkBoardFile::IDX_SEARCH, TRUE);
}

void Cq2chwmBookmarkBoardView::OnUpdateSortSearch(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmBookmarkBoardFile::IDX_SEARCH);
}

void Cq2chwmBookmarkBoardView::OnAdjustColumnWidth()
{
	// TODO: ɃR}h nh R[hǉ܂B
	for (int i = 0; i < GetListCtrl().GetHeaderCtrl()->GetItemCount(); i++) {
		GetListCtrl().SetColumnWidth(i, LVSCW_AUTOSIZE);
	}
}

BOOL Cq2chwmBookmarkBoardView::AddItem(
	const char *chp_bname,
	const char *chp_bid,
	const char *chp_burl)
{
	for (int i = 0; i < m_cFile.Count(); i++) {
		Cq2chwmBookmarkBoardItem *pItem = m_cFile.GetItem(i);
		if (strcmp(chp_bid, pItem->GetBoardId()) == 0) {
			return FALSE;
		}
	}
	if (m_cFile.AddItem(chp_bname, chp_bid, chp_burl) == FALSE) {
		return FALSE;
	}
	GetListCtrl().SetItemCountEx(m_cFile.Count());
	InvalidateRect(NULL);
	UpdateWindow();
	return TRUE;
}

void Cq2chwmBookmarkBoardView::CopyInformation()
{
	Cq2chwmBookmarkBoardItem *pItem = (Cq2chwmBookmarkBoardItem*)GetSelectedItem();
	if (pItem == NULL) return;
	CString cstr_text;
	cstr_text.Format(_T("%s\r\n%s\r\n"), W(pItem->GetBoardName()), W(pItem->GetBoardUrl()));
	StringToClipboard(cstr_text);
}

BOOL Cq2chwmBookmarkBoardView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	cs.style &= ~WS_BORDER;
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	return Cq2chwmListView::PreCreateWindow(cs);
}

void Cq2chwmBookmarkBoardView::OnDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if (pos == NULL) return;
	if (::MessageBox(m_hWnd, _T("폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		m_cFile.Remove((int)pos - 1);
		m_cFile.Write();
		GetListCtrl().SetItemCountEx(m_cFile.Count());
		InvalidateRect(NULL);
	}
}
