#include "stdafx.h"
#include "DlgAssociationEdit.h"

#include <QProcess>
#include <QDir>
#include <QUrl>
#include <QDesktopServices>

#include <shlobj.h>
#include <shlwapi.h>
#include <objbase.h>

#include "PathInfo.h"

#include "../../Lib/Qt5Utility/ExtCmdRunner.h"



DlgAssociationEdit::DlgAssociationEdit(QWidget *parent)
	: QDialog(parent)
{
	ui.setupUi(this);

	Qt::WindowFlags flags = windowFlags() & (~Qt::WindowContextHelpButtonHint);
	flags = flags | Qt::WindowCloseButtonHint;
	setWindowFlags(flags);
}

void DlgAssociationEdit::SetAssociation(QString ext)
{
	QString mypath = QApplication::applicationFilePath();
	mypath = QDir::toNativeSeparators(mypath);

	QString cmd = PathInfo::GetAsscEditorPath();
	cmd = QDir::toNativeSeparators(cmd);

	ExtCmdRunner runner;
	runner.cmd = "\"" + cmd + "\"";
	runner.args = ext + " \"" + mypath + "\"";
	runner.Execute();
}

void DlgAssociationEdit::on_buttonAddObj_clicked()
{
	SetAssociation("obj");
}

void DlgAssociationEdit::on_buttonAddStl_clicked()
{
	SetAssociation("stl");
}

void DlgAssociationEdit::on_buttonAddPly_clicked()
{
	SetAssociation("ply");
}

void DlgAssociationEdit::on_buttonAddMqo_clicked()
{
	SetAssociation("mqo");
}

void DlgAssociationEdit::on_buttonAddX_clicked()
{
	SetAssociation("x");
}

void DlgAssociationEdit::on_buttonAddDae_clicked()
{
	SetAssociation("dae");
}
