import sys
import os
from VersionDef import *



def getMajorVersion():
	return MAJOR_VERSION

def getMinorVersion():
	return MINOR_VERSION


def getEnv(name):
	val = os.environ.get(name)
	if val is None:
		return '?'

	return val

def getSvnRevision():
	return getEnv('SVN_REVISION')

def getGitRevisionFull():
	return os.environ.get('GIT_COMMIT')

def getGitRevision():
	val = os.environ.get('GIT_COMMIT')
	if val is None:
		return '?'

	slen = len(val)
	if slen < 6:
		return '?'

	return val[0:6]

def getVCSRevision():
	return '0'

def getBuildID():
	return getEnv('BUILD_ID')

def getBuildNumber():
	return getEnv('BUILD_NUMBER')

def getBuildTag():
	return getEnv('BUILD_TAG')


def getMainVersion():
	return getMajorVersion() + '.' + getMinorVersion()

def getFullVersion():
	return getMainVersion() + '.' + getBuildNumber() + '.' + getVCSRevision()

def getMainVersionC():
	return getMajorVersion() + ',' + getMinorVersion()

def getFullVersionC():
	return getMainVersionC() + ',' + getBuildNumber() + ',' + getVCSRevision()
