/* OggVorbis.h */
/* 2009/07/24  */

#pragma once

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* */

struct QOV_Format {

	INT32 SamplingRate;
	INT32 Channels;
	INT64 Duration;

}; /* QOV_Format */

typedef struct QOV_Format QOV_Format_t;

/* */

struct QOV_Reader;

typedef struct QOV_Reader QOV_Reader_t;

QOV_Reader_t* QOV_CreateReader(void);

void QOV_ReleaseReader(QOV_Reader_t* t);

BOOL QOV_OpenReader(
	QOV_Reader_t* t,
	const WCHAR*  path);

BOOL QOV_OpenReader_IStream(
	QOV_Reader_t* t,
	IStream*      p);

const QOV_Format_t* QOV_GetFormat(
	QOV_Reader_t* t);

BOOL QOV_Seek(
	QOV_Reader_t* t,
	INT64         sample);

BOOL QOV_Decode(
	QOV_Reader_t* t,
	VOID*         buffer,
	INT32         samples,
	INT32*        output);

/* */

#ifdef __cplusplus
}
#endif /* __cplusplus */

