// Utils.cs
// 2008/11/19

using System;
using System.IO;
using System.Text;

namespace QAX {

// Utils
public static class Utils {

	static readonly UInt64[] BIN64 = {
		1 << (7 * 1),
		1 << (7 * 2),
		1 << (7 * 3),
		1 << (7 * 4),
		1 << (7 * 5),
		1 << (7 * 6)
	};

	public static Int32 ToBinary(UInt64 val, Byte[] buffer, Int32 index, Int32 length)
	{
		for (Int32 i = 0; i < BIN64.Length; i++) {
			if (val < BIN64[i]) {
				Int32 sz = i + 1;
				if (sz > length) {
					throw new BinaryFormatError("OutOfBufferSize");
				}

				Int32 s = 7 - i;

				Byte mark = (Byte)(1 << s);
				Byte mask = (Byte)(mark - 1);

				Byte by = (Byte)((0xff ^ mask ^ mark) | ((Byte)val & mask));

				buffer[index] = by;

				val >>= s;

				for (Int32 j = 1; j < sz; j++) {
					buffer[index + j] = (Byte)val;
					val >>= 8;
				}

				return sz;
			}
		}

		throw new BinaryFormatError("OutOfValueRange");
	}

	public static String ToString(Byte[] by)
	{
		var buf = new StringBuilder();

		for (Int32 i = 0; i < by.Length; i++) {
			Int32 hi = by[i] >> 4;
			Int32 lo = by[i] & 0xf;

			Char ch;

			ch = (Char)((hi < 10) ? '0' + hi : 'a' + hi - 10);
			buf.Append(ch);

			ch = (Char)((lo < 10) ? '0' + lo : 'a' + lo - 10);
			buf.Append(ch);
		}

		return buf.ToString();
	}

	public static Int32 WriteLengths(BinaryWriter w, Int32[] lens)
	{
		Int32 sz = 0;

		Byte[] buffer = new Byte[8];

		Int32 len = Utils.ToBinary((UInt64)lens.Length, buffer, 0, buffer.Length);
		w.Write(buffer, 0, len);
		sz += len;

		for (Int32 i = 0; i < lens.Length; i++) {
			len = Utils.ToBinary((UInt64)lens[i], buffer, 0, buffer.Length);
			w.Write(buffer, 0, len);
			sz += len;
		}

		return sz;
	}

	public static Int32 WriteArray(BinaryWriter w, Int32[] vals)
	{
		Int32 sz = 0;

		Byte[] buffer = new Byte[8];

		for (Int32 i = 0; i < vals.Length; i++) {
			Int32 len = Utils.ToBinary((UInt64)vals[i], buffer, 0, buffer.Length);
			w.Write(buffer, 0, len);
			sz += len;
		}

		return sz;
	}

} // Utils

} // namespace QAX

