------------------------------------------------------------------------------
-- Copyright 2018 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with Ada.Strings.Unbounded;
private with Ada.Finalization;

with Fast_Strings.Internal;

package Fast_Strings.Unbounded with Preelaborate is

   use Ada.Strings.Unbounded;

   type Constant_Unbounded_String_Container
     (Data : not null access constant Unbounded_String) is
     limited private
     with Implicit_Dereference => Data;

   type String_View
     (Data : not null access constant String) is
   limited record
      To_Unbounded_String : Constant_Unbounded_String_Container
        (Null_Unbounded_String'Unrestricted_Access);
   end record
     with Implicit_Dereference => Data;

   function To_String_View
     (Source : in Unbounded_String)
     return String_View;

   type String_Editor_Reference
     (Data : not null access String;
      Target : not null access Unbounded_String) is
     limited private
     with Implicit_Dereference => Data;

   -- borrows Target on initialization
   -- commits to Target on finalization
   type String_Editor
     (Target : not null access Unbounded_String) is
   limited record
      Edit : String_Editor_Reference (Internal.Aliased_Empty_String'Access, Target);
   end record;

private

   type String_Constraints is record
      First : Positive := 1;
      Last : Natural := 0;
   end record;

   type Constant_Unbounded_String_Container
     (Data : access constant Unbounded_String) is
   limited record
      Constraints : aliased String_Constraints;
      Item : aliased Unbounded_String;
   end record;

   type String_Editor_Reference
     (Data : not null access String;
      Target : not null access Unbounded_String) is
     new Ada.Finalization.Limited_Controlled with
   record
      Constraints : aliased String_Constraints;
      Target_Shadow : aliased Unbounded_String := Target.all;
   end record;

   overriding
   procedure Initialize (Object : in out String_Editor_Reference);

   overriding
   procedure Finalize (Object : in out String_Editor_Reference);

end Fast_Strings.Unbounded;
