------------------------------------------------------------------------------
-- Copyright 2018 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with Ada.Text_IO;
with Ada.Strings.Unbounded;

with Fast_Strings.Unbounded;

procedure Fast_Strings.Tester.Main is

   use Ada.Strings.Unbounded;
   use Fast_Strings.Unbounded;

   Value_1 : aliased Unbounded_String;

begin
   Set_Unbounded_String (Value_1, "[string]");
   Ada.Text_IO.Put_Line ("To_String (Value_1): " & To_String (Value_1));
   Ada.Text_IO.Put_Line ("To_String_View (Value_1): " & To_String_View (Value_1));

   declare
      Value_1_View : String renames To_String_View (Value_1);
   begin
      Ada.Text_IO.Put_Line ("Value_1_View: " & Value_1_View);
   end;

   declare
      Value_1_View_2 : String_View := To_String_View (Value_1);
   begin
      Ada.Text_IO.Put_Line ("Value_1_View_2: " & Value_1_View_2);
      Ada.Text_IO.Put_Line
        ("To_String (Value_1_View_2.To_Unbounded_String): " &
         To_String (Value_1_View_2.To_Unbounded_String));
   end;

   declare
      Value_1_Editor : String_Editor (Value_1'Access);
      Value_1_Edit : String renames Value_1_Editor.Edit;
   begin
      Ada.Text_IO.Put_Line ("To_String (borrowed Value_1): " & To_String (Value_1));
      Ada.Text_IO.Put_Line ("To_String (Value_1_Edit): " & Value_1_Edit);
      Value_1_Edit (2) := 'S';
      Ada.Text_IO.Put_Line ("To_String (Value_1_Edit): " & Value_1_Edit);
      Ada.Text_IO.Put_Line ("To_String (borrowed Value_1): " & To_String (Value_1));
   end;
   Ada.Text_IO.Put_Line ("To_String (commited Value_1): " & To_String (Value_1));

end Fast_Strings.Tester.Main;
