/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.expr;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import net.morilib.db.functions.FunctionLoader;
import net.morilib.db.functions.FunctionType;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.RelationAggregate;

public abstract class RelationFunction {

	private static Map<String, RelationFunction> map =
			FunctionLoader.load();

	/**
	 * 
	 * @param s
	 * @return
	 * @throws SQLException
	 */
	public static RelationFunction get(String s) throws SQLException {
		RelationFunction f;

		if((f = map.get(s.toUpperCase())) != null) {
			return f;
		} else {
			throw ErrorBundle.getDefault(10011, s.toUpperCase());
		}
	}

	/**
	 * 
	 * @param t
	 * @return
	 */
	public static String getListString(FunctionType t) {
		StringBuffer b = new StringBuffer();
		String d = "";

		for(Map.Entry<String, RelationFunction> s : map.entrySet()) {
			if(s.getValue().getType() == t) {
				b.append(d).append(s.getKey());
				d = ",";
			}
		}
		return b.toString();
	}

	/**
	 * 
	 * @return
	 */
	public abstract boolean isAggregate();

	/**
	 * 
	 * @param m
	 * @param group
	 * @param args
	 * @return
	 * @throws SQLException
	 */
	public abstract Object operate(RelationAggregate m,
			List<Object> group,
			Object... args) throws SQLException;

	/**
	 * 
	 * @param m
	 * @return
	 * @throws SQLException
	 */
	public abstract Object init(
			RelationAggregate m) throws SQLException;

	/**
	 * 
	 * @return
	 */
	public abstract FunctionType getType();

}
