/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;

import net.morilib.db.delay.DefaultDelay;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.Relations;

public class FnCount extends RelationFunction {

	@Override
	public boolean isAggregate() {
		return true;
	}

	@Override
	public Object operate(RelationAggregate m,
			List<Object> group,
			Object... args) throws SQLException {
		Rational d;

		d = (Rational)m.get(group).force();
		if(args.length != 1) {
			throw ErrorBundle.getDefault(10007, "COUNT");
		} else if(args[0] == Relations.ANY) {
			d = d.add(Rational.ONE);
		} else if(!args[0].equals("")) {
			d = d.add(Rational.ONE);
		}
		m.put(group, new DefaultDelay(d));
		return d;
	}

	@Override
	public Object init(
			RelationAggregate m) throws SQLException {
		Rational d = Rational.ZERO;

		m.init(new DefaultDelay(d));
		return d;
	}

	@Override
	public FunctionType getType() {
		return FunctionType.NUMERIC;
	}

}
