/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.parser.html;

import java.sql.SQLException;

public interface HTMLHandler {

	/**
	 * 
	 * @return
	 */
	public void string(String s) throws SQLException;

	/**
	 * 
	 * @param s
	 * @return
	 */
	public void startTag(String s) throws SQLException;

	/**
	 * 
	 * @return
	 */
	public void endTag(String s) throws SQLException;

	/**
	 * 
	 * @param k
	 * @param v
	 */
	public void tagAttribute(String k, String v) throws SQLException;

	/**
	 * 
	 * @param s
	 * @throws SQLException
	 */
	public void meta(String s) throws SQLException;

	/**
	 * 
	 * @param s
	 * @throws SQLException
	 */
	public void comment(String s) throws SQLException;

}
