/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.map.CSVDataMapper;
import net.morilib.db.map.SqlDataMapper;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.TableRenameRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sql.DbSqlLexer;
import net.morilib.db.sql.DbSqlParser;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public class SqlFileSystemStub implements SqlSchema {

	private Map<String, Relation> rels;

	public Reader getReader(String name) throws IOException {
		String n = name.toLowerCase();
		InputStream ins;

		ins = SqlFileSystemStub.class.getResourceAsStream(
				"/net/morilib/db/engine/" + n.toLowerCase());
		if(ins == null) {
			throw new IOException();
		}
		return new InputStreamReader(ins, "UTF-8");
	}

	public Reader getTableReader(
			String name) throws IOException, SQLException {
		String n = name.toLowerCase();
		InputStream ins;

		n = name + ".csv";
		ins = SqlFileSystemStub.class.getResourceAsStream(
				"/net/morilib/db/engine/" + n.toLowerCase());
		if(ins == null) {
			throw new IOException();
		}
		return new InputStreamReader(ins, "UTF-8");
	}

	public PrintWriter getTableWriter(
			String name) throws IOException, SQLException {
		throw new RuntimeException();
	}

	@Override
	public NamedRelation readRelation(String t,
			String as) throws IOException, SQLException {
		SqlDataMapper m;

		m = new CSVDataMapper();
		if(rels != null && rels.containsKey(t.toUpperCase())) {
			return new TableRenameRelation(
					rels.get(t.toUpperCase()),
					(as != null ? as : t).toUpperCase());
		}
		return m.read(t.toLowerCase() + ".csv", as, getCreateTable(t),
				getTableReader(t));
	}

	@Override
	public void writeRelation(String name,
			Collection<RelationTuple> z
			) throws IOException, SQLException {
		SqlCreateTable c = getCreateTable(name);
		PrintWriter w = null;
		SqlDataMapper m;

		if(name.endsWith(".csv")) {
			m = new CSVDataMapper();
		} else {
			throw new SQLException("table not found");
		}
		w = getTableWriter(name);
		m.write(name, c, w, z);
	}

	@Override
	public SqlCreateTable getCreateTable(
			String name) throws IOException, SQLException {
		Reader rd = getReader(name + ".ddl");
		DbSqlLexer l;
		Object o;

		try {
			l = new DbSqlLexer(rd);
			o = new DbSqlParser().parse(l);
			if(o instanceof SqlCreateTable) {
				return (SqlCreateTable)o;
			} else {
				throw new SQLException();
			}
		} finally {
			rd.close();
		}
	}

	@Override
	public Collection<String> getTableNames() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isTable(
			String name) throws IOException, SQLException {
		return true;
	}

	@Override
	public void putCreateTable(String name,
			SqlCreateTable table) throws IOException, SQLException {
		throw new SQLException();
	}

	@Override
	public void alterCreateTable(String name,
			SqlCreateTable table) throws IOException, SQLException {
		throw new SQLException();
	}

	@Override
	public void truncateTable(
			String name) throws IOException, SQLException {
		throw new SQLException();
	}

	@Override
	public void removeCreateTable(
			String name) throws IOException, SQLException {
		throw new SQLException();
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#fork()
	 */
	@Override
	public SqlSchema fork() {
		return this;
	}

	@Override
	public NullBoolean isReadonly() {
		return NullBoolean.TRUE;
	}

	@Override
	public NullBoolean usesLocalFiles() {
		return NullBoolean.FALSE;
	}

	@Override
	public NullBoolean usesLocalFilePerTable() {
		return NullBoolean.FALSE;
	}

	@Override
	public FabriqueDeFichier fabrique() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#bindSchema(java.lang.String, net.morilib.db.relations.Relation)
	 */
	@Override
	public void bindSchema(String name, Relation r) {
		rels.put(name, r);
	}

}
