package net.morilib.db.jdbc;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

import net.morilib.db.misc.ErrorBundle;

public class BeanResultSetMetaData implements ResultSetMetaData {

	private List<String> columns;
	private Class<?> classe;

	BeanResultSetMetaData(Class<?> c, List<String> l) {
		classe = c;
		columns = l;
	}

	Class<?> _gettype(String columnLabel) throws SQLException {
		Method m;

		try {
			m = classe.getMethod(
					"get" + BeanListResultSet._tolower(columnLabel));
			return m.getReturnType();
		} catch (SecurityException e) {
			throw new RuntimeException(e);
		} catch (NoSuchMethodException e) {
			throw ErrorBundle.getDefault(10009, columnLabel);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		}
	}

	Class<?> _gettype(int c) throws SQLException {
		if(c < 1 || c > columns.size()) {
			throw ErrorBundle.getDefault(10045, c);
		}
		return _gettype(columns.get(c - 1));
	}

	@Override
	public boolean isWrapperFor(Class<?> arg0) throws SQLException {
		return false;
	}

	@Override
	public <T> T unwrap(Class<T> arg0) throws SQLException {
		throw new SQLException("not supported");
	}

	@Override
	public int getColumnCount() throws SQLException {
		return columns.size();
	}

	@Override
	public boolean isAutoIncrement(int column) throws SQLException {
		return false;
	}

	@Override
	public boolean isCaseSensitive(int column) throws SQLException {
		return false;
	}

	@Override
	public boolean isSearchable(int column) throws SQLException {
		return true;
	}

	@Override
	public boolean isCurrency(int column) throws SQLException {
		return false;
	}

	@Override
	public int isNullable(int column) throws SQLException {
		return columnNullable;
	}

	@Override
	public boolean isSigned(int column) throws SQLException {
		return _gettype(column).isAssignableFrom(Number.class);
	}

	@Override
	public int getColumnDisplaySize(int column) throws SQLException {
		Class<?> c = _gettype(column);

		if(c.isAssignableFrom(Byte.class)) {
			return 4;
		} else if(c.isAssignableFrom(Short.class)) {
			return 6;
		} else if(c.isAssignableFrom(Integer.class)) {
			return 11;
		} else if(c.isAssignableFrom(Long.class)) {
			return 20;
		} else {
			return 0;
		}
	}

	@Override
	public String getColumnLabel(int column) throws SQLException {
		if(column < 1 || column > columns.size()) {
			throw ErrorBundle.getDefault(10045, column);
		}
		return columns.get(column - 1);
	}

	@Override
	public String getColumnName(int column) throws SQLException {
		return getColumnLabel(column);
	}

	@Override
	public String getSchemaName(int column) throws SQLException {
		return "";
	}

	@Override
	public int getPrecision(int column) throws SQLException {
		return 0;
	}

	@Override
	public int getScale(int column) throws SQLException {
		return 0;
	}

	@Override
	public String getTableName(int column) throws SQLException {
		return "";
	}

	@Override
	public String getCatalogName(int column) throws SQLException {
		return "";
	}

	@Override
	public int getColumnType(int column) throws SQLException {
		Class<?> c = _gettype(column);

		if(c.isAssignableFrom(Byte.class)) {
			return java.sql.Types.INTEGER;
		} else if(c.isAssignableFrom(Short.class)) {
			return java.sql.Types.INTEGER;
		} else if(c.isAssignableFrom(Integer.class)) {
			return java.sql.Types.INTEGER;
		} else if(c.isAssignableFrom(Long.class)) {
			return java.sql.Types.INTEGER;
		} else if(c.isAssignableFrom(String.class)) {
			return java.sql.Types.VARCHAR;
		} else if(c.isAssignableFrom(BigDecimal.class)) {
			return java.sql.Types.NUMERIC;
		} else {
			return java.sql.Types.VARCHAR;
		}
	}

	@Override
	public String getColumnTypeName(int column) throws SQLException {
		Class<?> c = _gettype(column);

		if(c.isAssignableFrom(Byte.class)) {
			return "INTEGER";
		} else if(c.isAssignableFrom(Short.class)) {
			return "INTEGER";
		} else if(c.isAssignableFrom(Integer.class)) {
			return "INTEGER";
		} else if(c.isAssignableFrom(Long.class)) {
			return "INTEGER";
		} else if(c.isAssignableFrom(String.class)) {
			return "VARCHAR";
		} else if(c.isAssignableFrom(BigDecimal.class)) {
			return "NUMERIC";
		} else {
			return "VARCHAR";
		}
	}

	@Override
	public boolean isReadOnly(int column) throws SQLException {
		return true;
	}

	@Override
	public boolean isWritable(int column) throws SQLException {
		return false;
	}

	@Override
	public boolean isDefinitelyWritable(int column) throws SQLException {
		return false;
	}

	@Override
	public String getColumnClassName(int column) throws SQLException {
		return _gettype(column).toString();
	}

}
