package net.morilib.db.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sql.DbSqlParser;

public class RelationsConnection implements Connection {

	private static Logger logger = RelationsJDBCUtils.logger;

	SqlEngine engine;
	SqlSchema schema;
	String url;

	RelationsConnection(String l, SqlEngine e, SqlSchema s) {
		engine = e;
		schema = s;
		url = l;
	}

	public <T> T unwrap(Class<T> arg0) throws SQLException {
		logger.finer("unwrap");
		throw new SQLException("not supported");
	}

	public boolean isWrapperFor(Class<?> arg0) throws SQLException {
		logger.finer("isWrapperFor");
		return false;
	}

	public void abort(Executor e) throws SQLException {
		logger.finer("abort");
	}

	public void clearWarnings() throws SQLException {
		logger.finer("clearWarnings");
		// ignore it
	}

	private void checkclose() throws SQLException {
		logger.finer("checkclose");
		if(schema == null) {
			throw ErrorBundle.getDefault(20002);
		}
	}

	public void close() throws SQLException {
		logger.finer("close");
		checkclose();
		schema = null;
		engine = null;
	}

	public void commit() throws SQLException {
		logger.finer("commit");
		checkclose();
		// ignore it
	}

	public Array createArrayOf(String s,
			Object[] a) throws SQLException {
		logger.finer("createArrayOf");
		throw new SQLFeatureNotSupportedException();
	}

	public Blob createBlob() throws SQLException {
		logger.finer("createBlob");
		throw new SQLFeatureNotSupportedException();
	}

	public Clob createClob() throws SQLException {
		logger.finer("createClob");
		throw new SQLFeatureNotSupportedException();
	}

	public NClob createNClob() throws SQLException {
		logger.finer("createNClob");
		throw new SQLFeatureNotSupportedException();
	}

	public SQLXML createSQLXML() throws SQLException {
		logger.finer("createSQLXML");
		throw new SQLFeatureNotSupportedException();
	}

	public Statement createStatement() throws SQLException {
		logger.finer("createStatement");
		return new RelationsStatement(this);
	}

	public Statement createStatement(int resultSetType,
			int resultSetConcurrency) throws SQLException {
		logger.finer("createStatement");
		logger.finer("resultSetType:" + resultSetType);
		logger.finer("resultSetConcurrency:" + resultSetConcurrency);
//		throw new SQLFeatureNotSupportedException();
		return createStatement();
	}

	public Statement createStatement(int resultSetType,
			int resultSetConcurrency,
			int resultSetHoldability) throws SQLException {
		logger.finer("createStatement");
		logger.finer("resultSetType:" + resultSetType);
		logger.finer("resultSetConcurrency:" + resultSetConcurrency);
		logger.finer("resultSetHoldability:" + resultSetHoldability);
//		throw new SQLFeatureNotSupportedException();
		return createStatement();
	}

	public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
		logger.finer("createStruct");
		throw new SQLFeatureNotSupportedException();
	}

	public boolean getAutoCommit() throws SQLException {
		logger.finer("getAutoCommit");
		return true;
	}

	public String getCatalog() throws SQLException {
		logger.finer("getCatalog");
		return null;
	}

	public Properties getClientInfo() throws SQLException {
		logger.finer("getClientInfo");
		return null;
	}

	public String getClientInfo(String arg0) throws SQLException {
		logger.finer("getClientInfo");
		return null;
	}

	public int getHoldability() throws SQLException {
		logger.finer("getHoldability");
		return ResultSet.HOLD_CURSORS_OVER_COMMIT;
	}

	public DatabaseMetaData getMetaData() throws SQLException {
		logger.finer("getMetaData");
		return new RelationsDatabaseMetadata(this);
	}

	public int getTransactionIsolation() throws SQLException {
		logger.finer("getTransactionIsolation");
		return Connection.TRANSACTION_NONE;
	}

	public Map<String, Class<?>> getTypeMap() throws SQLException {
		logger.finer("getTypeMap");
		throw new SQLFeatureNotSupportedException();
	}

	public SQLWarning getWarnings() throws SQLException {
		logger.finer("getWarnings");
		return null;
	}

	public boolean isClosed() throws SQLException {
		logger.finer("isClosed");
		return schema == null;
	}

	public boolean isReadOnly() throws SQLException {
		logger.finer("isReadOnly");
		checkclose();
		return schema.isReadonly().isTrue();
	}

	public boolean isValid(int timeout) throws SQLException {
		logger.finer("isValid");
		return false;
	}

	public String nativeSQL(String sql) throws SQLException {
		logger.finer("nativeSQL");
		return sql;
	}

	public CallableStatement prepareCall(String s) throws SQLException {
		logger.finer("prepareCall");
		throw new SQLException("prepared statement is not supported");
	}

	public CallableStatement prepareCall(String s, int a,
			int v) throws SQLException {
		logger.finer("prepareCall");
		throw new SQLFeatureNotSupportedException();
	}

	public CallableStatement prepareCall(String s, int a, int b,
			int v) throws SQLException {
		logger.finer("prepareCall");
		throw new SQLFeatureNotSupportedException();
	}

	public PreparedStatement prepareStatement(
			String s) throws SQLException {
		logger.finer("prepareStatement");
		logger.finer("query:" + s);
		try {
			return new RelationsPreparedStatement(this,
					DbSqlParser.parse(s));
		} catch (IOException e) {
			throw ErrorBundle.getDefault(10037);
		}
	}

	public PreparedStatement prepareStatement(String s,
			int resultSetType) throws SQLException {
		logger.finer("prepareStatement");
		logger.finer("query:" + s);
		logger.finer("resultSetType:" + resultSetType);
//		throw new SQLFeatureNotSupportedException();
		return prepareStatement(s);
	}

	public PreparedStatement prepareStatement(String s,
			int[] columnIndexes) throws SQLException {
		logger.finer("prepareStatement");
		logger.finer("query:" + s);
		logger.finer("columnIndexes:" + Arrays.toString(columnIndexes));
//		throw new SQLFeatureNotSupportedException();
		return prepareStatement(s);
	}

	public PreparedStatement prepareStatement(String s,
			String[] columnNames) throws SQLException {
		logger.finer("prepareStatement");
		logger.finer("query:" + s);
		logger.finer("columnNames:" + Arrays.toString(columnNames));
//		throw new SQLFeatureNotSupportedException();
		return prepareStatement(s);
	}

	public PreparedStatement prepareStatement(String s,
			int resultSetType,
			int resultSetConcurrency) throws SQLException {
		logger.finer("prepareStatement");
		logger.finer("query:" + s);
		logger.finer("resultSetType:" + resultSetType);
		logger.finer("resultSetConcurrency:" + resultSetConcurrency);
//		throw new SQLFeatureNotSupportedException();
		return prepareStatement(s);
	}

	public PreparedStatement prepareStatement(String s,
			int resultSetType, int resultSetConcurrency,
			int resultSetHoldability) throws SQLException {
		logger.finer("prepareStatement");
		logger.finer("query:" + s);
		logger.finer("resultSetType:" + resultSetType);
		logger.finer("resultSetConcurrency:" + resultSetConcurrency);
		logger.finer("resultSetHoldability:" + resultSetHoldability);
//		throw new SQLFeatureNotSupportedException();
		return prepareStatement(s);
	}

	public void releaseSavepoint(Savepoint s) throws SQLException {
		logger.finer("releaseSavepoint");
		throw new SQLFeatureNotSupportedException();
	}

	public void rollback() throws SQLException {
		// TODO
		logger.finer("rollback");
		// ignore it
	}

	public void rollback(Savepoint s) throws SQLException {
		logger.finer("rollback");
		throw new SQLFeatureNotSupportedException();
	}

	public void setAutoCommit(boolean b) throws SQLException {
		// TODO
		logger.finer("setAutoCommit");
		// ignore it
	}

	public void setCatalog(String c) throws SQLException {
		logger.finer("setCatalog");
	}

	public void setClientInfo(
			Properties p) throws SQLClientInfoException {
		logger.finer("setClientInfo");
		// ignore it
	}

	public void setClientInfo(String k,
			String v) throws SQLClientInfoException {
		logger.finer("setClientInfo");
		// ignore it
	}

	public void setHoldability(int h) throws SQLException {
		logger.finer("setHoldability");
		throw new SQLFeatureNotSupportedException();
	}

	public void setNetworkTimeout(Executor e,
			int a) throws SQLException {
		logger.finer("setNetworkTimeout");
		throw new SQLFeatureNotSupportedException();
	}

	public void setReadOnly(boolean arg0) throws SQLException {
		logger.finer("setReadOnly");
	}

	public Savepoint setSavepoint() throws SQLException {
		logger.finer("setSavepoint");
		throw new SQLFeatureNotSupportedException();
	}

	public Savepoint setSavepoint(String s) throws SQLException {
		logger.finer("setSavepoint");
		throw new SQLFeatureNotSupportedException();
	}

	public void setTransactionIsolation(
			int level) throws SQLException {
		logger.finer("setTransactionIsolation");
		// ignore it
	}

	public void setTypeMap(
			Map<String, Class<?>> map) throws SQLException {
		logger.finer("setTypeMap");
		throw new SQLFeatureNotSupportedException();
	}

}
