/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class TableRenameRelation extends AbstractRelation
implements NamedRelation {

	//
	private Relation rel;
	private String as;

	public TableRenameRelation(Relation r, String a) {
		rel = r;  as = a;
	}

	/**
	 * @return the relation
	 */
	public Relation getRelation() {
		return rel;
	}

	/**
	 * @return the as
	 */
	public String getName() {
		return as;
	}

	@Override
	public RelationCursor iterator() {
		final RelationCursor i = rel.iterator();

		return new RelationCursor() {

			@Override
			public boolean hasNext() {
				return i.hasNext();
			}

			@Override
			public RelationTuple next(
					) throws IOException, SQLException {
				final RelationTuple r = i.next();

				return new RelationTuple() {

					@Override
					public Object get(String n) throws SQLException {
						int c;

						c = n.indexOf('.');
						if(c < 0) {
							return r.get(n);
						} else {
							return r.get(n.substring(c + 1));
						}
					}

					@Override
					public RelationTuple copy() throws SQLException {
						return new DefaultRelationTuple(toMap());
					}

					@Override
					public Map<String, Object> toMap() throws SQLException {
						List<SqlColumnDefinition> ases = getColumnNames();
						Map<String, Object> m;

						m = new LinkedHashMap<String, Object>();
						for(int i = 0; i < ases.size(); i++) {
							m.put(ases.get(i).getName(),
									get(ases.get(i).getName()));
						}
						return m;
					}

				};
			}

		};
	}

	@Override
	public List<SqlColumnDefinition> getColumnNames() {
		List<SqlColumnDefinition> l = rel.getColumnNames();
		SqlColumnDefinition[] a = new SqlColumnDefinition[l.size()];
		String s;

		for(int i = 0; i < l.size(); i++) {
			s = l.get(i).getName();
			s = s != null ? s : i + "";
			a[i] = new SqlColumnDefinition(
					as + "." + s,
					l.get(i).getType(),
					l.get(i).getAttributes());
		}
		return Arrays.asList(a);
	}

	@Override
	public SqlColumnDefinition getDefinition(String name) {
		return rel.getDefinition(name);
	}

}
