/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;

import net.morilib.db.relations.RelationTuple;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/08/07
 */
public abstract class SqlSelectDistinct {

	public static final SqlSelectDistinct
	DISTINCT = new SqlSelectDistinct() {

		@Override
		public Collection<RelationTuple> create() {
			return new LinkedHashSet<RelationTuple>();
		}

	};

	public static final SqlSelectDistinct
	DEFAULT = new SqlSelectDistinct() {

		@Override
		public Collection<RelationTuple> create() {
			return new ArrayList<RelationTuple>();
		}

	};

	private SqlSelectDistinct() {}

	/**
	 * 
	 * @return
	 */
	public abstract Collection<RelationTuple> create();

}
