/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.relations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.morilib.db.delay.Delay;

public class RelationAggregate {

	private Map<List<Object>, Delay> map;
	private Delay init;

	public RelationAggregate() {
		map = new HashMap<List<Object>, Delay>();
	}

	public void init(Delay d) {
		init = d;
	}

	public void put(List<Object> l, Delay d) {
		map.put(l, d);
	}

	public Delay get(Object l) {
		return map.containsKey(l) ? map.get(l) : init;
	}

	public boolean containsKey(Object l) {
		return map.containsKey(l);
	}

	public Iterable<List<Object>> keySet() {
		return map.keySet();
	}

	public Delay getInit() {
		return init;
	}

	public boolean isEmpty() {
		return map.size() == 0;
	}

}
