/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

public enum SqlBinaryOperator {

	ADD("(+ %s %s)"), SUB("(- %s %s)"),
	MUL("(* %s %s)"), DIV("(/ %s %s)"),
	CONCAT("(|| %s %s)"),
	EQ("(= %s %s)"), NE("(<> %s %s)"),
	LT("(< %s %s)"), LE("(<= %s %s)"),
	GT("(> %s %s)"), GE("(>= %s %s)"),
	AND("(and %s %s)"), OR("(or %s %s)"),
	LIKE("(like %s %s)");

	//
	private String sformat;

	//
	private SqlBinaryOperator(String f) {
		sformat = f;
	}

	/**
	 * 
	 * @param a
	 * @return
	 */
	public String toSExpression(SqlExpression a, SqlExpression b) {
		return String.format(sformat, a.toString(), b.toString());
	}

}
